/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.scheduler;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gephi.visualization.VizArchitecture;
import org.gephi.visualization.VizController;
import org.gephi.visualization.apiimpl.GraphDrawable;
import org.gephi.visualization.apiimpl.Scheduler;
import org.gephi.visualization.apiimpl.VizConfig;
import org.gephi.visualization.opengl.CompatibilityEngine;
import org.gephi.visualization.scheduler.BasicFPSAnimator;

public class CompatibilityScheduler
implements Scheduler,
VizArchitecture {
    AtomicBoolean animating = new AtomicBoolean();
    AtomicBoolean cameraMoved = new AtomicBoolean();
    AtomicBoolean mouseMoved = new AtomicBoolean();
    AtomicBoolean startDrag = new AtomicBoolean();
    AtomicBoolean drag = new AtomicBoolean();
    AtomicBoolean stopDrag = new AtomicBoolean();
    AtomicBoolean mouseClick = new AtomicBoolean();
    private GraphDrawable graphDrawable;
    private CompatibilityEngine engine;
    private VizConfig vizConfig;
    private BasicFPSAnimator displayAnimator;
    private BasicFPSAnimator updateAnimator;
    private float displayFpsLimit = 30.0f;
    private final float updateFpsLimit = 5.0f;
    private final Object worldLock = new Object();

    @Override
    public void initArchitecture() {
        this.graphDrawable = VizController.getInstance().getDrawable();
        this.engine = (CompatibilityEngine)VizController.getInstance().getEngine();
        this.vizConfig = VizController.getInstance().getVizConfig();
    }

    @Override
    public synchronized void start() {
        if (this.displayAnimator != null) {
            this.displayAnimator.shutdown();
        }
        if (this.updateAnimator != null) {
            this.updateAnimator.shutdown();
        }
        this.displayAnimator = new BasicFPSAnimator(new Runnable(){

            @Override
            public void run() {
                CompatibilityScheduler.this.graphDrawable.display();
            }
        }, this.worldLock, "DisplayAnimator", this.displayFpsLimit);
        this.displayAnimator.start();
        this.updateAnimator = new BasicFPSAnimator(new Runnable(){

            @Override
            public void run() {
                CompatibilityScheduler.this.updateWorld();
            }
        }, this.worldLock, "UpdateAnimator", 5.0f);
        this.updateAnimator.start();
    }

    @Override
    public synchronized void stop() {
        this.updateAnimator.shutdown();
        this.displayAnimator.shutdown();
        this.cameraMoved.set(false);
        this.mouseMoved.set(false);
        this.startDrag.set(false);
        this.drag.set(false);
        this.stopDrag.set(false);
        this.mouseClick.set(false);
    }

    @Override
    public boolean isAnimating() {
        return this.displayAnimator != null && this.displayAnimator.isAnimating();
    }

    @Override
    public void display(GL2 gl, GLU glu) {
        boolean execDrag;
        boolean execMouseClick = this.mouseClick.getAndSet(false);
        boolean execMouseMove = this.mouseMoved.getAndSet(false);
        boolean bl = execDrag = this.drag.get() || this.startDrag.get() || this.stopDrag.get();
        if (this.cameraMoved.getAndSet(false)) {
            this.graphDrawable.setCameraPosition(gl, glu);
            this.engine.getOctree().updateVisibleOctant(gl);
            this.engine.updateLOD();
        }
        if (execMouseMove) {
            this.engine.mouseMove();
            this.engine.updateSelection(gl, glu);
        } else if (execDrag) {
            if (this.stopDrag.getAndSet(false)) {
                this.engine.stopDrag();
            }
            if (this.startDrag.getAndSet(false)) {
                this.engine.startDrag();
            }
            if (this.drag.getAndSet(false)) {
                this.engine.mouseDrag();
            }
        }
        if (execMouseClick) {
            this.engine.mouseClick();
        }
        this.engine.beforeDisplay(gl, glu);
        this.engine.display(gl, glu);
        this.engine.afterDisplay(gl, glu);
    }

    @Override
    public void updateWorld() {
        if (this.engine.updateWorld()) {
            this.cameraMoved.set(true);
            this.mouseMoved.set(true);
        }
    }

    @Override
    public void updatePosition() {
    }

    @Override
    public void requireUpdateVisible() {
        this.cameraMoved.set(true);
    }

    @Override
    public void requireUpdateSelection() {
        this.mouseMoved.set(true);
    }

    @Override
    public void requireStartDrag() {
        this.startDrag.set(true);
    }

    @Override
    public void requireDrag() {
        this.drag.set(true);
    }

    @Override
    public void requireStopDrag() {
        this.stopDrag.set(true);
    }

    @Override
    public void requireMouseClick() {
        this.mouseClick.set(true);
    }

    @Override
    public void setFps(float maxFps) {
        this.displayFpsLimit = maxFps;
        if (this.displayAnimator != null) {
            this.displayAnimator.setFps(maxFps);
        }
    }

    @Override
    public float getFps() {
        return this.displayFpsLimit;
    }
}

