/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.actions;

import java.awt.event.ActionEvent;
import javax.swing.RootPaneContainer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.dialogs.relation.IRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTable;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.actions.SavingAction;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;

public class CancelAction
extends SavingAction {
    public CancelAction(MemberTable memberTable, MemberTableModel memberTableModel, TagEditorModel tagModel, OsmDataLayer layer, IRelationEditor editor, AutoCompletingTextField tfRole) {
        super(memberTable, memberTableModel, tagModel, layer, editor, tfRole);
        this.putValue("ShortDescription", I18n.tr("Cancel the updates and close the dialog", new Object[0]));
        new ImageProvider("cancel").getResource().attachImageIcon(this);
        this.putValue("Name", I18n.tr("Cancel", new Object[0]));
        if (editor instanceof RootPaneContainer) {
            InputMapUtils.addEscapeAction(((RootPaneContainer)((Object)editor)).getRootPane(), this);
        }
        this.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.memberTable.stopHighlighting();
        Relation snapshot = this.editor.getRelationSnapshot();
        if (!(this.memberTableModel.hasSameMembersAs(snapshot) && !this.tagModel.isDirty() || snapshot == null && this.tagModel.getTags().isEmpty())) {
            int ret = this.confirmClosingByCancel();
            if (ret == 0) {
                Config.getPref().put("relation.editor.generic.lastrole", this.tfRole.getText());
                if (!this.applyChanges()) {
                    return;
                }
            } else if (ret == 2 || ret == -1) {
                return;
            }
        }
        this.hideEditor();
    }

    protected int confirmClosingByCancel() {
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Yes, save the changes and close", new Object[0]), new ImageProvider("ok"), I18n.tr("Click to save the changes and close this relation editor", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("No, discard the changes and close", new Object[0]), new ImageProvider("cancel"), I18n.tr("Click to discard the changes and close this relation editor", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel, continue editing", new Object[0]), new ImageProvider("cancel"), I18n.tr("Click to return to the relation editor and to resume relation editing", new Object[0]), null)};
        return HelpAwareOptionPane.showOptionDialog(Main.parent, I18n.tr("<html>The relation has been changed.<br><br>Do you want to save your changes?</html>", new Object[0]), I18n.tr("Unsaved changes", new Object[0]), 2, null, options, options[0], "/Dialog/RelationEditor#DiscardChanges");
    }
}

