/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.plugin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.gui.preferences.plugin.PluginCheckBox;
import org.openstreetmap.josm.gui.preferences.plugin.PluginPreferencesModel;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.I18n;

public class PluginListPanel
extends VerticallyScrollablePanel {
    private transient PluginPreferencesModel model;

    public PluginListPanel() {
        this(new PluginPreferencesModel());
    }

    public PluginListPanel(PluginPreferencesModel model) {
        this.model = model;
        this.setLayout(new GridBagLayout());
    }

    protected static String formatPluginRemoteVersion(PluginInformation pi) {
        StringBuilder sb = new StringBuilder();
        if (pi.version == null || pi.version.trim().isEmpty()) {
            sb.append(I18n.tr("unknown", new Object[0]));
        } else {
            sb.append(pi.version);
            if (pi.oldmode) {
                sb.append('*');
            }
        }
        return sb.toString();
    }

    protected static String formatPluginLocalVersion(PluginInformation pi) {
        if (pi == null) {
            return I18n.tr("unknown", new Object[0]);
        }
        if (pi.localversion == null || pi.localversion.trim().isEmpty()) {
            return I18n.tr("unknown", new Object[0]);
        }
        return pi.localversion;
    }

    protected static String formatCheckboxTooltipText(PluginInformation pi) {
        if (pi == null) {
            return "";
        }
        if (pi.downloadlink == null) {
            return I18n.tr("Plugin bundled with JOSM", new Object[0]);
        }
        return pi.downloadlink;
    }

    public void displayEmptyPluginListInformation() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.insets = new Insets(40, 0, 40, 0);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        HtmlPanel hint = new HtmlPanel();
        hint.setText("<html>" + (this.model.getAvailablePlugins().isEmpty() ? I18n.tr("Please click on <strong>Download list</strong> to download and display a list of available plugins.", new Object[0]) : I18n.tr("The filter returned no results.", new Object[0])) + "</html>");
        this.add((Component)hint, gbc);
    }

    public void displayPluginList(List<PluginInformation> displayedPlugins) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        int row = -1;
        for (PluginInformation pi : displayedPlugins) {
            boolean selected = this.model.isSelectedPlugin(pi.getName());
            String remoteversion = PluginListPanel.formatPluginRemoteVersion(pi);
            String localversion = PluginListPanel.formatPluginLocalVersion(this.model.getPluginInformation(pi.getName()));
            PluginCheckBox cbPlugin = new PluginCheckBox(pi, selected, this, this.model);
            String pluginText = I18n.tr("{0}: Version {1} (local: {2})", pi.getName(), remoteversion, localversion);
            if (pi.requires != null && !pi.requires.isEmpty()) {
                pluginText = pluginText + I18n.tr(" (requires: {0})", pi.requires);
            }
            JLabel lblPlugin = new JLabel(pluginText, pi.getScaledIcon(), 2);
            lblPlugin.addMouseListener(new PluginCheckBoxMouseAdapter(cbPlugin));
            gbc.gridx = 0;
            gbc.gridy = ++row;
            gbc.insets = new Insets(5, 5, 0, 5);
            gbc.weighty = 0.0;
            gbc.weightx = 0.0;
            this.add((Component)cbPlugin, gbc);
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            this.add((Component)lblPlugin, gbc);
            HtmlPanel description = new HtmlPanel();
            description.setText(pi.getDescriptionAsHtml());
            description.enableClickableHyperlinks();
            lblPlugin.setLabelFor(description);
            gbc.gridx = 1;
            gbc.gridy = ++row;
            gbc.insets = new Insets(3, 25, 5, 5);
            gbc.weighty = 1.0;
            this.add((Component)description, gbc);
        }
    }

    public void refreshView() {
        Rectangle visibleRect = this.getVisibleRect();
        List<PluginInformation> displayedPlugins = this.model.getDisplayedPlugins();
        this.removeAll();
        if (displayedPlugins.isEmpty()) {
            this.displayEmptyPluginListInformation();
        } else {
            this.displayPluginList(displayedPlugins);
        }
        this.revalidate();
        this.repaint();
        SwingUtilities.invokeLater(() -> this.scrollRectToVisible(visibleRect));
    }

    static final class PluginCheckBoxMouseAdapter
    extends MouseAdapter {
        private final PluginCheckBox cbPlugin;

        PluginCheckBoxMouseAdapter(PluginCheckBox cbPlugin) {
            this.cbPlugin = cbPlugin;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.cbPlugin.doClick();
        }
    }
}

