/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.BatchRequest;
import Ice.BatchRequestInterceptor;
import Ice.BooleanHolder;
import Ice.InitializationData;
import Ice.LocalException;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.OutputStream;
import IceInternal.Buffer;
import IceInternal.Instance;
import IceInternal.Protocol;

public class BatchRequestQueue {
    private BatchRequestInterceptor _interceptor;
    private OutputStream _batchStream;
    private boolean _batchStreamInUse;
    private boolean _batchStreamCanFlush;
    private int _batchRequestNum;
    private int _batchMarker;
    private boolean _batchCompress;
    private BatchRequestI _request;
    private LocalException _exception;
    private int _maxSize;
    private static final int _udpOverhead = 28;

    public BatchRequestQueue(Instance instance, boolean datagram) {
        int udpSndSize;
        InitializationData initData = instance.initializationData();
        this._interceptor = initData.batchRequestInterceptor;
        this._batchStreamInUse = false;
        this._batchRequestNum = 0;
        this._batchStream = new OutputStream(instance, Protocol.currentProtocolEncoding);
        this._batchStream.writeBlob(Protocol.requestBatchHdr);
        this._batchMarker = this._batchStream.size();
        this._batchCompress = false;
        this._request = new BatchRequestI();
        this._maxSize = instance.batchAutoFlushSize();
        if (this._maxSize > 0 && datagram && (udpSndSize = initData.properties.getPropertyAsIntWithDefault("Ice.UDP.SndSize", 65507)) < this._maxSize) {
            this._maxSize = udpSndSize;
        }
    }

    public synchronized void prepareBatchRequest(OutputStream os) {
        if (this._exception != null) {
            throw (LocalException)this._exception.fillInStackTrace();
        }
        this.waitStreamInUse(false);
        this._batchStreamInUse = true;
        this._batchStream.swap(os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishBatchRequest(OutputStream os, ObjectPrx proxy, String operation) {
        assert (this._batchStreamInUse);
        this._batchStream.swap(os);
        try {
            this._batchStreamCanFlush = true;
            if (this._maxSize > 0 && this._batchStream.size() >= this._maxSize) {
                proxy.begin_ice_flushBatchRequests();
            }
            assert (this._batchMarker < this._batchStream.size());
            if (this._interceptor != null) {
                this._request.reset(proxy, operation, this._batchStream.size() - this._batchMarker);
                this._interceptor.enqueue(this._request, this._batchRequestNum, this._batchMarker);
            } else {
                Boolean compress = ((ObjectPrxHelperBase)proxy)._getReference().getCompressOverride();
                if (compress != null) {
                    this._batchCompress |= compress.booleanValue();
                }
                this._batchMarker = this._batchStream.size();
                ++this._batchRequestNum;
            }
        }
        finally {
            BatchRequestQueue batchRequestQueue = this;
            synchronized (batchRequestQueue) {
                this._batchStream.resize(this._batchMarker);
                this._batchStreamInUse = false;
                this._batchStreamCanFlush = false;
                this.notifyAll();
            }
        }
    }

    public synchronized void abortBatchRequest(OutputStream os) {
        if (this._batchStreamInUse) {
            this._batchStream.swap(os);
            this._batchStream.resize(this._batchMarker);
            this._batchStreamInUse = false;
            this.notifyAll();
        }
    }

    public synchronized int swap(OutputStream os, BooleanHolder compress) {
        if (this._batchRequestNum == 0) {
            return 0;
        }
        this.waitStreamInUse(true);
        byte[] lastRequest = null;
        if (this._batchMarker < this._batchStream.size()) {
            lastRequest = new byte[this._batchStream.size() - this._batchMarker];
            Buffer buffer = this._batchStream.getBuffer();
            buffer.b.position(this._batchMarker);
            buffer.b.get(lastRequest);
            this._batchStream.resize(this._batchMarker);
        }
        int requestNum = this._batchRequestNum;
        if (compress != null) {
            compress.value = this._batchCompress;
        }
        this._batchStream.swap(os);
        this._batchRequestNum = 0;
        this._batchCompress = false;
        this._batchStream.writeBlob(Protocol.requestBatchHdr);
        this._batchMarker = this._batchStream.size();
        if (lastRequest != null) {
            this._batchStream.writeBlob(lastRequest);
        }
        return requestNum;
    }

    public synchronized void destroy(LocalException ex) {
        this._exception = ex;
    }

    public synchronized boolean isEmpty() {
        return this._batchStream.size() == Protocol.requestBatchHdr.length;
    }

    private void waitStreamInUse(boolean flush) {
        boolean interrupted = false;
        while (!(!this._batchStreamInUse || flush && this._batchStreamCanFlush)) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private void enqueueBatchRequest(ObjectPrx proxy) {
        assert (this._batchMarker < this._batchStream.size());
        Boolean compress = ((ObjectPrxHelperBase)proxy)._getReference().getCompressOverride();
        if (compress != null) {
            this._batchCompress |= compress.booleanValue();
        }
        this._batchMarker = this._batchStream.size();
        ++this._batchRequestNum;
    }

    class BatchRequestI
    implements BatchRequest {
        private ObjectPrx _proxy;
        private String _operation;
        private int _size;

        BatchRequestI() {
        }

        public void reset(ObjectPrx proxy, String operation, int size) {
            this._proxy = proxy;
            this._operation = operation;
            this._size = size;
        }

        @Override
        public void enqueue() {
            BatchRequestQueue.this.enqueueBatchRequest(this._proxy);
        }

        @Override
        public ObjectPrx getProxy() {
            return this._proxy;
        }

        @Override
        public String getOperation() {
            return this._operation;
        }

        @Override
        public int getSize() {
            return this._size;
        }
    }
}

