/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.authentication;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import net.sf.json.JSONObject;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.view.SessionDialog;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.authentication.AbstractAuthenticationMethodOptionsPanel;
import org.zaproxy.zap.authentication.AbstractCredentialsOptionsPanel;
import org.zaproxy.zap.authentication.AuthenticationCredentials;
import org.zaproxy.zap.authentication.AuthenticationHelper;
import org.zaproxy.zap.authentication.AuthenticationMethod;
import org.zaproxy.zap.authentication.AuthenticationMethodType;
import org.zaproxy.zap.authentication.UsernamePasswordAuthenticationCredentials;
import org.zaproxy.zap.extension.api.ApiDynamicActionImplementor;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.authentication.ContextAuthenticationPanel;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.session.SessionManagementMethod;
import org.zaproxy.zap.session.WebSession;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.ApiUtils;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.LayoutHelper;
import org.zaproxy.zap.view.NodeSelectDialog;
import org.zaproxy.zap.view.popup.PopupMenuItemContext;
import org.zaproxy.zap.view.popup.PopupMenuItemSiteNodeContextMenuFactory;

public class FormBasedAuthenticationMethodType
extends AuthenticationMethodType {
    public static final String CONTEXT_CONFIG_AUTH_FORM = "context.authentication.form";
    public static final String CONTEXT_CONFIG_AUTH_FORM_LOGINURL = "context.authentication.form.loginurl";
    public static final String CONTEXT_CONFIG_AUTH_FORM_LOGINBODY = "context.authentication.form.loginbody";
    private static final int METHOD_IDENTIFIER = 2;
    private static final String METHOD_NAME = Constant.messages.getString("authentication.method.fb.name");
    private static final String API_METHOD_NAME = "formBasedAuthentication";
    private static final Logger log = Logger.getLogger(FormBasedAuthenticationMethodType.class);
    private static final String PARAM_LOGIN_URL = "loginUrl";
    private static final String PARAM_LOGIN_REQUEST_DATA = "loginRequestData";

    private static URI createLoginUrl(String loginData, String username, String password) throws URIException {
        return new URI(FormBasedAuthenticationMethodType.replaceUserData(loginData, username, password), true);
    }

    private static String replaceUserData(String loginData, String username, String password) {
        return loginData.replace("{%username%}", FormBasedAuthenticationMethodType.encodeParameter(username)).replace("{%password%}", FormBasedAuthenticationMethodType.encodeParameter(password));
    }

    private static String encodeParameter(String parameter) {
        try {
            return URLEncoder.encode(parameter, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    private static boolean isValidLoginUrl(String loginUrl) {
        try {
            FormBasedAuthenticationMethodType.createLoginUrl(loginUrl, "", "");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public FormBasedAuthenticationMethod createAuthenticationMethod(int contextId) {
        return new FormBasedAuthenticationMethod();
    }

    @Override
    public String getName() {
        return METHOD_NAME;
    }

    @Override
    public AbstractAuthenticationMethodOptionsPanel buildOptionsPanel(Context uiSharedContext) {
        return new FormBasedAuthenticationMethodOptionsPanel(uiSharedContext);
    }

    @Override
    public boolean hasOptionsPanel() {
        return true;
    }

    @Override
    public AbstractCredentialsOptionsPanel<? extends AuthenticationCredentials> buildCredentialsOptionsPanel(AuthenticationCredentials credentials, Context uiSharedContext) {
        return new UsernamePasswordAuthenticationCredentials.UsernamePasswordAuthenticationCredentialsOptionsPanel((UsernamePasswordAuthenticationCredentials)credentials);
    }

    @Override
    public boolean hasCredentialsOptionsPanel() {
        return true;
    }

    @Override
    public boolean isTypeForMethod(AuthenticationMethod method) {
        return method instanceof FormBasedAuthenticationMethod;
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        extensionHook.getHookMenu().addPopupMenuItem(this.getPopupFlagLoginRequestMenuFactory());
    }

    private PopupMenuItemSiteNodeContextMenuFactory getPopupFlagLoginRequestMenuFactory() {
        PopupMenuItemSiteNodeContextMenuFactory popupFlagLoginRequestMenuFactory = new PopupMenuItemSiteNodeContextMenuFactory(Constant.messages.getString("context.flag.popup")){
            private static final long serialVersionUID = 8927418764L;

            @Override
            public PopupMenuItemContext getContextMenu(Context context, String parentMenu) {
                return new PopupMenuItemContext(context, parentMenu, Constant.messages.getString("authentication.method.fb.popup.login.request", context.getName())){
                    private static final long serialVersionUID = 1967885623005183801L;
                    private ExtensionUserManagement usersExtension;
                    private Context uiSharedContext;

                    private boolean confirmUsersDeletion(Context uiSharedContext) {
                        int choice;
                        this.usersExtension = Control.getSingleton().getExtensionLoader().getExtension(ExtensionUserManagement.class);
                        return this.usersExtension == null || this.usersExtension.getSharedContextUsers(uiSharedContext).size() <= 0 || (choice = JOptionPane.showConfirmDialog(this, Constant.messages.getString("authentication.dialog.confirmChange.label"), Constant.messages.getString("authentication.dialog.confirmChange.title"), 2)) != 2;
                    }

                    @Override
                    public void performAction(SiteNode sn) {
                        SessionDialog sessionDialog = View.getSingleton().getSessionDialog();
                        sessionDialog.recreateUISharedContexts(Model.getSingleton().getSession());
                        this.uiSharedContext = sessionDialog.getUISharedContext(this.getContext().getIndex());
                        if (this.getContext().getAuthenticationMethod() instanceof FormBasedAuthenticationMethod) {
                            log.info((Object)("Selected new login request via PopupMenu. Changing existing Form-Based Authentication instance for Context " + this.getContext().getIndex()));
                            FormBasedAuthenticationMethod method = (FormBasedAuthenticationMethod)this.uiSharedContext.getAuthenticationMethod();
                            try {
                                method.setLoginRequest(sn);
                            }
                            catch (Exception e) {
                                log.error((Object)("Failed to set login request: " + e.getMessage()), (Throwable)e);
                                return;
                            }
                            View.getSingleton().showSessionDialog(Model.getSingleton().getSession(), ContextAuthenticationPanel.buildName(this.getContext().getIndex()), false);
                        } else {
                            log.info((Object)("Selected new login request via PopupMenu. Creating new Form-Based Authentication instance for Context " + this.getContext().getIndex()));
                            FormBasedAuthenticationMethod method = new FormBasedAuthenticationMethod();
                            try {
                                method.setLoginRequest(sn);
                            }
                            catch (Exception e) {
                                log.error((Object)("Failed to set login request: " + e.getMessage()), (Throwable)e);
                                return;
                            }
                            if (!this.confirmUsersDeletion(this.uiSharedContext)) {
                                log.debug((Object)"Cancelled change of authentication type.");
                                return;
                            }
                            this.uiSharedContext.setAuthenticationMethod(method);
                            View.getSingleton().showSessionDialog(Model.getSingleton().getSession(), ContextAuthenticationPanel.buildName(this.getContext().getIndex()), false, new Runnable(){

                                @Override
                                public void run() {
                                    if (usersExtension != null) {
                                        usersExtension.removeSharedContextUsers(uiSharedContext);
                                    }
                                }
                            });
                        }
                    }
                };
            }

            @Override
            public int getParentMenuIndex() {
                return 3;
            }
        };
        return popupFlagLoginRequestMenuFactory;
    }

    @Override
    public AuthenticationMethod loadMethodFromSession(Session session, int contextId) throws DatabaseException {
        FormBasedAuthenticationMethod method = new FormBasedAuthenticationMethod();
        List<String> urls = session.getContextDataStrings(contextId, 201);
        String url = "";
        if (urls != null && urls.size() > 0) {
            url = urls.get(0);
        }
        List<String> postDatas = session.getContextDataStrings(contextId, 202);
        String postData = null;
        if (postDatas != null && postDatas.size() > 0) {
            postData = postDatas.get(0);
        }
        try {
            method.setLoginRequest(url, postData);
        }
        catch (Exception e) {
            log.error((Object)"Unable to load FormBasedAuthenticationMethod. ", (Throwable)e);
        }
        return method;
    }

    @Override
    public void persistMethodToSession(Session session, int contextId, AuthenticationMethod authMethod) throws DatabaseException {
        if (!(authMethod instanceof FormBasedAuthenticationMethod)) {
            throw new AuthenticationMethodType.UnsupportedAuthenticationMethodException("Form based authentication type only supports: " + FormBasedAuthenticationMethod.class);
        }
        FormBasedAuthenticationMethod method = (FormBasedAuthenticationMethod)authMethod;
        session.setContextData(contextId, 201, method.loginRequestURL);
        session.setContextData(contextId, 202, method.loginRequestBody);
    }

    @Override
    public int getUniqueIdentifier() {
        return 2;
    }

    @Override
    public UsernamePasswordAuthenticationCredentials createAuthenticationCredentials() {
        return new UsernamePasswordAuthenticationCredentials();
    }

    @Override
    public ApiDynamicActionImplementor getSetMethodForContextApiAction() {
        return new ApiDynamicActionImplementor(API_METHOD_NAME, new String[]{PARAM_LOGIN_URL}, new String[]{PARAM_LOGIN_REQUEST_DATA}){

            @Override
            public void handleAction(JSONObject params) throws ApiException {
                Context context = ApiUtils.getContextByParamId(params, "contextId");
                String loginUrl = ApiUtils.getNonEmptyStringParam(params, FormBasedAuthenticationMethodType.PARAM_LOGIN_URL);
                if (!FormBasedAuthenticationMethodType.isValidLoginUrl(loginUrl)) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, FormBasedAuthenticationMethodType.PARAM_LOGIN_URL);
                }
                String postData = "";
                if (params.containsKey((Object)FormBasedAuthenticationMethodType.PARAM_LOGIN_REQUEST_DATA)) {
                    postData = params.getString(FormBasedAuthenticationMethodType.PARAM_LOGIN_REQUEST_DATA);
                }
                FormBasedAuthenticationMethod method = FormBasedAuthenticationMethodType.this.createAuthenticationMethod(context.getIndex());
                try {
                    method.setLoginRequest(loginUrl, postData);
                }
                catch (Exception e) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                }
                if (!context.getAuthenticationMethod().isSameType(method)) {
                    AuthenticationMethodType.apiChangedAuthenticationMethodForContext(context.getIndex());
                }
                context.setAuthenticationMethod(method);
            }
        };
    }

    @Override
    public ApiDynamicActionImplementor getSetCredentialsForUserApiAction() {
        return UsernamePasswordAuthenticationCredentials.getSetCredentialsForUserApiAction(this);
    }

    @Override
    public void exportData(Configuration config, AuthenticationMethod authMethod) {
        if (!(authMethod instanceof FormBasedAuthenticationMethod)) {
            throw new AuthenticationMethodType.UnsupportedAuthenticationMethodException("Form based authentication type only supports: " + FormBasedAuthenticationMethod.class.getName());
        }
        FormBasedAuthenticationMethod method = (FormBasedAuthenticationMethod)authMethod;
        config.setProperty(CONTEXT_CONFIG_AUTH_FORM_LOGINURL, (Object)method.loginRequestURL);
        config.setProperty(CONTEXT_CONFIG_AUTH_FORM_LOGINBODY, (Object)method.loginRequestBody);
    }

    @Override
    public void importData(Configuration config, AuthenticationMethod authMethod) throws ConfigurationException {
        if (!(authMethod instanceof FormBasedAuthenticationMethod)) {
            throw new AuthenticationMethodType.UnsupportedAuthenticationMethodException("Form based authentication type only supports: " + FormBasedAuthenticationMethod.class.getName());
        }
        FormBasedAuthenticationMethod method = (FormBasedAuthenticationMethod)authMethod;
        try {
            method.setLoginRequest(config.getString(CONTEXT_CONFIG_AUTH_FORM_LOGINURL), config.getString(CONTEXT_CONFIG_AUTH_FORM_LOGINBODY));
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    private static class HtmlParameterRenderer
    extends BasicComboBoxRenderer {
        private static final long serialVersionUID = 3654541772447187317L;
        private static final Border BORDER = new EmptyBorder(2, 3, 3, 3);

        private HtmlParameterRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                this.setBorder(BORDER);
                HtmlParameter item = (HtmlParameter)value;
                this.setText(item.getName());
            }
            return this;
        }
    }

    private static class FormBasedAuthenticationMethodOptionsPanel
    extends AbstractAuthenticationMethodOptionsPanel {
        private static final long serialVersionUID = -9010956260384814566L;
        private static final String POST_DATA_LABEL = Constant.messages.getString("authentication.method.fb.field.label.postData");
        private static final String USERNAME_PARAM_LABEL = Constant.messages.getString("authentication.method.fb.field.label.usernameParam");
        private static final String PASSWORD_PARAM_LABEL = Constant.messages.getString("authentication.method.fb.field.label.passwordParam");
        private static final String LOGIN_URL_LABEL = Constant.messages.getString("authentication.method.fb.field.label.loginUrl");
        private static final String AUTH_DESCRIPTION = Constant.messages.getString("authentication.method.fb.field.label.description");
        private ZapTextField loginUrlField;
        private ZapTextField postDataField;
        private JComboBox<HtmlParameter> usernameParameterCombo;
        private JComboBox<HtmlParameter> passwordParameterCombo;
        private FormBasedAuthenticationMethod authenticationMethod;
        private Context context;
        private ExtensionUserManagement userExt = null;

        public FormBasedAuthenticationMethodOptionsPanel(Context context) {
            this.initialize();
            this.context = context;
        }

        private void initialize() {
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel(LOGIN_URL_LABEL), LayoutHelper.getGBC(0, 0, 2, 1.0, 0.0));
            JPanel urlSelectPanel = new JPanel(new GridBagLayout());
            this.loginUrlField = new ZapTextField();
            this.postDataField = new ZapTextField();
            JButton selectButton = new JButton(Constant.messages.getString("all.button.select"));
            selectButton.setIcon(new ImageIcon(View.class.getResource("/resource/icon/16/094.png")));
            selectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NodeSelectDialog nsd = new NodeSelectDialog((Window)View.getSingleton().getMainFrame());
                    SiteNode node = null;
                    if (loginUrlField.getText().trim().length() > 0) {
                        try {
                            node = postDataField.getText().trim().length() > 0 ? Model.getSingleton().getSession().getSiteTree().findNode(new URI(loginUrlField.getText(), false), "POST", postDataField.getText()) : Model.getSingleton().getSession().getSiteTree().findNode(new URI(loginUrlField.getText(), false));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if ((node = nsd.showDialog(node)) != null && node.getHistoryReference() != null) {
                        try {
                            if (log.isInfoEnabled()) {
                                log.info((Object)("Selected Form Based Auth Login URL via dialog: " + node.getHistoryReference().getURI().toString()));
                            }
                            loginUrlField.setText(node.getHistoryReference().getURI().toString());
                            postDataField.setText(node.getHistoryReference().getHttpMessage().getRequestBody().toString());
                            this.updateParameters();
                        }
                        catch (Exception e1) {
                            log.error((Object)e1.getMessage(), (Throwable)e1);
                        }
                    }
                }
            });
            urlSelectPanel.add((Component)this.loginUrlField, LayoutHelper.getGBC(0, 0, 1, 1.0));
            urlSelectPanel.add((Component)selectButton, LayoutHelper.getGBC(1, 0, 1, 0.0));
            this.add((Component)urlSelectPanel, LayoutHelper.getGBC(0, 1, 2, 1.0, 0.0));
            this.add((Component)new JLabel(POST_DATA_LABEL), LayoutHelper.getGBC(0, 2, 2, 1.0, 0.0));
            this.add((Component)this.postDataField, LayoutHelper.getGBC(0, 3, 2, 1.0, 0.0));
            this.add((Component)new JLabel(USERNAME_PARAM_LABEL), LayoutHelper.getGBC(0, 4, 1, 1.0, 0.0));
            this.usernameParameterCombo = new JComboBox();
            this.usernameParameterCombo.setRenderer(new HtmlParameterRenderer());
            this.add(this.usernameParameterCombo, LayoutHelper.getGBC(0, 5, 1, 1.0, 0.0));
            this.add((Component)new JLabel(PASSWORD_PARAM_LABEL), LayoutHelper.getGBC(1, 4, 1, 1.0, 0.0));
            this.passwordParameterCombo = new JComboBox();
            this.passwordParameterCombo.setRenderer(new HtmlParameterRenderer());
            this.add(this.passwordParameterCombo, LayoutHelper.getGBC(1, 5, 1, 1.0, 0.0));
            this.add((Component)new JLabel(AUTH_DESCRIPTION), LayoutHelper.getGBC(0, 8, 2, 1.0, 0.0));
            this.postDataField.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    this.updateParameters();
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
        }

        @Override
        public void validateFields() {
            if (!FormBasedAuthenticationMethodType.isValidLoginUrl(this.loginUrlField.getText())) {
                this.loginUrlField.requestFocusInWindow();
                throw new IllegalStateException(Constant.messages.getString("authentication.method.fb.dialog.error.url.text"));
            }
        }

        private String replaceParameterValue(String originalString, HtmlParameter parameter, String replaceString) {
            String keyValueSeparator = this.context.getPostParamParser().getDefaultKeyValueSeparator();
            String nameAndSeparator = parameter.getName() + keyValueSeparator;
            if (originalString.contains(nameAndSeparator)) {
                return originalString.replace(nameAndSeparator + parameter.getValue(), nameAndSeparator + replaceString);
            }
            return originalString.replace(parameter.getName(), nameAndSeparator + replaceString);
        }

        private ExtensionUserManagement getUserExt() {
            if (this.userExt == null) {
                this.userExt = Control.getSingleton().getExtensionLoader().getExtension(ExtensionUserManagement.class);
            }
            return this.userExt;
        }

        @Override
        public void saveMethod() {
            try {
                String postData = this.postDataField.getText();
                if (!postData.isEmpty()) {
                    HtmlParameter userParam = (HtmlParameter)this.usernameParameterCombo.getSelectedItem();
                    HtmlParameter passwdParam = (HtmlParameter)this.passwordParameterCombo.getSelectedItem();
                    ExtensionUserManagement userExt = this.getUserExt();
                    if (userExt != null && userExt.getUIConfiguredUsers(this.context.getIndex()).size() == 0 && !userParam.getValue().contains("{%username%}") && !passwdParam.getValue().contains("{%password%}")) {
                        String userStr = URLDecoder.decode(userParam.getValue(), "UTF8");
                        String passwdStr = URLDecoder.decode(passwdParam.getValue(), "UTF8");
                        User user = new User(this.context.getIndex(), userStr);
                        UsernamePasswordAuthenticationCredentials upac = new UsernamePasswordAuthenticationCredentials(userStr, passwdStr);
                        user.setAuthenticationCredentials(upac);
                        this.getUserExt().getContextUserAuthManager(this.context.getIndex()).addUser(user);
                    }
                    postData = this.replaceParameterValue(postData, userParam, "{%username%}");
                    postData = this.replaceParameterValue(postData, passwdParam, "{%password%}");
                }
                this.getMethod().setLoginRequest(this.loginUrlField.getText(), postData);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public void bindMethod(AuthenticationMethod method) {
            this.authenticationMethod = (FormBasedAuthenticationMethod)method;
            this.loginUrlField.setText(this.authenticationMethod.loginRequestURL);
            this.postDataField.setText(this.authenticationMethod.loginRequestBody);
            this.updateParameters();
        }

        private int getIndexOfParamWithValue(HtmlParameter[] params, String value) {
            for (int i = 0; i < params.length; ++i) {
                if (!params[i].getValue().equals(value)) continue;
                return i;
            }
            return -1;
        }

        private void updateParameters() {
            try {
                Map<String, String> params = this.context.getPostParamParser().parse(this.postDataField.getText());
                HtmlParameter[] paramsArray = this.mapToParamArray(params);
                this.usernameParameterCombo.setModel(new DefaultComboBoxModel<HtmlParameter>(paramsArray));
                this.passwordParameterCombo.setModel(new DefaultComboBoxModel<HtmlParameter>(paramsArray));
                int index = this.getIndexOfParamWithValue(paramsArray, "{%username%}");
                if (index >= 0) {
                    this.usernameParameterCombo.setSelectedIndex(index);
                }
                if ((index = this.getIndexOfParamWithValue(paramsArray, "{%password%}")) >= 0) {
                    this.passwordParameterCombo.setSelectedIndex(index);
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }

        private HtmlParameter[] mapToParamArray(Map<String, String> map) {
            HtmlParameter[] array = new HtmlParameter[map.size()];
            int i = 0;
            for (Map.Entry<String, String> param : map.entrySet()) {
                array[i++] = new HtmlParameter(HtmlParameter.Type.form, param.getKey(), param.getValue());
            }
            return array;
        }

        @Override
        public FormBasedAuthenticationMethod getMethod() {
            return this.authenticationMethod;
        }
    }

    public static class FormBasedAuthenticationMethod
    extends AuthenticationMethod {
        private static final String LOGIN_ICON_RESOURCE = "/resource/icon/fugue/door-open-green-arrow.png";
        public static final String MSG_USER_PATTERN = "{%username%}";
        public static final String MSG_PASS_PATTERN = "{%password%}";
        private HttpSender httpSender;
        private SiteNode markedLoginSiteNode;
        private SiteNode loginSiteNode = null;
        private String loginRequestURL;
        private String loginRequestBody;

        @Override
        public boolean isConfigured() {
            return this.loginRequestURL != null && !this.loginRequestURL.isEmpty();
        }

        @Override
        public AuthenticationCredentials createAuthenticationCredentials() {
            return new UsernamePasswordAuthenticationCredentials();
        }

        @Override
        public AuthenticationMethodType getType() {
            return new FormBasedAuthenticationMethodType();
        }

        protected HttpSender getHttpSender() {
            if (this.httpSender == null) {
                this.httpSender = new HttpSender(Model.getSingleton().getOptionsParam().getConnectionParam(), true, 5);
            }
            return this.httpSender;
        }

        private HttpMessage prepareRequestMessage(UsernamePasswordAuthenticationCredentials credentials) throws URIException, HttpMalformedHeaderException, DatabaseException {
            HttpMessage requestMessage;
            URI requestURI = FormBasedAuthenticationMethodType.createLoginUrl(this.loginRequestURL, credentials.getUsername(), credentials.getPassword());
            String requestBody = null;
            if (this.loginRequestBody != null && !this.loginRequestBody.isEmpty()) {
                requestBody = FormBasedAuthenticationMethodType.replaceUserData(this.loginRequestBody, credentials.getUsername(), credentials.getPassword());
            }
            if (this.loginSiteNode != null) {
                requestMessage = this.loginSiteNode.getHistoryReference().getHttpMessage().cloneRequest();
                requestMessage.getRequestHeader().setURI(requestURI);
                if (requestBody != null) {
                    requestMessage.getRequestBody().setBody(requestBody);
                    requestMessage.getRequestHeader().setHeader("Content-Length", null);
                }
            } else {
                String method = requestBody != null ? "POST" : "GET";
                requestMessage = new HttpMessage();
                requestMessage.setRequestHeader(new HttpRequestHeader(method, requestURI, "HTTP/1.0", Model.getSingleton().getOptionsParam().getConnectionParam()));
                if (requestBody != null) {
                    requestMessage.getRequestBody().setBody(requestBody);
                }
            }
            return requestMessage;
        }

        @Override
        public WebSession authenticate(SessionManagementMethod sessionManagementMethod, AuthenticationCredentials credentials, User user) throws AuthenticationMethod.UnsupportedAuthenticationCredentialsException {
            HttpMessage msg;
            if (!(credentials instanceof UsernamePasswordAuthenticationCredentials)) {
                throw new AuthenticationMethod.UnsupportedAuthenticationCredentialsException("Form based authentication method only supports " + UsernamePasswordAuthenticationCredentials.class.getSimpleName() + ". Received: " + credentials.getClass());
            }
            UsernamePasswordAuthenticationCredentials cred = (UsernamePasswordAuthenticationCredentials)credentials;
            if (!cred.isConfigured()) {
                log.warn((Object)("No credentials to authenticate user: " + user.getName()));
                return null;
            }
            try {
                msg = this.prepareRequestMessage(cred);
            }
            catch (Exception e) {
                log.error((Object)("Unable to prepare authentication message: " + e.getMessage()), (Throwable)e);
                return null;
            }
            if (user.getAuthenticatedSession() == null) {
                user.setAuthenticatedSession(sessionManagementMethod.createEmptyWebSession());
            }
            msg.setRequestingUser(user);
            msg.getRequestHeader().setHeader("Cookie", null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Authentication request header: \n" + msg.getRequestHeader()));
                if (!msg.getRequestHeader().getMethod().equals("GET")) {
                    log.debug((Object)("Authentication request body: \n" + msg.getRequestBody()));
                }
            }
            try {
                this.getHttpSender().sendAndReceive(msg);
            }
            catch (IOException e) {
                log.error((Object)("Unable to send authentication message: " + e.getMessage()));
                return null;
            }
            if (this.isAuthenticated(msg)) {
                AuthenticationHelper.notifyOutputAuthSuccessful(msg);
            } else {
                AuthenticationHelper.notifyOutputAuthFailure(msg);
            }
            AuthenticationHelper.addAuthMessageToHistory(msg);
            return sessionManagementMethod.extractWebSession(msg);
        }

        public void setLoginRequest(SiteNode loginSiteNode) throws Exception {
            this.loginSiteNode = loginSiteNode;
            HttpMessage requestMessage = loginSiteNode.getHistoryReference().getHttpMessage();
            this.loginRequestURL = requestMessage.getRequestHeader().getURI().toString();
            this.loginRequestBody = !requestMessage.getRequestHeader().getMethod().equalsIgnoreCase("GET") ? requestMessage.getRequestBody().toString() : null;
        }

        public String getLoginRequestURL() {
            return this.loginRequestURL;
        }

        private void markLoginSiteNode(SiteNode sn) {
            if (this.markedLoginSiteNode == sn) {
                return;
            }
            if (this.markedLoginSiteNode != null) {
                this.markedLoginSiteNode.removeCustomIcon(LOGIN_ICON_RESOURCE);
            }
            this.markedLoginSiteNode = sn;
            if (sn == null) {
                return;
            }
            sn.addCustomIcon(LOGIN_ICON_RESOURCE, false);
        }

        protected void setLoginRequest(String url, String postData) throws Exception {
            if (url == null || url.length() == 0) {
                this.loginRequestURL = null;
                this.loginRequestBody = null;
                this.loginSiteNode = null;
            } else {
                String method = "GET";
                if (postData != null && postData.length() > 0) {
                    method = "POST";
                }
                this.loginRequestURL = url;
                this.loginRequestBody = postData;
                URI uri = FormBasedAuthenticationMethodType.createLoginUrl(this.loginRequestURL, "", "");
                this.loginSiteNode = Model.getSingleton().getSession().getSiteTree().findNode(uri, method, postData);
            }
        }

        public String toString() {
            return "FormBasedAuthenticationMethod [loginURI=" + this.loginRequestURL + "]";
        }

        @Override
        public FormBasedAuthenticationMethod duplicate() {
            FormBasedAuthenticationMethod clonedMethod = new FormBasedAuthenticationMethod();
            clonedMethod.loginRequestURL = this.loginRequestURL;
            clonedMethod.loginRequestBody = this.loginRequestBody;
            clonedMethod.loginSiteNode = this.loginSiteNode;
            clonedMethod.markedLoginSiteNode = this.markedLoginSiteNode;
            return clonedMethod;
        }

        @Override
        public void onMethodPersisted() {
            this.markLoginSiteNode(this.loginSiteNode);
        }

        @Override
        public void onMethodDiscarded() {
            this.markLoginSiteNode(null);
        }

        @Override
        public ApiResponse getApiResponseRepresentation() {
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("methodName", FormBasedAuthenticationMethodType.API_METHOD_NAME);
            values.put(FormBasedAuthenticationMethodType.PARAM_LOGIN_URL, this.loginRequestURL);
            values.put(FormBasedAuthenticationMethodType.PARAM_LOGIN_REQUEST_DATA, this.loginRequestBody);
            return new ApiResponseSet("method", values);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.loginRequestBody == null ? 0 : this.loginRequestBody.hashCode());
            result = 31 * result + (this.loginRequestURL == null ? 0 : this.loginRequestURL.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FormBasedAuthenticationMethod other = (FormBasedAuthenticationMethod)obj;
            if (this.loginRequestBody == null ? other.loginRequestBody != null : !this.loginRequestBody.equals(other.loginRequestBody)) {
                return false;
            }
            return !(this.loginRequestURL == null ? other.loginRequestURL != null : !this.loginRequestURL.equals(other.loginRequestURL));
        }
    }
}

