/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.spider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordHistory;
import org.parosproxy.paros.db.TableHistory;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.spider.ExtensionSpider;
import org.zaproxy.zap.extension.spider.SpiderResource;
import org.zaproxy.zap.extension.spider.SpiderScan;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.GenericScanner2;
import org.zaproxy.zap.model.SessionStructure;
import org.zaproxy.zap.model.StructuralNode;
import org.zaproxy.zap.model.Target;
import org.zaproxy.zap.spider.DomainAlwaysInScopeMatcher;
import org.zaproxy.zap.spider.filters.HttpPrefixFetchFilter;
import org.zaproxy.zap.spider.filters.MaxChildrenFetchFilter;
import org.zaproxy.zap.spider.filters.MaxChildrenParseFilter;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.ApiUtils;

public class SpiderAPI
extends ApiImplementor {
    private static final Logger log = Logger.getLogger(SpiderAPI.class);
    private static final String PREFIX = "spider";
    private static final String ACTION_START_SCAN = "scan";
    private static final String ACTION_START_SCAN_AS_USER = "scanAsUser";
    private static final String ACTION_PAUSE_SCAN = "pause";
    private static final String ACTION_RESUME_SCAN = "resume";
    private static final String ACTION_STOP_SCAN = "stop";
    private static final String ACTION_PAUSE_ALL_SCANS = "pauseAllScans";
    private static final String ACTION_RESUME_ALL_SCANS = "resumeAllScans";
    private static final String ACTION_STOP_ALL_SCANS = "stopAllScans";
    private static final String ACTION_REMOVE_SCAN = "removeScan";
    private static final String ACTION_REMOVE_ALL_SCANS = "removeAllScans";
    private static final String ACTION_ADD_DOMAIN_ALWAYS_IN_SCOPE = "addDomainAlwaysInScope";
    private static final String ACTION_MODIFY_DOMAIN_ALWAYS_IN_SCOPE = "modifyDomainAlwaysInScope";
    private static final String ACTION_REMOVE_DOMAIN_ALWAYS_IN_SCOPE = "removeDomainAlwaysInScope";
    private static final String ACTION_ENABLE_ALL_DOMAINS_ALWAYS_IN_SCOPE = "enableAllDomainsAlwaysInScope";
    private static final String ACTION_DISABLE_ALL_DOMAINS_ALWAYS_IN_SCOPE = "disableAllDomainsAlwaysInScope";
    private static final String VIEW_STATUS = "status";
    private static final String VIEW_RESULTS = "results";
    private static final String VIEW_FULL_RESULTS = "fullResults";
    private static final String VIEW_SCANS = "scans";
    private static final String VIEW_ALL_URLS = "allUrls";
    private static final String VIEW_ADDED_NODES = "addedNodes";
    private static final String VIEW_DOMAINS_ALWAYS_IN_SCOPE = "domainsAlwaysInScope";
    private static final String VIEW_OPTION_DOMAINS_ALWAYS_IN_SCOPE = "optionDomainsAlwaysInScope";
    private static final String VIEW_OPTION_DOMAINS_ALWAYS_IN_SCOPE_ENABLED = "optionDomainsAlwaysInScopeEnabled";
    private static final String PARAM_URL = "url";
    private static final String PARAM_USER_ID = "userId";
    private static final String PARAM_CONTEXT_ID = "contextId";
    private static final String PARAM_CONTEXT_NAME = "contextName";
    private static final String PARAM_REGEX = "regex";
    private static final String PARAM_RECURSE = "recurse";
    private static final String PARAM_SCAN_ID = "scanId";
    private static final String PARAM_MAX_CHILDREN = "maxChildren";
    private static final String PARAM_SUBTREE_ONLY = "subtreeOnly";
    private static final String PARAM_VALUE = "value";
    private static final String PARAM_IDX = "idx";
    private static final String PARAM_IS_REGEX = "isRegex";
    private static final String PARAM_IS_ENABLED = "isEnabled";
    private static final String ACTION_EXCLUDE_FROM_SCAN = "excludeFromScan";
    private static final String ACTION_CLEAR_EXCLUDED_FROM_SCAN = "clearExcludedFromScan";
    private static final String VIEW_EXCLUDED_FROM_SCAN = "excludedFromScan";
    private ExtensionSpider extension;

    public SpiderAPI(ExtensionSpider extension) {
        this.extension = extension;
        this.addApiAction(new ApiAction(ACTION_START_SCAN, null, new String[]{PARAM_URL, PARAM_MAX_CHILDREN, PARAM_RECURSE, PARAM_CONTEXT_NAME, PARAM_SUBTREE_ONLY}));
        this.addApiAction(new ApiAction(ACTION_START_SCAN_AS_USER, new String[]{PARAM_CONTEXT_ID, PARAM_USER_ID}, new String[]{PARAM_URL, PARAM_MAX_CHILDREN, PARAM_RECURSE, PARAM_SUBTREE_ONLY}));
        this.addApiAction(new ApiAction(ACTION_PAUSE_SCAN, new String[]{PARAM_SCAN_ID}));
        this.addApiAction(new ApiAction(ACTION_RESUME_SCAN, new String[]{PARAM_SCAN_ID}));
        this.addApiAction(new ApiAction(ACTION_STOP_SCAN, null, new String[]{PARAM_SCAN_ID}));
        this.addApiAction(new ApiAction(ACTION_REMOVE_SCAN, new String[]{PARAM_SCAN_ID}));
        this.addApiAction(new ApiAction(ACTION_PAUSE_ALL_SCANS));
        this.addApiAction(new ApiAction(ACTION_RESUME_ALL_SCANS));
        this.addApiAction(new ApiAction(ACTION_STOP_ALL_SCANS));
        this.addApiAction(new ApiAction(ACTION_REMOVE_ALL_SCANS));
        this.addApiAction(new ApiAction(ACTION_CLEAR_EXCLUDED_FROM_SCAN));
        this.addApiAction(new ApiAction(ACTION_EXCLUDE_FROM_SCAN, new String[]{PARAM_REGEX}));
        this.addApiAction(new ApiAction(ACTION_ADD_DOMAIN_ALWAYS_IN_SCOPE, new String[]{PARAM_VALUE}, new String[]{PARAM_IS_REGEX, PARAM_IS_ENABLED}));
        this.addApiAction(new ApiAction(ACTION_MODIFY_DOMAIN_ALWAYS_IN_SCOPE, new String[]{PARAM_IDX}, new String[]{PARAM_VALUE, PARAM_IS_REGEX, PARAM_IS_ENABLED}));
        this.addApiAction(new ApiAction(ACTION_REMOVE_DOMAIN_ALWAYS_IN_SCOPE, new String[]{PARAM_IDX}));
        this.addApiAction(new ApiAction(ACTION_ENABLE_ALL_DOMAINS_ALWAYS_IN_SCOPE));
        this.addApiAction(new ApiAction(ACTION_DISABLE_ALL_DOMAINS_ALWAYS_IN_SCOPE));
        this.addApiView(new ApiView(VIEW_STATUS, null, new String[]{PARAM_SCAN_ID}));
        this.addApiView(new ApiView(VIEW_RESULTS, null, new String[]{PARAM_SCAN_ID}));
        this.addApiView(new ApiView(VIEW_FULL_RESULTS, new String[]{PARAM_SCAN_ID}));
        this.addApiView(new ApiView(VIEW_SCANS));
        this.addApiView(new ApiView(VIEW_EXCLUDED_FROM_SCAN));
        this.addApiView(new ApiView(VIEW_ALL_URLS));
        this.addApiView(new ApiView(VIEW_ADDED_NODES, null, new String[]{PARAM_SCAN_ID}));
        this.addApiView(new ApiView(VIEW_DOMAINS_ALWAYS_IN_SCOPE));
        ApiView view = new ApiView(VIEW_OPTION_DOMAINS_ALWAYS_IN_SCOPE);
        view.setDeprecated(true);
        this.addApiView(view);
        view = new ApiView(VIEW_OPTION_DOMAINS_ALWAYS_IN_SCOPE_ENABLED);
        view.setDeprecated(true);
        this.addApiView(view);
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public ApiResponse handleApiAction(String name, JSONObject params) throws ApiException {
        log.debug((Object)("Request for handleApiAction: " + name + " (params: " + params.toString() + ")"));
        int maxChildren = -1;
        Context context = null;
        switch (name) {
            case "scan": {
                String contextName;
                String maxChildrenStr;
                String url = ApiUtils.getOptionalStringParam(params, PARAM_URL);
                if (params.containsKey((Object)PARAM_MAX_CHILDREN) && (maxChildrenStr = params.getString(PARAM_MAX_CHILDREN)) != null && maxChildrenStr.length() > 0) {
                    try {
                        maxChildren = Integer.parseInt(maxChildrenStr);
                    }
                    catch (NumberFormatException e) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_MAX_CHILDREN);
                    }
                }
                if (params.containsKey((Object)PARAM_CONTEXT_NAME) && !(contextName = params.getString(PARAM_CONTEXT_NAME)).isEmpty()) {
                    context = ApiUtils.getContextByName(contextName);
                }
                int scanId = this.scanURL(url, null, maxChildren, this.getParam(params, PARAM_RECURSE, true), context, this.getParam(params, PARAM_SUBTREE_ONLY, false));
                return new ApiResponseElement(name, Integer.toString(scanId));
            }
            case "scanAsUser": {
                String maxChildrenStr;
                String urlUserScan = ApiUtils.getOptionalStringParam(params, PARAM_URL);
                int userID = ApiUtils.getIntParam(params, PARAM_USER_ID);
                ExtensionUserManagement usersExtension = Control.getSingleton().getExtensionLoader().getExtension(ExtensionUserManagement.class);
                if (usersExtension == null) {
                    throw new ApiException(ApiException.Type.NO_IMPLEMENTOR, "ExtensionUserManagement");
                }
                context = ApiUtils.getContextByParamId(params, PARAM_CONTEXT_ID);
                User user = usersExtension.getContextUserAuthManager(context.getIndex()).getUserById(userID);
                if (user == null) {
                    throw new ApiException(ApiException.Type.USER_NOT_FOUND, PARAM_USER_ID);
                }
                if (params.containsKey((Object)PARAM_MAX_CHILDREN) && (maxChildrenStr = params.getString(PARAM_MAX_CHILDREN)) != null && maxChildrenStr.length() > 0) {
                    try {
                        maxChildren = Integer.parseInt(maxChildrenStr);
                    }
                    catch (NumberFormatException e) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_MAX_CHILDREN);
                    }
                }
                int scanId = this.scanURL(urlUserScan, user, maxChildren, this.getParam(params, PARAM_RECURSE, true), context, this.getParam(params, PARAM_SUBTREE_ONLY, false));
                return new ApiResponseElement(name, Integer.toString(scanId));
            }
            case "pause": {
                GenericScanner2 scan = this.getSpiderScan(params);
                if (scan == null) {
                    throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_SCAN_ID);
                }
                this.extension.pauseScan(scan.getScanId());
                break;
            }
            case "resume": {
                GenericScanner2 scan = this.getSpiderScan(params);
                if (scan == null) {
                    throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_SCAN_ID);
                }
                this.extension.resumeScan(scan.getScanId());
                break;
            }
            case "stop": {
                GenericScanner2 scan = this.getSpiderScan(params);
                if (scan == null) {
                    throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_SCAN_ID);
                }
                this.extension.stopScan(scan.getScanId());
                break;
            }
            case "removeScan": {
                GenericScanner2 scan = this.getSpiderScan(params);
                if (scan == null) {
                    throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_SCAN_ID);
                }
                this.extension.removeScan(scan.getScanId());
                break;
            }
            case "pauseAllScans": {
                this.extension.pauseAllScans();
                break;
            }
            case "resumeAllScans": {
                this.extension.resumeAllScans();
                break;
            }
            case "stopAllScans": {
                this.extension.stopAllScans();
                break;
            }
            case "removeAllScans": {
                this.extension.removeAllScans();
                break;
            }
            case "clearExcludedFromScan": {
                try {
                    Session session = Model.getSingleton().getSession();
                    session.setExcludeFromSpiderRegexs(new ArrayList<String>());
                    break;
                }
                catch (DatabaseException e) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                }
            }
            case "excludeFromScan": {
                String regex = params.getString(PARAM_REGEX);
                try {
                    Session session = Model.getSingleton().getSession();
                    session.addExcludeFromSpiderRegex(regex);
                    break;
                }
                catch (DatabaseException e) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                }
                catch (PatternSyntaxException e) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_REGEX);
                }
            }
            case "addDomainAlwaysInScope": {
                try {
                    String value = params.getString(PARAM_VALUE);
                    DomainAlwaysInScopeMatcher domainAlwaysInScope = this.getParam(params, PARAM_IS_REGEX, false) ? new DomainAlwaysInScopeMatcher(DomainAlwaysInScopeMatcher.createPattern(value)) : new DomainAlwaysInScopeMatcher(value);
                    domainAlwaysInScope.setEnabled(this.getParam(params, PARAM_IS_ENABLED, true));
                    ArrayList<DomainAlwaysInScopeMatcher> domainsAlwaysInScope = new ArrayList<DomainAlwaysInScopeMatcher>(this.extension.getSpiderParam().getDomainsAlwaysInScope());
                    domainsAlwaysInScope.add(domainAlwaysInScope);
                    this.extension.getSpiderParam().setDomainsAlwaysInScope(domainsAlwaysInScope);
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_VALUE, e);
                }
            }
            case "modifyDomainAlwaysInScope": {
                try {
                    int idx = params.getInt(PARAM_IDX);
                    if (idx < 0 || idx >= this.extension.getSpiderParam().getDomainsAlwaysInScope().size()) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_IDX);
                    }
                    DomainAlwaysInScopeMatcher oldDomain = this.extension.getSpiderParam().getDomainsAlwaysInScope().get(idx);
                    String value = this.getParam(params, PARAM_VALUE, oldDomain.getValue());
                    if (value.isEmpty()) {
                        value = oldDomain.getValue();
                    }
                    DomainAlwaysInScopeMatcher newDomain = this.getParam(params, PARAM_IS_REGEX, oldDomain.isRegex()) ? new DomainAlwaysInScopeMatcher(DomainAlwaysInScopeMatcher.createPattern(value)) : new DomainAlwaysInScopeMatcher(value);
                    newDomain.setEnabled(this.getParam(params, PARAM_IS_ENABLED, oldDomain.isEnabled()));
                    if (oldDomain.equals(newDomain)) break;
                    ArrayList<DomainAlwaysInScopeMatcher> domainsAlwaysInScope = new ArrayList<DomainAlwaysInScopeMatcher>(this.extension.getSpiderParam().getDomainsAlwaysInScope());
                    domainsAlwaysInScope.set(idx, newDomain);
                    this.extension.getSpiderParam().setDomainsAlwaysInScope(domainsAlwaysInScope);
                    break;
                }
                catch (JSONException e) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_IDX, e);
                }
                catch (IllegalArgumentException e) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_VALUE, e);
                }
            }
            case "removeDomainAlwaysInScope": {
                try {
                    int idx = params.getInt(PARAM_IDX);
                    if (idx < 0 || idx >= this.extension.getSpiderParam().getDomainsAlwaysInScope().size()) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_IDX);
                    }
                    ArrayList<DomainAlwaysInScopeMatcher> domainsAlwaysInScope = new ArrayList<DomainAlwaysInScopeMatcher>(this.extension.getSpiderParam().getDomainsAlwaysInScope());
                    domainsAlwaysInScope.remove(idx);
                    this.extension.getSpiderParam().setDomainsAlwaysInScope(domainsAlwaysInScope);
                    break;
                }
                catch (JSONException e) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_IDX, e);
                }
            }
            case "enableAllDomainsAlwaysInScope": {
                this.setDomainsAlwaysInScopeEnabled(true);
                break;
            }
            case "disableAllDomainsAlwaysInScope": {
                this.setDomainsAlwaysInScopeEnabled(false);
                break;
            }
            default: {
                throw new ApiException(ApiException.Type.BAD_ACTION);
            }
        }
        return ApiResponseElement.OK;
    }

    private void setDomainsAlwaysInScopeEnabled(boolean enabled) {
        List<DomainAlwaysInScopeMatcher> domainsAlwaysInScope = this.extension.getSpiderParam().getDomainsAlwaysInScope();
        for (DomainAlwaysInScopeMatcher x : this.extension.getSpiderParam().getDomainsAlwaysInScope()) {
            x.setEnabled(enabled);
        }
        this.extension.getSpiderParam().setDomainsAlwaysInScope(domainsAlwaysInScope);
    }

    private GenericScanner2 getSpiderScan(JSONObject params) throws ApiException {
        int id = this.getParam(params, PARAM_SCAN_ID, -1);
        SpiderScan spiderScan = id == -1 ? this.extension.getLastScan() : this.extension.getScan(id);
        if (spiderScan == null) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_SCAN_ID);
        }
        return spiderScan;
    }

    private int scanURL(String url, User user, int maxChildren, boolean recurse, Context context, boolean subtreeOnly) throws ApiException {
        Target target;
        log.debug((Object)("API Spider scanning url: " + url));
        boolean useUrl = true;
        if (url == null || url.isEmpty()) {
            if (context == null || !context.hasNodesInContextFromSiteTree()) {
                throw new ApiException(ApiException.Type.MISSING_PARAMETER, PARAM_URL);
            }
            useUrl = false;
        } else if (context != null && !context.isInContext(url)) {
            throw new ApiException(ApiException.Type.URL_NOT_IN_CONTEXT, PARAM_URL);
        }
        StructuralNode node = null;
        URI startURI = null;
        if (useUrl) {
            try {
                startURI = new URI(url, true);
            }
            catch (URIException e) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_URL);
            }
            String scheme = startURI.getScheme();
            if (scheme == null || !scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https")) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_URL);
            }
            try {
                node = SessionStructure.find(Model.getSingleton().getSession().getSessionId(), new URI(url, false), "GET", "");
            }
            catch (Exception e) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR);
            }
        }
        if (useUrl) {
            target = new Target(node);
            target.setContext(context);
        } else {
            target = new Target(context);
        }
        target.setRecurse(recurse);
        switch (Control.getSingleton().getMode()) {
            case safe: {
                throw new ApiException(ApiException.Type.MODE_VIOLATION);
            }
            case protect: {
                if ((!useUrl || Model.getSingleton().getSession().isInScope(url)) && (context == null || context.isInScope())) break;
                throw new ApiException(ApiException.Type.MODE_VIOLATION);
            }
            case standard: {
                break;
            }
        }
        ArrayList<Object> objs = new ArrayList<Object>(4);
        if (startURI != null) {
            objs.add(startURI);
            if (subtreeOnly) {
                objs.add(new HttpPrefixFetchFilter(startURI));
            }
        }
        if (maxChildren > 0) {
            MaxChildrenFetchFilter maxChildrenFetchFilter = new MaxChildrenFetchFilter();
            maxChildrenFetchFilter.setMaxChildren(maxChildren);
            maxChildrenFetchFilter.setModel(this.extension.getModel());
            MaxChildrenParseFilter maxChildrenParseFilter = new MaxChildrenParseFilter(this.extension.getMessages());
            maxChildrenParseFilter.setMaxChildren(maxChildren);
            maxChildrenParseFilter.setModel(this.extension.getModel());
            objs.add(maxChildrenFetchFilter);
            objs.add(maxChildrenParseFilter);
        }
        return this.extension.startScan(target, user, objs.toArray(new Object[objs.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiResponse handleApiView(String name, JSONObject params) throws ApiException {
        ApiResponse result;
        if (VIEW_STATUS.equals(name)) {
            SpiderScan scan = (SpiderScan)this.getSpiderScan(params);
            int progress = 0;
            if (scan != null) {
                progress = scan.isStopped() ? 100 : scan.getProgress();
            }
            result = new ApiResponseElement(name, Integer.toString(progress));
        } else if (VIEW_RESULTS.equals(name)) {
            result = new ApiResponseList(name);
            SpiderScan scan = (SpiderScan)this.getSpiderScan(params);
            if (scan != null) {
                Set<String> progress = scan.getResults();
                synchronized (progress) {
                    for (String s : scan.getResults()) {
                        ((ApiResponseList)result).addItem(new ApiResponseElement(PARAM_URL, s));
                    }
                }
            }
        } else if (VIEW_FULL_RESULTS.equals(name)) {
            ApiResponseList resultUrls = new ApiResponseList(name);
            SpiderScan scan = (SpiderScan)this.getSpiderScan(params);
            ApiResponseList apiResponseList = new ApiResponseList("urlsInScope");
            Collection<Object> s = scan.getResourcesFound();
            synchronized (s) {
                for (SpiderResource sr : scan.getResourcesFound()) {
                    apiResponseList.addItem(SpiderAPI.createApiResponseSet(sr, sr.isProcessed(), sr.getReasonNotProcessed()));
                }
            }
            resultUrls.addItem(apiResponseList);
            ApiResponseList apiResponseList2 = new ApiResponseList("urlsOutOfScope");
            s = scan.getResultsOutOfScope();
            synchronized (s) {
                for (String url : scan.getResultsOutOfScope()) {
                    apiResponseList2.addItem(new ApiResponseElement(PARAM_URL, url));
                }
            }
            resultUrls.addItem(apiResponseList2);
            ApiResponseList apiResponseList3 = new ApiResponseList("urlsIoError");
            s = scan.getResourcesIoErrors();
            synchronized (s) {
                for (SpiderResource sr : scan.getResourcesIoErrors()) {
                    apiResponseList3.addItem(SpiderAPI.createApiResponseSet(sr, sr.isProcessed(), sr.getReasonNotProcessed()));
                }
            }
            resultUrls.addItem(apiResponseList3);
            result = resultUrls;
        } else if (VIEW_EXCLUDED_FROM_SCAN.equals(name)) {
            result = new ApiResponseList(name);
            Session session = Model.getSingleton().getSession();
            List<String> regexs = session.getExcludeFromSpiderRegexs();
            for (String regex : regexs) {
                ((ApiResponseList)result).addItem(new ApiResponseElement(PARAM_REGEX, regex));
            }
        } else if (VIEW_SCANS.equals(name)) {
            ApiResponseList resultList = new ApiResponseList(name);
            for (GenericScanner2 genericScanner2 : this.extension.getAllScans()) {
                SpiderScan spiderScan = (SpiderScan)genericScanner2;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", Integer.toString(spiderScan.getScanId()));
                map.put("progress", Integer.toString(spiderScan.getProgress()));
                map.put("state", spiderScan.getState());
                resultList.addItem(new ApiResponseSet(ACTION_START_SCAN, map));
            }
            result = resultList;
        } else if (VIEW_ALL_URLS.equals(name)) {
            ApiResponseList resultUrls = new ApiResponseList(name);
            HashSet<String> urlSet = new HashSet<String>();
            TableHistory tableHistory = this.extension.getModel().getDb().getTableHistory();
            List<Object> ids = Collections.emptyList();
            try {
                ids = tableHistory.getHistoryIdsOfHistType(this.extension.getModel().getSession().getSessionId(), 2, 9);
            }
            catch (DatabaseException e) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
            }
            for (Integer n : ids) {
                try {
                    String url;
                    RecordHistory rh = tableHistory.read(n);
                    if (rh == null || !urlSet.add(url = rh.getHttpMessage().getRequestHeader().getURI().toString())) continue;
                    resultUrls.addItem(new ApiResponseElement(PARAM_URL, url));
                }
                catch (DatabaseException | HttpMalformedHeaderException e) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                }
            }
            result = resultUrls;
        } else if (VIEW_ADDED_NODES.equals(name)) {
            result = new ApiResponseList(name);
            SpiderScan scan = (SpiderScan)this.getSpiderScan(params);
            if (scan != null) {
                for (String string : scan.getAddedNodesTableModel().getAddedNodes()) {
                    ((ApiResponseList)result).addItem(new ApiResponseElement(PARAM_URL, string));
                }
            }
        } else if (VIEW_DOMAINS_ALWAYS_IN_SCOPE.equals(name) || VIEW_OPTION_DOMAINS_ALWAYS_IN_SCOPE.equals(name)) {
            result = this.domainMatchersToApiResponseList(name, this.extension.getSpiderParam().getDomainsAlwaysInScope(), false);
        } else if (VIEW_OPTION_DOMAINS_ALWAYS_IN_SCOPE_ENABLED.equals(name)) {
            result = this.domainMatchersToApiResponseList(name, this.extension.getSpiderParam().getDomainsAlwaysInScope(), true);
        } else {
            throw new ApiException(ApiException.Type.BAD_VIEW);
        }
        return result;
    }

    private static ApiResponseSet<String> createApiResponseSet(SpiderResource sr, boolean processed, String reasonNotProcessed) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("messageId", Integer.toString(sr.getHistoryId()));
        map.put("method", sr.getMethod());
        map.put(PARAM_URL, sr.getUri());
        map.put("statusCode", Integer.toString(sr.getStatusCode()));
        map.put("statusReason", sr.getStatusReason());
        map.put("processed", Boolean.toString(processed));
        map.put("reasonNotProcessed", reasonNotProcessed);
        return new ApiResponseSet<String>("resource", map);
    }

    private ApiResponse domainMatchersToApiResponseList(String name, List<DomainAlwaysInScopeMatcher> domains, boolean excludeDisabled) {
        ApiResponseList apiResponse = new ApiResponseList(name);
        for (int i = 0; i < domains.size(); ++i) {
            DomainAlwaysInScopeMatcher domain = domains.get(i);
            if (!domain.isEnabled() && excludeDisabled) continue;
            HashMap<String, Object> domainData = new HashMap<String, Object>();
            domainData.put(PARAM_IDX, i);
            domainData.put(PARAM_VALUE, domain.getValue());
            domainData.put(PARAM_REGEX, domain.isRegex());
            domainData.put("enabled", domain.isEnabled());
            apiResponse.addItem(new ApiResponseSet("domain", domainData));
        }
        return apiResponse;
    }
}

