"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var path = require('path');
var URL = require('url');
var fs = require('fs');
var rootPath = path.resolve(__dirname, '../../tests/root.json');
var Unit = /** @class */ (function () {
    function Unit(newPath, parent) {
        if (parent === void 0) { parent = null; }
        this._content = '';
        this._absolutePath = (newPath && parent || (!path.isAbsolute(newPath) && parent)) ? path.resolve(path.dirname(parent.absolutePath()), newPath) : newPath;
        if (fs.existsSync(this._absolutePath)) {
            this._content = fs.readFileSync(this._absolutePath).toString();
        }
    }
    Unit.prototype.absolutePath = function () {
        return this._absolutePath;
    };
    Unit.prototype.resolve = function (newPath) {
        return new Unit(newPath, this);
    };
    Unit.prototype.contents = function () {
        return this._content;
    };
    return Unit;
}());
var ContentProvider = /** @class */ (function () {
    function ContentProvider() {
        this.unit = new Unit(rootPath);
    }
    ContentProvider.prototype.contextPath = function () {
        if (!this.unit) {
            return "";
        }
        var rootPath = this.unit.absolutePath();
        return rootPath || "";
    };
    ContentProvider.prototype.normalizePath = function (url) {
        if (!url) {
            return url;
        }
        var result;
        if (!isWebPath(url)) {
            result = path.normalize(url);
        }
        else {
            var prefix = url.toLowerCase().indexOf('https') === 0 ? 'https://' : 'http://';
            result = prefix + path.normalize(url.substring(prefix.length));
        }
        return result;
    };
    ContentProvider.prototype.content = function (reference) {
        var absolutePath = this.normalizePath(reference);
        var unit = this.unit.resolve(absolutePath);
        if (!unit) {
            return "";
        }
        return unit.contents() || "";
    };
    ContentProvider.prototype.hasAsyncRequests = function () {
        return false;
    };
    ContentProvider.prototype.resolvePath = function (context, relativePath) {
        if (!relativePath || !context) {
            return relativePath;
        }
        var result;
        if (!isWebPath(context)) {
            result = path.resolve(path.dirname(context), relativePath);
        }
        else {
            result = URL.resolve(context, relativePath);
        }
        return result;
    };
    ContentProvider.prototype.isAbsolutePath = function (uri) {
        if (!uri) {
            return false;
        }
        if (isWebPath(uri)) {
            return true;
        }
        return path.isAbsolute(uri);
    };
    ContentProvider.prototype.contentAsync = function (reference) {
        var _this = this;
        return {
            then: function (arg) { return arg(_this.content(reference)); },
            resolve: function () { return null; }
        };
    };
    ContentProvider.prototype.promiseResolve = function (arg) {
        return {
            then: function (arg1) { return arg1(arg); },
            resolve: function () { return null; }
        };
    };
    return ContentProvider;
}());
exports.ContentProvider = ContentProvider;
function isWebPath(str) {
    return false;
}
//# sourceMappingURL=contentprovider.js.map