/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.servlet;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;

public class ServletContextURIResolver
implements URIResolver {
    public static final String SERVLET_CONTEXT_PROTOCOL = "servlet-context:";
    private ServletContext servletContext;

    public ServletContextURIResolver(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        if (href.startsWith(SERVLET_CONTEXT_PROTOCOL)) {
            return this.resolveServletContextURI(href.substring(SERVLET_CONTEXT_PROTOCOL.length()));
        }
        if (base != null && base.startsWith(SERVLET_CONTEXT_PROTOCOL) && href.indexOf(58) < 0) {
            String abs = base + href;
            return this.resolveServletContextURI(abs.substring(SERVLET_CONTEXT_PROTOCOL.length()));
        }
        return null;
    }

    protected Source resolveServletContextURI(String path) throws TransformerException {
        while (path.startsWith("//")) {
            path = path.substring(1);
        }
        try {
            URL url = this.servletContext.getResource(path);
            InputStream in = this.servletContext.getResourceAsStream(path);
            if (in != null) {
                if (url != null) {
                    return new StreamSource(in, url.toExternalForm());
                }
                return new StreamSource(in);
            }
            throw new TransformerException("Resource does not exist. \"" + path + "\" is not accessible through the servlet context.");
        }
        catch (MalformedURLException mfue) {
            throw new TransformerException("Error accessing resource using servlet context: " + path, mfue);
        }
    }
}

