/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.ocsp.Signature;
import org.bouncycastle.asn1.ocsp.TBSRequest;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.OCSP;
import org.jruby.ext.openssl.OCSPBasicResponse;
import org.jruby.ext.openssl.OCSPCertificateId;
import org.jruby.ext.openssl.OCSPResponse;
import org.jruby.ext.openssl.OpenSSL;
import org.jruby.ext.openssl.PKey;
import org.jruby.ext.openssl.StringHelper;
import org.jruby.ext.openssl.X509;
import org.jruby.ext.openssl.X509Cert;
import org.jruby.ext.openssl.X509Store;
import org.jruby.ext.openssl.X509StoreContext;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class OCSPRequest
extends RubyObject {
    private static final long serialVersionUID = -4020616730425816999L;
    private static ObjectAllocator REQUEST_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new OCSPRequest(runtime, klass);
        }
    };
    private static final String OCSP_NOCERTS = "NOCERTS";
    private static final String OCSP_NOSIGS = "NOSIGS";
    private static final String OCSP_NOINTERN = "NOINTERN";
    private static final String OCSP_NOVERIFY = "NOVERIFY";
    private static final String OCSP_TRUSTOTHER = "TRUSTOTHER";
    private static final String OCSP_NOCHAIN = "NOCHAIN";
    private org.bouncycastle.asn1.ocsp.OCSPRequest asn1bcReq;
    private List<OCSPCertificateId> certificateIds = new ArrayList<OCSPCertificateId>();
    private byte[] nonce;

    public OCSPRequest(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    public static void createRequest(Ruby runtime, RubyModule _OCSP) {
        RubyClass _request = _OCSP.defineClassUnder("Request", runtime.getObject(), REQUEST_ALLOCATOR);
        _request.defineAnnotatedMethods(OCSPRequest.class);
    }

    @JRubyMethod(name={"initialize"}, rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context2, IRubyObject[] args) {
        Ruby runtime = context2.getRuntime();
        if (Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)0, (int)1) == 0) {
            return this;
        }
        RubyString derString = StringHelper.readPossibleDERInput(context2, args[0]);
        this.asn1bcReq = org.bouncycastle.asn1.ocsp.OCSPRequest.getInstance((Object)derString.getBytes());
        return this;
    }

    @JRubyMethod(name={"add_certid"})
    public IRubyObject add_certid(IRubyObject certId) {
        Ruby runtime = this.getRuntime();
        OCSPCertificateId rubyCertId = (OCSPCertificateId)certId;
        this.certificateIds.add(rubyCertId);
        OCSPReqBuilder builder = new OCSPReqBuilder();
        for (OCSPCertificateId certificateId : this.certificateIds) {
            builder.addRequest(new CertificateID(certificateId.getCertID()));
        }
        try {
            this.asn1bcReq = org.bouncycastle.asn1.ocsp.OCSPRequest.getInstance((Object)builder.build().getEncoded());
        }
        catch (Exception e) {
            throw OCSP.newOCSPError(runtime, e);
        }
        if (this.nonce != null) {
            this.addNonceImpl();
        }
        return this;
    }

    @JRubyMethod(name={"add_nonce"}, rest=true)
    public IRubyObject add_nonce(IRubyObject[] args) {
        Ruby runtime = this.getRuntime();
        if (Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)0, (int)1) == 0) {
            this.nonce = this.generateNonce();
        } else {
            RubyString input = (RubyString)args[0];
            this.nonce = input.getBytes();
        }
        this.addNonceImpl();
        return this;
    }

    private void addNonceImpl() {
        GeneralName requestorName = null;
        DERSequence requestList = new DERSequence();
        Extensions extensions2 = null;
        Signature sig = null;
        ArrayList<Extension> tmpExtensions = new ArrayList<Extension>();
        if (this.asn1bcReq != null) {
            TBSRequest currentTbsReq = this.asn1bcReq.getTbsRequest();
            extensions2 = currentTbsReq.getRequestExtensions();
            sig = this.asn1bcReq.getOptionalSignature();
            Enumeration oids = extensions2.oids();
            while (oids.hasMoreElements()) {
                tmpExtensions.add(extensions2.getExtension((ASN1ObjectIdentifier)oids.nextElement()));
            }
        }
        tmpExtensions.add(new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, this.nonce));
        Extension[] exts = new Extension[tmpExtensions.size()];
        Extensions newExtensions = new Extensions(tmpExtensions.toArray(exts));
        TBSRequest newTbsReq = new TBSRequest(requestorName, (ASN1Sequence)requestList, newExtensions);
        this.asn1bcReq = new org.bouncycastle.asn1.ocsp.OCSPRequest(newTbsReq, sig);
    }

    @JRubyMethod(name={"certid"})
    public IRubyObject certid() {
        Ruby runtime = this.getRuntime();
        return RubyArray.newArray((Ruby)runtime, this.certificateIds);
    }

    @JRubyMethod(name={"check_nonce"})
    public IRubyObject check_nonce(ThreadContext context2, IRubyObject response) {
        Ruby runtime = context2.runtime;
        if (response instanceof OCSPBasicResponse) {
            OCSPBasicResponse rubyBasicRes = (OCSPBasicResponse)response;
            return this.checkNonceImpl(runtime, this.nonce, rubyBasicRes.getNonce());
        }
        if (response instanceof OCSPResponse) {
            OCSPResponse rubyResp = (OCSPResponse)response;
            return this.checkNonceImpl(runtime, this.nonce, ((OCSPBasicResponse)rubyResp.basic(context2)).getNonce());
        }
        return this.checkNonceImpl(runtime, this.nonce, null);
    }

    @JRubyMethod(name={"sign"}, rest=true)
    public IRubyObject sign(ThreadContext context2, IRubyObject[] args) {
        Ruby runtime = context2.runtime;
        int flag = 0;
        IRubyObject additionalCerts = context2.nil;
        IRubyObject flags = context2.nil;
        IRubyObject digest2 = context2.nil;
        Digest digestInstance = new Digest(runtime, Digest._Digest(runtime));
        RubyFixnum nocerts = (RubyFixnum)OCSP._OCSP(runtime).getConstant(OCSP_NOCERTS);
        switch (Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)2, (int)5)) {
            case 3: {
                additionalCerts = args[2];
                break;
            }
            case 4: {
                additionalCerts = args[2];
                flags = args[3];
                break;
            }
            case 5: {
                additionalCerts = args[2];
                flags = args[3];
                digest2 = args[4];
                break;
            }
        }
        if (digest2.isNil()) {
            digest2 = digestInstance.initialize(context2, new IRubyObject[]{RubyString.newString((Ruby)runtime, (String)"SHA1")});
        }
        if (additionalCerts.isNil()) {
            flag |= RubyFixnum.fix2int((IRubyObject)nocerts);
        }
        if (!flags.isNil()) {
            flag = RubyFixnum.fix2int((IRubyObject)flags);
        }
        X509Cert signer = (X509Cert)args[0];
        PKey signerKey = (PKey)args[1];
        String keyAlg = signerKey.getAlgorithm();
        String digAlg = ((Digest)digest2).getShortAlgorithm();
        JcaContentSignerBuilder signerBuilder = new JcaContentSignerBuilder(digAlg + "with" + keyAlg);
        signerBuilder.setProvider("BC");
        ContentSigner contentSigner = null;
        try {
            contentSigner = signerBuilder.build(signerKey.getPrivateKey());
        }
        catch (OperatorCreationException e) {
            throw OCSP.newOCSPError(runtime, (Exception)((Object)e));
        }
        OCSPReqBuilder builder = new OCSPReqBuilder();
        builder.setRequestorName(signer.getSubject().getX500Name());
        for (OCSPCertificateId certId : this.certificateIds) {
            builder.addRequest(new CertificateID(certId.getCertID()));
        }
        ArrayList<X509CertificateHolder> certChain = new ArrayList<X509CertificateHolder>();
        if (flag != RubyFixnum.fix2int((IRubyObject)nocerts)) {
            try {
                certChain.add(new X509CertificateHolder(signer.getAuxCert().getEncoded()));
                if (!additionalCerts.isNil()) {
                    Iterator certIt = ((RubyArray)additionalCerts).iterator();
                    while (certIt.hasNext()) {
                        certChain.add(new X509CertificateHolder(((java.security.cert.Certificate)certIt.next()).getEncoded()));
                    }
                }
            }
            catch (Exception e) {
                throw OCSP.newOCSPError(runtime, e);
            }
        }
        X509CertificateHolder[] chain2 = new X509CertificateHolder[certChain.size()];
        certChain.toArray(chain2);
        try {
            this.asn1bcReq = org.bouncycastle.asn1.ocsp.OCSPRequest.getInstance((Object)builder.build(contentSigner, chain2).getEncoded());
        }
        catch (Exception e) {
            throw OCSP.newOCSPError(runtime, e);
        }
        if (this.nonce != null) {
            this.addNonceImpl();
        }
        return this;
    }

    @JRubyMethod(name={"verify"}, rest=true)
    public IRubyObject verify(IRubyObject[] args) {
        Ruby runtime = this.getRuntime();
        ThreadContext context2 = runtime.getCurrentContext();
        int flags = 0;
        boolean ret = false;
        if (Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)2, (int)3) == 3) {
            flags = RubyFixnum.fix2int((RubyFixnum)((RubyFixnum)args[2]));
        }
        IRubyObject certificates2 = args[0];
        IRubyObject store = args[1];
        OCSPReq bcOCSPReq = this.getBCOCSPReq();
        if (bcOCSPReq == null) {
            throw OCSP.newOCSPError(runtime, new NullPointerException("Missing BC asn1bcReq. Missing certIDs or signature?"));
        }
        if (!bcOCSPReq.isSigned()) {
            return RubyBoolean.newBoolean((Ruby)runtime, (boolean)ret);
        }
        GeneralName genName = bcOCSPReq.getRequestorName();
        if (genName.getTagNo() != 4) {
            return RubyBoolean.newBoolean((Ruby)runtime, (boolean)ret);
        }
        X500Name genX500Name = X500Name.getInstance((Object)genName.getName());
        X509StoreContext storeContext = null;
        JcaContentVerifierProviderBuilder jcacvpb = new JcaContentVerifierProviderBuilder();
        jcacvpb.setProvider("BC");
        try {
            PublicKey signerPubKey;
            ContentVerifierProvider cvp;
            java.security.cert.Certificate signer = this.findCertByName((ASN1Encodable)genX500Name, certificates2, flags);
            if (signer == null) {
                return RubyBoolean.newBoolean((Ruby)runtime, (boolean)ret);
            }
            if ((flags & RubyFixnum.fix2int((IRubyObject)OCSP._OCSP(runtime).getConstant(OCSP_NOINTERN))) > 0 && (flags & RubyFixnum.fix2int((IRubyObject)OCSP._OCSP(runtime).getConstant(OCSP_TRUSTOTHER))) > 0) {
                flags |= RubyFixnum.fix2int((IRubyObject)OCSP._OCSP(runtime).getConstant(OCSP_NOVERIFY));
            }
            if ((flags & RubyFixnum.fix2int((IRubyObject)OCSP._OCSP(runtime).getConstant(OCSP_NOSIGS))) == 0 && !(ret = bcOCSPReq.isSignatureValid(cvp = jcacvpb.build(signerPubKey = signer.getPublicKey())))) {
                return RubyBoolean.newBoolean((Ruby)runtime, (boolean)ret);
            }
            if ((flags & RubyFixnum.fix2int((IRubyObject)OCSP._OCSP(runtime).getConstant(OCSP_NOVERIFY))) == 0) {
                if ((flags & RubyFixnum.fix2int((IRubyObject)OCSP._OCSP(runtime).getConstant(OCSP_NOCHAIN))) > 0) {
                    storeContext = X509StoreContext.newStoreContext(context2, (X509Store)store, X509Cert.wrap(runtime, signer), context2.nil);
                } else {
                    RubyArray certs = RubyArray.newEmptyArray((Ruby)runtime);
                    ASN1Sequence bcCerts = this.asn1bcReq.getOptionalSignature().getCerts();
                    if (bcCerts != null) {
                        Iterator it = bcCerts.iterator();
                        while (it.hasNext()) {
                            Certificate cert2 = Certificate.getInstance(it.next());
                            certs.add((Object)X509Cert.wrap(runtime, (java.security.cert.Certificate)new X509AuxCertificate(cert2)));
                        }
                    }
                    storeContext = X509StoreContext.newStoreContext(context2, (X509Store)store, X509Cert.wrap(runtime, signer), (IRubyObject)certs);
                }
                storeContext.set_purpose(context2, X509._X509(runtime).getConstant("PURPOSE_OCSP_HELPER"));
                storeContext.set_trust(context2, X509._X509(runtime).getConstant("TRUST_OCSP_REQUEST"));
                ret = storeContext.verify(context2).isTrue();
                if (!ret) {
                    return RubyBoolean.newBoolean((Ruby)runtime, (boolean)false);
                }
            }
        }
        catch (Exception e) {
            OpenSSL.debugStackTrace(e);
            throw OCSP.newOCSPError(runtime, e);
        }
        return RubyBoolean.newBoolean((Ruby)this.getRuntime(), (boolean)ret);
    }

    @JRubyMethod(name={"to_der"})
    public IRubyObject to_der() {
        Ruby runtime = this.getRuntime();
        try {
            return RubyString.newString((Ruby)runtime, (byte[])this.asn1bcReq.getEncoded("DER"));
        }
        catch (IOException e) {
            throw OCSP.newOCSPError(runtime, e);
        }
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject obj) {
        if (this == obj) {
            return this;
        }
        this.checkFrozen();
        this.asn1bcReq = ((OCSPRequest)obj).getBCRequest();
        return this;
    }

    private java.security.cert.Certificate findCertByName(ASN1Encodable genX500Name, IRubyObject certificates2, int flags) throws CertificateException, IOException {
        ASN1Sequence certs;
        Ruby runtime = this.getRuntime();
        if ((flags & RubyFixnum.fix2int((IRubyObject)OCSP._OCSP(runtime).getConstant(OCSP_NOINTERN))) == 0 && (certs = this.asn1bcReq.getOptionalSignature().getCerts()) != null) {
            Iterator it = certs.iterator();
            while (it.hasNext()) {
                X509Certificate cert2 = Certificate.getInstance(it.next());
                if (!genX500Name.equals(cert2.getSubject())) continue;
                return new X509AuxCertificate((Certificate)cert2);
            }
        }
        RubyArray certList = (RubyArray)certificates2;
        for (X509Certificate cert2 : certList) {
            if (!genX500Name.equals(X500Name.getInstance((Object)cert2.getSubjectX500Principal().getEncoded()))) continue;
            return new X509AuxCertificate(cert2);
        }
        return null;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    private IRubyObject checkNonceImpl(Ruby runtime, byte[] reqNonce, byte[] respNonce) {
        if (reqNonce != null && respNonce != null) {
            if (Arrays.equals(reqNonce, respNonce)) {
                return RubyFixnum.one((Ruby)runtime);
            }
            return RubyFixnum.zero((Ruby)runtime);
        }
        if (reqNonce == null && respNonce == null) {
            return RubyFixnum.two((Ruby)runtime);
        }
        if (reqNonce != null && respNonce == null) {
            return RubyFixnum.newFixnum((Ruby)runtime, (long)-1L);
        }
        return RubyFixnum.three((Ruby)runtime);
    }

    private byte[] generateNonce() {
        return this.generateNonce(new byte[16]);
    }

    private byte[] generateNonce(byte[] bytes) {
        OpenSSL.getSecureRandom(this.getRuntime()).nextBytes(bytes);
        return bytes;
    }

    public org.bouncycastle.asn1.ocsp.OCSPRequest getBCRequest() {
        return this.asn1bcReq;
    }

    public OCSPReq getBCOCSPReq() {
        if (this.asn1bcReq == null) {
            return null;
        }
        return new OCSPReq(this.asn1bcReq);
    }
}

