/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.dataflow.analyses;

import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IREvalScript;
import org.jruby.ir.IRScope;
import org.jruby.ir.dataflow.DataFlowProblem;
import org.jruby.ir.dataflow.analyses.StoreLocalVarPlacementNode;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ReceiveJRubyExceptionInstr;
import org.jruby.ir.instructions.StoreLocalVarInstr;
import org.jruby.ir.instructions.ThrowExceptionInstr;
import org.jruby.ir.operands.ClosureLocalVariable;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.TemporaryLocalVariable;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.representations.CFG;

public class StoreLocalVarPlacementProblem
extends DataFlowProblem<StoreLocalVarPlacementProblem, StoreLocalVarPlacementNode> {
    public static final String NAME = "Placement of local-var stores";
    private boolean scopeHasLocalVarStores;
    private boolean scopeHasUnrescuedExceptions;

    public StoreLocalVarPlacementProblem() {
        super(DataFlowProblem.DF_Direction.FORWARD);
    }

    @Override
    public String getName() {
        return "Binding Stores Placement Analysis";
    }

    @Override
    public StoreLocalVarPlacementNode buildFlowGraphNode(BasicBlock bb) {
        return new StoreLocalVarPlacementNode(this, bb);
    }

    @Override
    public String getDataFlowVarsForOutput() {
        return "";
    }

    public boolean scopeHasLocalVarStores() {
        return this.scopeHasLocalVarStores;
    }

    public boolean scopeHasUnrescuedExceptions() {
        return this.scopeHasUnrescuedExceptions;
    }

    TemporaryLocalVariable getLocalVarReplacement(LocalVariable v, Map<Operand, Operand> varRenameMap) {
        TemporaryLocalVariable value2 = (TemporaryLocalVariable)varRenameMap.get(v);
        if (value2 == null) {
            value2 = this.getScope().getNewTemporaryVariableFor(v);
            varRenameMap.put(v, value2);
        }
        return value2;
    }

    boolean addScopeExitStoreLocalVars(ListIterator<Instr> instrs, Set<LocalVariable> dirtyVars, Map<Operand, Operand> varRenameMap) {
        IRScope scope = this.getScope();
        boolean addedStores = false;
        boolean isEvalScript = scope instanceof IREvalScript;
        for (LocalVariable v : dirtyVars) {
            if (!isEvalScript && v instanceof ClosureLocalVariable && ((ClosureLocalVariable)v).isDefinedLocally()) continue;
            addedStores = true;
            instrs.add(new StoreLocalVarInstr(scope, (Operand)this.getLocalVarReplacement(v, varRenameMap), v));
        }
        return addedStores;
    }

    public void addStores(Map<Operand, Operand> varRenameMap) {
        boolean mightRequireGlobalEnsureBlock = false;
        HashSet<LocalVariable> dirtyVars = null;
        IRScope cfgScope = this.getScope();
        CFG cfg = cfgScope.getCFG();
        this.scopeHasLocalVarStores = false;
        this.scopeHasUnrescuedExceptions = false;
        if (cfgScope instanceof IRClosure) {
            mightRequireGlobalEnsureBlock = true;
            dirtyVars = new HashSet<LocalVariable>();
        }
        for (StoreLocalVarPlacementNode bspn : this.flowGraphNodes) {
            boolean bbHasUnrescuedExceptions = !bspn.hasExceptionsRescued();
            boolean bbAddedStores = mightRequireGlobalEnsureBlock && bbHasUnrescuedExceptions ? bspn.addStores(varRenameMap, dirtyVars) : bspn.addStores(varRenameMap, null);
            this.scopeHasUnrescuedExceptions = this.scopeHasUnrescuedExceptions || bbHasUnrescuedExceptions;
            this.scopeHasLocalVarStores = this.scopeHasLocalVarStores || bbAddedStores;
        }
        if (mightRequireGlobalEnsureBlock && !dirtyVars.isEmpty()) {
            BasicBlock geb = cfg.getGlobalEnsureBB();
            if (geb == null) {
                TemporaryLocalVariable exc = cfgScope.createTemporaryVariable();
                geb = new BasicBlock(cfg, Label.getGlobalEnsureBlockLabel());
                geb.addInstr(new ReceiveJRubyExceptionInstr(exc));
                geb.addInstr(new ThrowExceptionInstr(exc));
                cfg.addGlobalEnsureBB(geb);
            }
            ListIterator<Instr> instrs = geb.getInstrs().listIterator(geb.getInstrs().size());
            Instr i2 = instrs.previous();
            assert (i2.getOperation().transfersControl()) : "Last instruction of GEB in scope: " + this.getScope() + " is " + i2 + ", not a control-xfer instruction";
            this.addScopeExitStoreLocalVars(instrs, dirtyVars, varRenameMap);
        }
    }
}

