/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.javasupport.Java;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.StringSupport;

@JRubyModule(name={"JavaUtilities"})
public class JavaUtilities {
    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject set_java_object(IRubyObject recv2, IRubyObject self2, IRubyObject java_object2) {
        self2.dataWrapStruct(java_object2);
        return java_object2;
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject get_interface_module(IRubyObject recv2, IRubyObject arg0) {
        return Java.get_interface_module(recv2.getRuntime(), arg0);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject get_package_module(IRubyObject recv2, IRubyObject arg0) {
        return Java.get_package_module(recv2, arg0);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject get_package_module_dot_format(IRubyObject recv2, IRubyObject arg0) {
        return Java.get_package_module_dot_format(recv2, arg0);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject get_proxy_class(IRubyObject recv2, IRubyObject arg0) {
        return Java.get_proxy_class(recv2, arg0);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject create_proxy_class(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return Java.create_proxy_class(recv2, arg0, arg1, arg2);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject get_java_class(IRubyObject recv2, IRubyObject arg0) {
        return Java.get_java_class(recv2, arg0);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject get_top_level_proxy_or_package(ThreadContext context, IRubyObject recv2, IRubyObject arg0) {
        return Java.get_top_level_proxy_or_package(context, recv2, arg0);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject get_proxy_or_package_under_package(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1) {
        return Java.get_proxy_or_package_under_package(context, recv2, arg0, arg1);
    }

    @JRubyMethod(name={"valid_java_identifier?"}, meta=true)
    public static IRubyObject valid_java_identifier_p(ThreadContext context, IRubyObject recv2, IRubyObject name2) {
        String javaName = name2.convertToString().decodeString();
        return context.runtime.newBoolean(JavaUtilities.validJavaIdentifier(javaName));
    }

    private static boolean validJavaIdentifier(String javaName) {
        for (String frag : StringSupport.split(javaName, '.')) {
            if (frag.length() == 0) {
                return false;
            }
            if (!Character.isJavaIdentifierStart(frag.codePointAt(0))) {
                return false;
            }
            for (int i2 = 1; i2 < frag.length(); ++i2) {
                if (Character.isJavaIdentifierPart(frag.codePointAt(i2))) continue;
                return false;
            }
        }
        return true;
    }
}

