/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.InputStream;
import java.nio.channels.Channel;
import jnr.constants.platform.Errno;
import jnr.posix.FileStat;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.ResourceException;
import org.jruby.util.StringSupport;
import org.jruby.util.io.ModeFlags;

public class EmptyFileResource
implements FileResource {
    private static final EmptyFileResource INSTANCE = new EmptyFileResource();

    public static EmptyFileResource create(String pathname2) {
        return pathname2 == null || "".equals(pathname2) ? INSTANCE : null;
    }

    @Override
    public String absolutePath() {
        return "";
    }

    @Override
    public String canonicalPath() {
        return "";
    }

    @Override
    public boolean exists() {
        return false;
    }

    @Override
    public int errno() {
        return Errno.ENOENT.intValue();
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public boolean canExecute() {
        return false;
    }

    @Override
    public boolean canRead() {
        return false;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public boolean isSymLink() {
        return false;
    }

    @Override
    public String[] list() {
        return StringSupport.EMPTY_STRING_ARRAY;
    }

    @Override
    public long lastModified() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long length() {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileStat stat() {
        return null;
    }

    @Override
    public FileStat lstat() {
        return null;
    }

    @Override
    public JRubyFile hackyGetJRubyFile() {
        return JRubyFile.DUMMY;
    }

    @Override
    public InputStream inputStream() throws ResourceException {
        throw new ResourceException.NotFound("");
    }

    @Override
    public Channel openChannel(ModeFlags flags2, int perm) throws ResourceException {
        throw new ResourceException.NotFound(this.absolutePath());
    }
}

