/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.MessageLogger;
import org.apache.ivy.util.MessageLoggerHelper;

public class MessageLoggerEngine
implements MessageLogger {
    private final Stack loggerStack = new Stack();
    private MessageLogger defaultLogger = null;
    private List problems = new ArrayList();
    private List warns = new ArrayList();
    private List errors = new ArrayList();

    public void setDefaultLogger(MessageLogger messageLogger) {
        this.defaultLogger = messageLogger;
    }

    public void pushLogger(MessageLogger messageLogger) {
        Checks.checkNotNull(messageLogger, "logger");
        this.loggerStack.push(messageLogger);
    }

    public void popLogger() {
        if (!this.loggerStack.isEmpty()) {
            this.loggerStack.pop();
        }
    }

    public MessageLogger peekLogger() {
        if (this.loggerStack.isEmpty()) {
            return this.getDefaultLogger();
        }
        return (MessageLogger)this.loggerStack.peek();
    }

    private MessageLogger getDefaultLogger() {
        return this.defaultLogger == null ? Message.getDefaultLogger() : this.defaultLogger;
    }

    @Override
    public void warn(String string) {
        this.peekLogger().warn(string);
        this.problems.add("WARN:  " + string);
        this.warns.add(string);
    }

    @Override
    public void error(String string) {
        this.peekLogger().error(string);
        this.problems.add("\tERROR: " + string);
        this.errors.add(string);
    }

    @Override
    public List getErrors() {
        return this.errors;
    }

    @Override
    public List getProblems() {
        return this.problems;
    }

    @Override
    public List getWarns() {
        return this.warns;
    }

    @Override
    public void sumupProblems() {
        MessageLoggerHelper.sumupProblems(this);
        this.clearProblems();
    }

    @Override
    public void clearProblems() {
        this.getDefaultLogger().clearProblems();
        for (MessageLogger messageLogger : this.loggerStack) {
            messageLogger.clearProblems();
        }
        this.problems.clear();
        this.errors.clear();
        this.warns.clear();
    }

    @Override
    public void setShowProgress(boolean bl) {
        this.getDefaultLogger().setShowProgress(bl);
        for (MessageLogger messageLogger : this.loggerStack) {
            messageLogger.setShowProgress(bl);
        }
    }

    @Override
    public boolean isShowProgress() {
        return this.getDefaultLogger().isShowProgress();
    }

    @Override
    public void debug(String string) {
        this.peekLogger().debug(string);
    }

    @Override
    public void deprecated(String string) {
        this.peekLogger().deprecated(string);
    }

    @Override
    public void endProgress() {
        this.peekLogger().endProgress();
    }

    @Override
    public void endProgress(String string) {
        this.peekLogger().endProgress(string);
    }

    @Override
    public void info(String string) {
        this.peekLogger().info(string);
    }

    @Override
    public void rawinfo(String string) {
        this.peekLogger().rawinfo(string);
    }

    @Override
    public void log(String string, int n) {
        this.peekLogger().log(string, n);
    }

    @Override
    public void progress() {
        this.peekLogger().progress();
    }

    @Override
    public void rawlog(String string, int n) {
        this.peekLogger().rawlog(string, n);
    }

    @Override
    public void verbose(String string) {
        this.peekLogger().verbose(string);
    }
}

