/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.J3dHash;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class BoundingPolytope
extends Bounds {
    Vector4d[] planes;
    double[] mag;
    double[] pDotN;
    Point3d[] verts;
    int nVerts;
    Point3d centroid = new Point3d();
    Point3d[] boxVerts;
    boolean allocBoxVerts = false;

    public BoundingPolytope(Vector4d[] vector4dArray) {
        if (vector4dArray.length < 4) {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope11"));
        }
        this.boundId = 4;
        this.planes = new Vector4d[vector4dArray.length];
        this.mag = new double[vector4dArray.length];
        this.pDotN = new double[vector4dArray.length];
        for (int i = 0; i < vector4dArray.length; ++i) {
            this.mag[i] = Math.sqrt(vector4dArray[i].x * vector4dArray[i].x + vector4dArray[i].y * vector4dArray[i].y + vector4dArray[i].z * vector4dArray[i].z);
            double d = 1.0 / this.mag[i];
            this.planes[i] = new Vector4d(vector4dArray[i].x * d, vector4dArray[i].y * d, vector4dArray[i].z * d, vector4dArray[i].w * d);
        }
        this.computeAllVerts();
    }

    public BoundingPolytope() {
        this.boundId = 4;
        this.planes = new Vector4d[6];
        this.mag = new double[this.planes.length];
        this.pDotN = new double[this.planes.length];
        this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -1.0);
        this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, -1.0);
        this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -1.0);
        this.planes[3] = new Vector4d(0.0, -1.0, 0.0, -1.0);
        this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -1.0);
        this.planes[5] = new Vector4d(0.0, 0.0, -1.0, -1.0);
        this.mag[0] = 1.0;
        this.mag[1] = 1.0;
        this.mag[2] = 1.0;
        this.mag[3] = 1.0;
        this.mag[4] = 1.0;
        this.mag[5] = 1.0;
        this.computeAllVerts();
    }

    public BoundingPolytope(Bounds bounds) {
        this.boundId = 4;
        if (bounds == null) {
            this.boundsIsEmpty = true;
            this.boundsIsInfinite = false;
            this.initEmptyPolytope();
            this.computeAllVerts();
            return;
        }
        this.boundsIsEmpty = bounds.boundsIsEmpty;
        this.boundsIsInfinite = bounds.boundsIsInfinite;
        if (bounds.boundId == 2) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            this.planes = new Vector4d[6];
            this.mag = new double[this.planes.length];
            this.pDotN = new double[this.planes.length];
            this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -(boundingSphere.center.x + boundingSphere.radius));
            this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, boundingSphere.center.x - boundingSphere.radius);
            this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -(boundingSphere.center.y + boundingSphere.radius));
            this.planes[3] = new Vector4d(0.0, -1.0, 0.0, boundingSphere.center.y - boundingSphere.radius);
            this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -(boundingSphere.center.z + boundingSphere.radius));
            this.planes[5] = new Vector4d(0.0, 0.0, -1.0, boundingSphere.center.z - boundingSphere.radius);
            this.mag[0] = 1.0;
            this.mag[1] = 1.0;
            this.mag[2] = 1.0;
            this.mag[3] = 1.0;
            this.mag[4] = 1.0;
            this.mag[5] = 1.0;
            this.computeAllVerts();
        } else if (bounds.boundId == 1) {
            BoundingBox boundingBox = (BoundingBox)bounds;
            this.planes = new Vector4d[6];
            this.pDotN = new double[this.planes.length];
            this.mag = new double[this.planes.length];
            this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -boundingBox.upper.x);
            this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, boundingBox.lower.x);
            this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -boundingBox.upper.y);
            this.planes[3] = new Vector4d(0.0, -1.0, 0.0, boundingBox.lower.y);
            this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -boundingBox.upper.z);
            this.planes[5] = new Vector4d(0.0, 0.0, -1.0, boundingBox.lower.z);
            this.mag[0] = 1.0;
            this.mag[1] = 1.0;
            this.mag[2] = 1.0;
            this.mag[3] = 1.0;
            this.mag[4] = 1.0;
            this.mag[5] = 1.0;
            this.computeAllVerts();
        } else if (bounds.boundId == 4) {
            int n;
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            this.planes = new Vector4d[boundingPolytope.planes.length];
            this.mag = new double[this.planes.length];
            this.pDotN = new double[this.planes.length];
            this.nVerts = boundingPolytope.nVerts;
            this.verts = new Point3d[this.nVerts];
            for (n = 0; n < this.planes.length; ++n) {
                this.planes[n] = new Vector4d(boundingPolytope.planes[n]);
                this.mag[n] = boundingPolytope.mag[n];
                this.pDotN[n] = boundingPolytope.pDotN[n];
            }
            for (n = 0; n < this.verts.length; ++n) {
                this.verts[n] = new Point3d(boundingPolytope.verts[n]);
            }
            this.centroid = boundingPolytope.centroid;
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope0"));
        }
    }

    public BoundingPolytope(Bounds[] boundsArray) {
        Bounds bounds;
        int n;
        this.boundId = 4;
        if (boundsArray == null || boundsArray.length <= 0) {
            this.boundsIsEmpty = true;
            this.boundsIsInfinite = false;
            this.initEmptyPolytope();
            this.computeAllVerts();
            return;
        }
        for (n = 0; boundsArray[n] == null && n < boundsArray.length; ++n) {
        }
        if (n >= boundsArray.length) {
            this.boundsIsEmpty = true;
            this.boundsIsInfinite = false;
            this.initEmptyPolytope();
            this.computeAllVerts();
            return;
        }
        this.boundsIsEmpty = boundsArray[n].boundsIsEmpty;
        this.boundsIsInfinite = boundsArray[n].boundsIsInfinite;
        if (boundsArray[n].boundId == 2) {
            bounds = (BoundingSphere)boundsArray[n];
            this.planes = new Vector4d[6];
            this.mag = new double[this.planes.length];
            this.pDotN = new double[this.planes.length];
            this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -(bounds.center.x + bounds.radius));
            this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, bounds.center.x - bounds.radius);
            this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -(bounds.center.y + bounds.radius));
            this.planes[3] = new Vector4d(0.0, -1.0, 0.0, bounds.center.y - bounds.radius);
            this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -(bounds.center.z + bounds.radius));
            this.planes[5] = new Vector4d(0.0, 0.0, -1.0, bounds.center.z - bounds.radius);
            this.mag[0] = 1.0;
            this.mag[1] = 1.0;
            this.mag[2] = 1.0;
            this.mag[3] = 1.0;
            this.mag[4] = 1.0;
            this.mag[5] = 1.0;
            this.computeAllVerts();
        } else if (boundsArray[n].boundId == 1) {
            bounds = (BoundingBox)boundsArray[n];
            this.planes = new Vector4d[6];
            this.mag = new double[this.planes.length];
            this.pDotN = new double[this.planes.length];
            this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -((BoundingBox)bounds).upper.x);
            this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, ((BoundingBox)bounds).lower.x);
            this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -((BoundingBox)bounds).upper.y);
            this.planes[3] = new Vector4d(0.0, -1.0, 0.0, ((BoundingBox)bounds).lower.y);
            this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -((BoundingBox)bounds).upper.z);
            this.planes[5] = new Vector4d(0.0, 0.0, -1.0, ((BoundingBox)bounds).lower.z);
            this.mag[0] = 1.0;
            this.mag[1] = 1.0;
            this.mag[2] = 1.0;
            this.mag[3] = 1.0;
            this.mag[4] = 1.0;
            this.mag[5] = 1.0;
            this.computeAllVerts();
        } else if (boundsArray[n].boundId == 4) {
            bounds = (BoundingPolytope)boundsArray[n];
            this.planes = new Vector4d[((BoundingPolytope)bounds).planes.length];
            this.mag = new double[this.planes.length];
            this.pDotN = new double[this.planes.length];
            this.nVerts = ((BoundingPolytope)bounds).nVerts;
            this.verts = new Point3d[this.nVerts];
            for (n = 0; n < this.planes.length; ++n) {
                this.planes[n] = new Vector4d(((BoundingPolytope)bounds).planes[n]);
                this.pDotN[n] = ((BoundingPolytope)bounds).pDotN[n];
                this.mag[n] = ((BoundingPolytope)bounds).mag[n];
            }
            for (n = 0; n < this.verts.length; ++n) {
                this.verts[n] = new Point3d(((BoundingPolytope)bounds).verts[n]);
            }
            this.centroid = ((BoundingPolytope)bounds).centroid;
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope1"));
        }
        ++n;
        while (n < boundsArray.length) {
            this.combine(boundsArray[n]);
            ++n;
        }
    }

    public void setPlanes(Vector4d[] vector4dArray) {
        if (vector4dArray.length < 4) {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope11"));
        }
        this.planes = new Vector4d[vector4dArray.length];
        this.pDotN = new double[vector4dArray.length];
        this.mag = new double[vector4dArray.length];
        this.boundsIsEmpty = false;
        if (vector4dArray.length <= 0) {
            this.boundsIsEmpty = true;
            this.boundsIsInfinite = false;
            this.computeAllVerts();
            return;
        }
        for (int i = 0; i < vector4dArray.length; ++i) {
            this.mag[i] = Math.sqrt(vector4dArray[i].x * vector4dArray[i].x + vector4dArray[i].y * vector4dArray[i].y + vector4dArray[i].z * vector4dArray[i].z);
            double d = 1.0 / this.mag[i];
            this.planes[i] = new Vector4d(vector4dArray[i].x * d, vector4dArray[i].y * d, vector4dArray[i].z * d, vector4dArray[i].w * d);
        }
        this.computeAllVerts();
    }

    public void getPlanes(Vector4d[] vector4dArray) {
        for (int i = 0; i < vector4dArray.length; ++i) {
            vector4dArray[i].x = this.planes[i].x * this.mag[i];
            vector4dArray[i].y = this.planes[i].y * this.mag[i];
            vector4dArray[i].z = this.planes[i].z * this.mag[i];
            vector4dArray[i].w = this.planes[i].w * this.mag[i];
        }
    }

    public int getNumPlanes() {
        return this.planes.length;
    }

    public void set(Bounds bounds) {
        if (bounds == null) {
            this.boundsIsEmpty = true;
            this.boundsIsInfinite = false;
            this.computeAllVerts();
        } else if (bounds.boundId == 2) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            if (this.boundsIsEmpty) {
                this.initEmptyPolytope();
                this.computeAllVerts();
            }
            for (int i = 0; i < this.planes.length; ++i) {
                this.planes[i].w = -(boundingSphere.center.x * this.planes[i].x + boundingSphere.center.y * this.planes[i].y + boundingSphere.center.z * this.planes[i].z + boundingSphere.radius);
            }
            this.boundsIsEmpty = bounds.boundsIsEmpty;
            this.boundsIsInfinite = bounds.boundsIsInfinite;
            this.computeAllVerts();
        } else if (bounds.boundId == 1) {
            BoundingBox boundingBox = (BoundingBox)bounds;
            if (this.boundsIsEmpty) {
                this.initEmptyPolytope();
                this.computeAllVerts();
            }
            for (int i = 0; i < this.planes.length; ++i) {
                double d;
                double d2;
                double d3;
                double d4;
                double d5;
                double d6;
                double d7;
                double d8 = boundingBox.upper.x * this.planes[i].x;
                double d9 = boundingBox.upper.y * this.planes[i].y;
                double d10 = boundingBox.upper.z * this.planes[i].z;
                double d11 = boundingBox.lower.x * this.planes[i].x;
                double d12 = boundingBox.lower.y * this.planes[i].y;
                double d13 = boundingBox.lower.z * this.planes[i].z;
                this.planes[i].w = -(d8 + d9 + d10);
                double d14 = d8 + d9 + d13;
                if (d7 + this.planes[i].w > 0.0) {
                    this.planes[i].w = -d14;
                }
                d14 = d8 + d12 + d10;
                if (d6 + this.planes[i].w > 0.0) {
                    this.planes[i].w = -d14;
                }
                d14 = d8 + d12 + d13;
                if (d5 + this.planes[i].w > 0.0) {
                    this.planes[i].w = -d14;
                }
                d14 = d11 + d9 + d10;
                if (d4 + this.planes[i].w > 0.0) {
                    this.planes[i].w = -d14;
                }
                d14 = d11 + d9 + d13;
                if (d3 + this.planes[i].w > 0.0) {
                    this.planes[i].w = -d14;
                }
                d14 = d11 + d12 + d10;
                if (d2 + this.planes[i].w > 0.0) {
                    this.planes[i].w = -d14;
                }
                d14 = d11 + d12 + d13;
                if (!(d + this.planes[i].w > 0.0)) continue;
                this.planes[i].w = -d14;
            }
            this.boundsIsEmpty = bounds.boundsIsEmpty;
            this.boundsIsInfinite = bounds.boundsIsInfinite;
            this.computeAllVerts();
        } else if (bounds.boundId == 4) {
            int n;
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            if (this.planes.length != boundingPolytope.planes.length) {
                this.planes = new Vector4d[boundingPolytope.planes.length];
                for (n = 0; n < boundingPolytope.planes.length; ++n) {
                    this.planes[n] = new Vector4d();
                }
                this.mag = new double[boundingPolytope.planes.length];
                this.pDotN = new double[boundingPolytope.planes.length];
            }
            for (int i = 0; i < boundingPolytope.planes.length; ++i) {
                this.planes[i].x = boundingPolytope.planes[i].x;
                this.planes[i].y = boundingPolytope.planes[i].y;
                this.planes[i].z = boundingPolytope.planes[i].z;
                this.planes[i].w = boundingPolytope.planes[i].w;
                this.mag[i] = boundingPolytope.mag[i];
            }
            this.nVerts = boundingPolytope.nVerts;
            this.verts = new Point3d[this.nVerts];
            for (n = 0; n < this.nVerts; ++n) {
                this.verts[n] = new Point3d(boundingPolytope.verts[n]);
            }
            this.boundsIsEmpty = bounds.boundsIsEmpty;
            this.boundsIsInfinite = bounds.boundsIsInfinite;
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope2"));
        }
    }

    public Object clone() {
        return new BoundingPolytope(this.planes);
    }

    public boolean equals(Object object) {
        try {
            BoundingPolytope boundingPolytope = (BoundingPolytope)object;
            if (this.planes.length != boundingPolytope.planes.length) {
                return false;
            }
            for (int i = 0; i < this.planes.length; ++i) {
                if (this.planes[i].equals((Tuple4d)boundingPolytope.planes[i])) continue;
                return false;
            }
            return true;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        long l = 1L;
        for (int i = 0; i < this.planes.length; ++i) {
            l = J3dHash.mixDoubleBits(l, this.planes[i].x);
            l = J3dHash.mixDoubleBits(l, this.planes[i].y);
            l = J3dHash.mixDoubleBits(l, this.planes[i].z);
            l = J3dHash.mixDoubleBits(l, this.planes[i].w);
        }
        return J3dHash.finish(l);
    }

    public void combine(Bounds bounds) {
        if (bounds == null || bounds.boundsIsEmpty || this.boundsIsInfinite) {
            return;
        }
        if (this.boundsIsEmpty || bounds.boundsIsInfinite) {
            this.set(bounds);
            return;
        }
        this.boundsIsEmpty = bounds.boundsIsEmpty;
        this.boundsIsInfinite = bounds.boundsIsInfinite;
        if (bounds.boundId == 2) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            for (int i = 0; i < this.planes.length; ++i) {
                double d = boundingSphere.radius + boundingSphere.center.x * this.planes[i].x + boundingSphere.center.y * this.planes[i].y + boundingSphere.center.z * this.planes[i].z + this.planes[i].w;
                if (!(d > 0.0)) continue;
                this.planes[i].w += -d;
            }
        } else if (bounds instanceof BoundingBox) {
            BoundingBox boundingBox = (BoundingBox)bounds;
            if (!this.allocBoxVerts) {
                this.boxVerts = new Point3d[8];
                for (int i = 0; i < 8; ++i) {
                    this.boxVerts[i] = new Point3d();
                }
                this.allocBoxVerts = true;
            }
            this.boxVerts[0].set(boundingBox.lower.x, boundingBox.lower.y, boundingBox.lower.z);
            this.boxVerts[1].set(boundingBox.lower.x, boundingBox.upper.y, boundingBox.lower.z);
            this.boxVerts[2].set(boundingBox.upper.x, boundingBox.lower.y, boundingBox.lower.z);
            this.boxVerts[3].set(boundingBox.upper.x, boundingBox.upper.y, boundingBox.lower.z);
            this.boxVerts[4].set(boundingBox.lower.x, boundingBox.lower.y, boundingBox.upper.z);
            this.boxVerts[5].set(boundingBox.lower.x, boundingBox.upper.y, boundingBox.upper.z);
            this.boxVerts[6].set(boundingBox.upper.x, boundingBox.lower.y, boundingBox.upper.z);
            this.boxVerts[7].set(boundingBox.upper.x, boundingBox.upper.y, boundingBox.upper.z);
            this.combine(this.boxVerts);
        } else if (bounds.boundId == 4) {
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            this.combine(boundingPolytope.verts);
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope3"));
        }
        this.computeAllVerts();
    }

    public void combine(Bounds[] boundsArray) {
        int n;
        if (boundsArray == null || boundsArray.length <= 0 || this.boundsIsInfinite) {
            return;
        }
        for (n = 0; n < boundsArray.length && (boundsArray[n] == null || boundsArray[n].boundsIsEmpty); ++n) {
        }
        if (n >= boundsArray.length) {
            return;
        }
        if (this.boundsIsEmpty) {
            this.set(boundsArray[n++]);
        }
        if (this.boundsIsInfinite) {
            return;
        }
        while (n < boundsArray.length) {
            if (boundsArray[n] != null && !boundsArray[n].boundsIsEmpty) {
                int n2;
                Bounds bounds;
                if (boundsArray[n].boundsIsInfinite) {
                    this.set(boundsArray[n]);
                    break;
                }
                if (boundsArray[n].boundId == 2) {
                    bounds = (BoundingSphere)boundsArray[n];
                    for (n2 = 0; n2 < this.planes.length; ++n2) {
                        double d = bounds.radius + bounds.center.x * this.planes[n2].x + bounds.center.y * this.planes[n2].y + bounds.center.z * this.planes[n2].z + this.planes[n2].w;
                        if (!(d > 0.0)) continue;
                        this.planes[n2].w += -d;
                    }
                } else if (boundsArray[n].boundId == 1) {
                    bounds = (BoundingBox)boundsArray[n];
                    if (!this.allocBoxVerts) {
                        this.boxVerts = new Point3d[8];
                        for (n2 = 0; n2 < 8; ++n2) {
                            this.boxVerts[n2] = new Point3d();
                        }
                        this.allocBoxVerts = true;
                    }
                    this.boxVerts[0].set(((BoundingBox)bounds).lower.x, ((BoundingBox)bounds).lower.y, ((BoundingBox)bounds).lower.z);
                    this.boxVerts[1].set(((BoundingBox)bounds).lower.x, ((BoundingBox)bounds).upper.y, ((BoundingBox)bounds).lower.z);
                    this.boxVerts[2].set(((BoundingBox)bounds).upper.x, ((BoundingBox)bounds).lower.y, ((BoundingBox)bounds).lower.z);
                    this.boxVerts[3].set(((BoundingBox)bounds).upper.x, ((BoundingBox)bounds).upper.y, ((BoundingBox)bounds).lower.z);
                    this.boxVerts[4].set(((BoundingBox)bounds).lower.x, ((BoundingBox)bounds).lower.y, ((BoundingBox)bounds).upper.z);
                    this.boxVerts[5].set(((BoundingBox)bounds).lower.x, ((BoundingBox)bounds).upper.y, ((BoundingBox)bounds).upper.z);
                    this.boxVerts[6].set(((BoundingBox)bounds).upper.x, ((BoundingBox)bounds).lower.y, ((BoundingBox)bounds).upper.z);
                    this.boxVerts[7].set(((BoundingBox)bounds).upper.x, ((BoundingBox)bounds).upper.y, ((BoundingBox)bounds).upper.z);
                    this.combine(this.boxVerts);
                } else if (boundsArray[n] instanceof BoundingPolytope) {
                    bounds = (BoundingPolytope)boundsArray[n];
                    this.combine(((BoundingPolytope)bounds).verts);
                } else {
                    throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope4"));
                }
            }
            this.computeAllVerts();
            ++n;
        }
    }

    public void combine(Point3d point3d) {
        if (this.boundsIsInfinite) {
            return;
        }
        if (this.boundsIsEmpty) {
            this.planes = new Vector4d[6];
            this.mag = new double[this.planes.length];
            this.pDotN = new double[this.planes.length];
            this.nVerts = 1;
            this.verts = new Point3d[this.nVerts];
            this.verts[0] = new Point3d(point3d.x, point3d.y, point3d.z);
            for (int i = 0; i < this.planes.length; ++i) {
                this.pDotN[i] = 0.0;
            }
            this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -point3d.x);
            this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, point3d.x);
            this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -point3d.y);
            this.planes[3] = new Vector4d(0.0, -1.0, 0.0, point3d.y);
            this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -point3d.z);
            this.planes[5] = new Vector4d(0.0, 0.0, -1.0, point3d.z);
            this.mag[0] = 1.0;
            this.mag[1] = 1.0;
            this.mag[2] = 1.0;
            this.mag[3] = 1.0;
            this.mag[4] = 1.0;
            this.mag[5] = 1.0;
            this.centroid.x = point3d.x;
            this.centroid.y = point3d.y;
            this.centroid.z = point3d.z;
            this.boundsIsEmpty = false;
            this.boundsIsInfinite = false;
        } else {
            for (int i = 0; i < this.planes.length; ++i) {
                double d = point3d.x * this.planes[i].x + point3d.y * this.planes[i].y + point3d.z * this.planes[i].z + this.planes[i].w;
                if (!(d > 0.0)) continue;
                this.planes[i].w += -d;
            }
            this.computeAllVerts();
        }
    }

    public void combine(Point3d[] point3dArray) {
        int n;
        if (this.boundsIsInfinite) {
            return;
        }
        if (this.boundsIsEmpty) {
            this.planes = new Vector4d[6];
            this.mag = new double[this.planes.length];
            this.pDotN = new double[this.planes.length];
            this.nVerts = point3dArray.length;
            this.verts = new Point3d[this.nVerts];
            this.verts[0] = new Point3d(point3dArray[0].x, point3dArray[0].y, point3dArray[0].z);
            for (n = 0; n < this.planes.length; ++n) {
                this.pDotN[n] = 0.0;
            }
            this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -point3dArray[0].x);
            this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, point3dArray[0].x);
            this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -point3dArray[0].y);
            this.planes[3] = new Vector4d(0.0, -1.0, 0.0, point3dArray[0].y);
            this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -point3dArray[0].z);
            this.planes[5] = new Vector4d(0.0, 0.0, -1.0, point3dArray[0].z);
            this.mag[0] = 1.0;
            this.mag[1] = 1.0;
            this.mag[2] = 1.0;
            this.mag[3] = 1.0;
            this.mag[4] = 1.0;
            this.mag[5] = 1.0;
            this.centroid.x = point3dArray[0].x;
            this.centroid.y = point3dArray[0].y;
            this.centroid.z = point3dArray[0].z;
            this.boundsIsEmpty = false;
            this.boundsIsInfinite = false;
        }
        for (int i = 0; i < point3dArray.length; ++i) {
            for (n = 0; n < this.planes.length; ++n) {
                double d = point3dArray[i].x * this.planes[n].x + point3dArray[i].y * this.planes[n].y + point3dArray[i].z * this.planes[n].z + this.planes[n].w;
                if (!(d > 0.0)) continue;
                this.planes[n].w += -d;
            }
        }
        this.computeAllVerts();
    }

    public void transform(Bounds bounds, Transform3D transform3D) {
        if (bounds == null || bounds.boundsIsEmpty) {
            this.boundsIsEmpty = true;
            this.boundsIsInfinite = false;
            this.computeAllVerts();
            return;
        }
        if (bounds.boundsIsInfinite) {
            this.set(bounds);
            return;
        }
        if (bounds.boundId == 2) {
            BoundingSphere boundingSphere = new BoundingSphere(bounds);
            boundingSphere.transform(transform3D);
            this.set(boundingSphere);
        } else if (bounds.boundId == 1) {
            BoundingBox boundingBox = new BoundingBox(bounds);
            boundingBox.transform(transform3D);
            this.set(boundingBox);
        } else if (bounds.boundId == 4) {
            BoundingPolytope boundingPolytope = new BoundingPolytope(bounds);
            boundingPolytope.transform(transform3D);
            this.set(boundingPolytope);
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope5"));
        }
    }

    public void transform(Transform3D transform3D) {
        int n;
        if (this.boundsIsInfinite) {
            return;
        }
        Transform3D transform3D2 = new Transform3D(transform3D);
        transform3D2.invert();
        transform3D2.transpose();
        for (n = 0; n < this.planes.length; ++n) {
            this.planes[n].x *= this.mag[n];
            this.planes[n].y *= this.mag[n];
            this.planes[n].z *= this.mag[n];
            this.planes[n].w *= this.mag[n];
            transform3D2.transform(this.planes[n]);
        }
        for (n = 0; n < this.planes.length; ++n) {
            this.mag[n] = Math.sqrt(this.planes[n].x * this.planes[n].x + this.planes[n].y * this.planes[n].y + this.planes[n].z * this.planes[n].z);
            double d = 1.0 / this.mag[n];
            this.planes[n] = new Vector4d(this.planes[n].x * d, this.planes[n].y * d, this.planes[n].z * d, this.planes[n].w * d);
        }
        for (n = 0; n < this.verts.length; ++n) {
            transform3D.transform(this.verts[n]);
        }
    }

    boolean intersect(Point3d point3d, Vector3d vector3d, Point3d point3d2) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            point3d2.x = point3d.x;
            point3d2.y = point3d.y;
            point3d2.z = point3d.z;
            return true;
        }
        double d = 1.0 / Math.sqrt(vector3d.x * vector3d.x + vector3d.y * vector3d.y + vector3d.z * vector3d.z);
        double d2 = vector3d.x * d;
        double d3 = vector3d.y * d;
        double d4 = vector3d.z * d;
        for (int i = 0; i < this.planes.length; ++i) {
            double d5;
            double d6;
            double d7;
            double d8;
            double d9 = this.planes[i].x * d2 + this.planes[i].y * d3 + this.planes[i].z * d4;
            double d10 = -(this.planes[i].x * point3d.x + this.planes[i].y * point3d.y + this.planes[i].z * point3d.z + this.planes[i].w);
            if (d9 == 0.0 || !((d8 = d10 / d9) >= 0.0) || !this.pointInPolytope(d7 = point3d.x + d2 * d8, d6 = point3d.y + d3 * d8, d5 = point3d.z + d4 * d8)) continue;
            point3d2.x = d7;
            point3d2.y = d6;
            point3d2.z = d5;
            return true;
        }
        return false;
    }

    boolean intersect(Point3d point3d, Vector3d vector3d, Point4d point4d) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            point4d.x = point3d.x;
            point4d.y = point3d.y;
            point4d.z = point3d.z;
            point4d.w = 0.0;
            return true;
        }
        double d = 1.0 / Math.sqrt(vector3d.x * vector3d.x + vector3d.y * vector3d.y + vector3d.z * vector3d.z);
        double d2 = vector3d.x * d;
        double d3 = vector3d.y * d;
        double d4 = vector3d.z * d;
        for (int i = 0; i < this.planes.length; ++i) {
            double d5;
            double d6;
            double d7;
            double d8;
            double d9 = this.planes[i].x * d2 + this.planes[i].y * d3 + this.planes[i].z * d4;
            double d10 = -(this.planes[i].x * point3d.x + this.planes[i].y * point3d.y + this.planes[i].z * point3d.z + this.planes[i].w);
            if (d9 == 0.0 || !((d8 = d10 / d9) >= 0.0) || !this.pointInPolytope(d7 = point3d.x + d2 * d8, d6 = point3d.y + d3 * d8, d5 = point3d.z + d4 * d8)) continue;
            point4d.x = d7;
            point4d.y = d6;
            point4d.z = d5;
            point4d.w = d8;
            return true;
        }
        return false;
    }

    boolean intersect(Point3d point3d, Point4d point4d) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            point4d.x = point3d.x;
            point4d.y = point3d.y;
            point4d.z = point3d.z;
            point4d.w = 0.0;
            return true;
        }
        for (int i = 0; i < this.planes.length; ++i) {
            if (!(point3d.x * this.planes[i].x + point3d.y * this.planes[i].y + point3d.z * this.planes[i].z + this.planes[i].w > 0.0)) continue;
            return false;
        }
        return true;
    }

    boolean intersect(Point3d point3d, Point3d point3d2, Point4d point4d) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            point4d.x = point3d.x;
            point4d.y = point3d.y;
            point4d.z = point3d.z;
            point4d.w = 0.0;
            return true;
        }
        Point3d point3d3 = new Point3d();
        point3d3.x = point3d2.x - point3d.x;
        point3d3.y = point3d2.y - point3d.y;
        point3d3.z = point3d2.z - point3d.z;
        for (int i = 0; i < this.planes.length; ++i) {
            double d;
            double d2;
            double d3;
            double d4;
            double d5 = this.planes[i].x * point3d3.x + this.planes[i].y * point3d3.y + this.planes[i].z * point3d3.z;
            double d6 = -(this.planes[i].x * point3d.x + this.planes[i].y * point3d.y + this.planes[i].z * point3d.z + this.planes[i].w);
            if (d5 == 0.0 || !((d4 = d6 / d5) >= 0.0) || !this.pointInPolytope(d3 = point3d.x + point3d3.x * d4, d2 = point3d.y + point3d3.y * d4, d = point3d.z + point3d3.z * d4) || !(d4 <= 1.0)) continue;
            point4d.x = d3;
            point4d.y = d2;
            point4d.z = d;
            point4d.w = d4;
            return true;
        }
        return false;
    }

    public boolean intersect(Point3d point3d, Vector3d vector3d) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            return true;
        }
        for (int i = 0; i < this.planes.length; ++i) {
            double d;
            double d2;
            double d3;
            double d4;
            double d5 = this.planes[i].x * vector3d.x + this.planes[i].y * vector3d.y + this.planes[i].z * vector3d.z;
            double d6 = -(this.planes[i].x * point3d.x + this.planes[i].y * point3d.y + this.planes[i].z * point3d.z + this.planes[i].w);
            if (d5 == 0.0 || !((d4 = d6 / d5) >= 0.0) || !this.pointInPolytope(d3 = point3d.x + vector3d.x * d4, d2 = point3d.y + vector3d.y * d4, d = point3d.z + vector3d.z * d4)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.boundsIsEmpty || this.nVerts <= 0;
    }

    public boolean intersect(Point3d point3d) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            return true;
        }
        for (int i = 0; i < this.planes.length; ++i) {
            if (!(point3d.x * this.planes[i].x + point3d.y * this.planes[i].y + point3d.z * this.planes[i].z + this.planes[i].w > 0.0)) continue;
            return false;
        }
        return true;
    }

    boolean intersect(Bounds bounds, Point4d point4d) {
        return this.intersect(bounds);
    }

    public boolean intersect(Bounds bounds) {
        if (bounds == null) {
            return false;
        }
        if (this.boundsIsEmpty || bounds.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite || bounds.boundsIsInfinite) {
            return true;
        }
        if (bounds.boundId == 2) {
            return this.intersect_ptope_sphere(this, (BoundingSphere)bounds);
        }
        if (bounds.boundId == 1) {
            return this.intersect_ptope_abox(this, (BoundingBox)bounds);
        }
        if (bounds.boundId == 4) {
            return this.intersect_ptope_ptope(this, (BoundingPolytope)bounds);
        }
        throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope6"));
    }

    public boolean intersect(Bounds[] boundsArray) {
        if (boundsArray == null || boundsArray.length <= 0) {
            return false;
        }
        if (this.boundsIsEmpty) {
            return false;
        }
        for (int i = 0; i < boundsArray.length; ++i) {
            if (boundsArray[i] != null && !boundsArray[i].boundsIsEmpty && (this.boundsIsInfinite || boundsArray[i].boundsIsInfinite)) {
                return true;
            }
            if (boundsArray[i].boundId == 2) {
                BoundingSphere boundingSphere = (BoundingSphere)boundsArray[i];
                double d = boundingSphere.radius;
                d *= d;
                double d2 = boundingSphere.center.distanceSquared(boundingSphere.center);
                if (!(d2 < d)) continue;
                return true;
            }
            if (boundsArray[i].boundId == 1) {
                if (!this.intersect(boundsArray[i])) continue;
                return true;
            }
            if (boundsArray[i].boundId == 4) {
                if (!this.intersect(boundsArray[i])) continue;
                return true;
            }
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope7"));
        }
        return false;
    }

    public boolean intersect(Bounds bounds, BoundingPolytope boundingPolytope) {
        if (bounds == null || this.boundsIsEmpty || bounds.boundsIsEmpty) {
            boundingPolytope.boundsIsEmpty = true;
            boundingPolytope.boundsIsInfinite = false;
            boundingPolytope.computeAllVerts();
            return false;
        }
        if (this.boundsIsInfinite && !bounds.boundsIsInfinite) {
            boundingPolytope.set(bounds);
            return true;
        }
        if (!this.boundsIsInfinite && bounds.boundsIsInfinite) {
            boundingPolytope.set(this);
            return true;
        }
        if (this.boundsIsInfinite && bounds.boundsIsInfinite) {
            boundingPolytope.set(this);
            return true;
        }
        BoundingBox boundingBox = new BoundingBox();
        if (bounds.boundId == 2) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            if (this.intersect(boundingSphere)) {
                BoundingBox boundingBox2 = new BoundingBox(boundingSphere);
                BoundingBox boundingBox3 = new BoundingBox(this);
                boundingBox3.intersect((Bounds)boundingBox2, boundingBox);
                boundingPolytope.set(boundingBox);
                return true;
            }
        } else if (bounds.boundId == 1) {
            BoundingBox boundingBox4 = (BoundingBox)bounds;
            if (this.intersect(boundingBox4)) {
                BoundingBox boundingBox5 = new BoundingBox(this);
                boundingBox5.intersect((Bounds)boundingBox4, boundingBox);
                boundingPolytope.set(boundingBox);
                return true;
            }
        } else if (bounds.boundId == 4) {
            BoundingPolytope boundingPolytope2 = (BoundingPolytope)bounds;
            if (this.intersect(boundingPolytope2)) {
                int n;
                Vector4d[] vector4dArray = new Vector4d[this.planes.length + boundingPolytope2.planes.length];
                for (n = 0; n < this.planes.length; ++n) {
                    vector4dArray[n] = new Vector4d(this.planes[n]);
                }
                for (n = 0; n < boundingPolytope2.planes.length; ++n) {
                    vector4dArray[this.planes.length + n] = new Vector4d(boundingPolytope2.planes[n]);
                }
                BoundingPolytope boundingPolytope3 = new BoundingPolytope(vector4dArray);
                boundingPolytope.set(boundingPolytope3);
                return true;
            }
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope8"));
        }
        boundingPolytope.boundsIsEmpty = true;
        boundingPolytope.boundsIsInfinite = false;
        boundingPolytope.computeAllVerts();
        return false;
    }

    public boolean intersect(Bounds[] boundsArray, BoundingPolytope boundingPolytope) {
        int n;
        if (boundsArray == null || boundsArray.length <= 0 || this.boundsIsEmpty) {
            boundingPolytope.boundsIsEmpty = true;
            boundingPolytope.boundsIsInfinite = false;
            boundingPolytope.computeAllVerts();
            return false;
        }
        for (n = 0; boundsArray[n] == null && n < boundsArray.length; ++n) {
        }
        if (n >= boundsArray.length) {
            boundingPolytope.boundsIsEmpty = true;
            boundingPolytope.boundsIsInfinite = false;
            boundingPolytope.computeAllVerts();
            return false;
        }
        boolean bl = false;
        BoundingBox boundingBox = new BoundingBox();
        for (n = 0; n < boundsArray.length; ++n) {
            if (boundsArray[n] != null && !boundsArray[n].boundsIsEmpty) {
                Bounds bounds;
                Vector4d[] vector4dArray;
                Bounds bounds2;
                if (boundsArray[n].boundId == 2) {
                    bounds2 = (BoundingSphere)boundsArray[n];
                    if (this.intersect(bounds2)) {
                        vector4dArray = new BoundingBox(bounds2);
                        bounds = new BoundingBox(this);
                        bounds.intersect((Bounds)vector4dArray, boundingBox);
                        if (bl) {
                            boundingPolytope.combine(boundingBox);
                        } else {
                            boundingPolytope.set(boundingBox);
                            bl = true;
                        }
                    }
                } else if (boundsArray[n].boundId == 1) {
                    bounds2 = (BoundingBox)boundsArray[n];
                    if (this.intersect(bounds2)) {
                        vector4dArray = new BoundingBox(this);
                        vector4dArray.intersect(bounds2, boundingBox);
                        if (bl) {
                            boundingPolytope.combine(boundingBox);
                        } else {
                            boundingPolytope.set(boundingBox);
                            bl = true;
                        }
                    }
                } else if (boundsArray[n].boundId == 4) {
                    bounds2 = (BoundingPolytope)boundsArray[n];
                    if (this.intersect(bounds2)) {
                        vector4dArray = new Vector4d[this.planes.length + ((BoundingPolytope)bounds2).planes.length];
                        for (n = 0; n < this.planes.length; ++n) {
                            vector4dArray[n] = new Vector4d(this.planes[n]);
                        }
                        for (n = 0; n < ((BoundingPolytope)bounds2).planes.length; ++n) {
                            vector4dArray[this.planes.length + n] = new Vector4d(((BoundingPolytope)bounds2).planes[n]);
                        }
                        bounds = new BoundingPolytope(vector4dArray);
                        if (bl) {
                            boundingPolytope.combine(bounds);
                        } else {
                            boundingPolytope.set(bounds);
                            bl = true;
                        }
                    }
                } else {
                    throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope8"));
                }
            }
            if (boundingPolytope.boundsIsInfinite) break;
        }
        if (!bl) {
            boundingPolytope.boundsIsEmpty = true;
            boundingPolytope.boundsIsInfinite = false;
            boundingPolytope.computeAllVerts();
        }
        return bl;
    }

    public Bounds closestIntersection(Bounds[] boundsArray) {
        if (boundsArray == null || boundsArray.length <= 0) {
            return null;
        }
        if (this.boundsIsEmpty) {
            return null;
        }
        boolean bl = false;
        double d = Double.MAX_VALUE;
        int n = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < boundsArray.length; ++i) {
            int n2;
            boolean bl2;
            double d5;
            Bounds bounds;
            if (boundsArray[i] == null || !this.intersect(boundsArray[i])) continue;
            if (boundsArray[i] instanceof BoundingSphere) {
                bounds = (BoundingSphere)boundsArray[i];
                d5 = Math.sqrt((this.centroid.x - bounds.center.x) * (this.centroid.x - bounds.center.x) + (this.centroid.y - bounds.center.y) * (this.centroid.y - bounds.center.y) + (this.centroid.z - bounds.center.z) * (this.centroid.z - bounds.center.z));
                bl2 = true;
                for (n2 = 0; n2 < this.planes.length; ++n2) {
                    double d6;
                    if (!(bounds.center.x * this.planes[n2].x + bounds.center.y * this.planes[n2].y + bounds.center.z * this.planes[n2].z + this.planes[i].w > 0.0) || !((d6 = bounds.center.x * this.planes[n2].x + bounds.center.y * this.planes[n2].y + bounds.center.z * this.planes[n2].z + this.planes[n2].w) > bounds.radius)) continue;
                    bl2 = false;
                }
                if (bl2) {
                    if (!bl) {
                        n = i;
                        d = d5;
                        bl = true;
                        continue;
                    }
                    if (!(d5 < d)) continue;
                    n = i;
                    d = d5;
                    continue;
                }
                if (bl || !(d5 < d)) continue;
                n = i;
                d = d5;
                continue;
            }
            if (boundsArray[i] instanceof BoundingBox) {
                bounds = (BoundingBox)boundsArray[i];
                d2 = (((BoundingBox)bounds).upper.x + ((BoundingBox)bounds).lower.x) / 2.0;
                d3 = (((BoundingBox)bounds).upper.y + ((BoundingBox)bounds).lower.y) / 2.0;
                d4 = (((BoundingBox)bounds).upper.z + ((BoundingBox)bounds).lower.z) / 2.0;
                d5 = Math.sqrt((this.centroid.x - d2) * (this.centroid.x - d2) + (this.centroid.y - d3) * (this.centroid.y - d3) + (this.centroid.z - d4) * (this.centroid.z - d4));
                bl2 = true;
                if (!this.pointInPolytope(((BoundingBox)bounds).upper.x, ((BoundingBox)bounds).upper.y, ((BoundingBox)bounds).upper.z)) {
                    bl2 = false;
                }
                if (!this.pointInPolytope(((BoundingBox)bounds).upper.x, ((BoundingBox)bounds).upper.y, ((BoundingBox)bounds).lower.z)) {
                    bl2 = false;
                }
                if (!this.pointInPolytope(((BoundingBox)bounds).upper.x, ((BoundingBox)bounds).lower.y, ((BoundingBox)bounds).upper.z)) {
                    bl2 = false;
                }
                if (!this.pointInPolytope(((BoundingBox)bounds).upper.x, ((BoundingBox)bounds).lower.y, ((BoundingBox)bounds).lower.z)) {
                    bl2 = false;
                }
                if (!this.pointInPolytope(((BoundingBox)bounds).lower.x, ((BoundingBox)bounds).upper.y, ((BoundingBox)bounds).upper.z)) {
                    bl2 = false;
                }
                if (!this.pointInPolytope(((BoundingBox)bounds).lower.x, ((BoundingBox)bounds).upper.y, ((BoundingBox)bounds).lower.z)) {
                    bl2 = false;
                }
                if (!this.pointInPolytope(((BoundingBox)bounds).lower.x, ((BoundingBox)bounds).lower.y, ((BoundingBox)bounds).upper.z)) {
                    bl2 = false;
                }
                if (!this.pointInPolytope(((BoundingBox)bounds).lower.x, ((BoundingBox)bounds).lower.y, ((BoundingBox)bounds).lower.z)) {
                    bl2 = false;
                }
                if (bl2) {
                    if (!bl) {
                        n = i;
                        d = d5;
                        bl = true;
                        continue;
                    }
                    if (!(d5 < d)) continue;
                    n = i;
                    d = d5;
                    continue;
                }
                if (bl || !(d5 < d)) continue;
                n = i;
                d = d5;
                continue;
            }
            if (boundsArray[i] instanceof BoundingPolytope) {
                bounds = (BoundingPolytope)boundsArray[i];
                d5 = Math.sqrt((this.centroid.x - ((BoundingPolytope)bounds).centroid.x) * (this.centroid.x - ((BoundingPolytope)bounds).centroid.x) + (this.centroid.y - ((BoundingPolytope)bounds).centroid.y) * (this.centroid.y - ((BoundingPolytope)bounds).centroid.y) + (this.centroid.z - ((BoundingPolytope)bounds).centroid.z) * (this.centroid.z - ((BoundingPolytope)bounds).centroid.z));
                bl2 = true;
                for (n2 = 0; n2 < ((BoundingPolytope)bounds).nVerts; ++n2) {
                    if (this.pointInPolytope(((BoundingPolytope)bounds).verts[n2].x, ((BoundingPolytope)bounds).verts[n2].y, ((BoundingPolytope)bounds).verts[n2].z)) continue;
                    bl2 = false;
                }
                if (bl2) {
                    if (!bl) {
                        n = i;
                        d = d5;
                        bl = true;
                        continue;
                    }
                    if (!(d5 < d)) continue;
                    n = i;
                    d = d5;
                    continue;
                }
                if (bl || !(d5 < d)) continue;
                n = i;
                d = d5;
                continue;
            }
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope10"));
        }
        return boundsArray[n];
    }

    public String toString() {
        String string = new String("BoundingPolytope:\n Num Planes =" + this.planes.length);
        for (int i = 0; i < this.planes.length; ++i) {
            string = string + "\n" + this.mag[i] * this.planes[i].x + " " + this.mag[i] * this.planes[i].y + " " + this.mag[i] * this.planes[i].z + " " + this.mag[i] * this.planes[i].w;
        }
        return string;
    }

    private void computeVertex(int n, int n2, int n3) {
        double d = this.planes[n].x * this.planes[n2].y * this.planes[n3].z + this.planes[n].y * this.planes[n2].z * this.planes[n3].x + this.planes[n].z * this.planes[n2].x * this.planes[n3].y - this.planes[n].z * this.planes[n2].y * this.planes[n3].x - this.planes[n].y * this.planes[n2].x * this.planes[n3].z - this.planes[n].x * this.planes[n2].z * this.planes[n3].y;
        if (d * d < 1.0E-6) {
            return;
        }
        d = 1.0 / d;
        double d2 = (this.planes[n2].y * this.planes[n3].z - this.planes[n2].z * this.planes[n3].y) * this.pDotN[n];
        double d3 = (this.planes[n2].z * this.planes[n3].x - this.planes[n2].x * this.planes[n3].z) * this.pDotN[n];
        double d4 = (this.planes[n2].x * this.planes[n3].y - this.planes[n2].y * this.planes[n3].x) * this.pDotN[n];
        d2 += (this.planes[n3].y * this.planes[n].z - this.planes[n3].z * this.planes[n].y) * this.pDotN[n2];
        d3 += (this.planes[n3].z * this.planes[n].x - this.planes[n3].x * this.planes[n].z) * this.pDotN[n2];
        d4 += (this.planes[n3].x * this.planes[n].y - this.planes[n3].y * this.planes[n].x) * this.pDotN[n2];
        d2 += (this.planes[n].y * this.planes[n2].z - this.planes[n].z * this.planes[n2].y) * this.pDotN[n3];
        d3 += (this.planes[n].z * this.planes[n2].x - this.planes[n].x * this.planes[n2].z) * this.pDotN[n3];
        d4 += (this.planes[n].x * this.planes[n2].y - this.planes[n].y * this.planes[n2].x) * this.pDotN[n3];
        if (this.pointInPolytope(d2 *= d, d3 *= d, d4 *= d)) {
            if (this.nVerts >= this.verts.length) {
                Point3d[] point3dArray = new Point3d[this.nVerts << 1];
                for (int i = 0; i < this.nVerts; ++i) {
                    point3dArray[i] = this.verts[i];
                }
                this.verts = point3dArray;
            }
            this.verts[this.nVerts++] = new Point3d(d2, d3, d4);
        }
    }

    private void computeAllVerts() {
        int n;
        this.nVerts = 0;
        if (this.boundsIsEmpty) {
            this.verts = null;
            return;
        }
        this.verts = new Point3d[this.planes.length * this.planes.length];
        for (n = 0; n < this.planes.length; ++n) {
            this.pDotN[n] = -this.planes[n].x * this.planes[n].w * this.planes[n].x - this.planes[n].y * this.planes[n].w * this.planes[n].y - this.planes[n].z * this.planes[n].w * this.planes[n].z;
        }
        for (int i = 0; i < this.planes.length - 2; ++i) {
            for (int j = i + 1; j < this.planes.length - 1; ++j) {
                for (int k = j + 1; k < this.planes.length; ++k) {
                    this.computeVertex(i, j, k);
                }
            }
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        Point3d[] point3dArray = new Point3d[this.nVerts];
        for (n = 0; n < this.nVerts; ++n) {
            d3 += this.verts[n].x;
            d2 += this.verts[n].y;
            d += this.verts[n].z;
            point3dArray[n] = this.verts[n];
        }
        this.verts = point3dArray;
        this.centroid.x = d3 / (double)this.nVerts;
        this.centroid.y = d2 / (double)this.nVerts;
        this.centroid.z = d / (double)this.nVerts;
        this.checkBoundsIsEmpty();
    }

    private boolean pointInPolytope(double d, double d2, double d3) {
        for (int i = 0; i < this.planes.length; ++i) {
            if (!(d * this.planes[i].x + d2 * this.planes[i].y + d3 * this.planes[i].z + this.planes[i].w > 1.0E-6)) continue;
            return false;
        }
        return true;
    }

    private void checkBoundsIsEmpty() {
        this.boundsIsEmpty = this.planes.length < 4;
    }

    private void initEmptyPolytope() {
        this.planes = new Vector4d[6];
        this.pDotN = new double[6];
        this.mag = new double[6];
        this.verts = new Point3d[this.planes.length * this.planes.length];
        this.nVerts = 0;
        this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -1.0);
        this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, -1.0);
        this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -1.0);
        this.planes[3] = new Vector4d(0.0, -1.0, 0.0, -1.0);
        this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -1.0);
        this.planes[5] = new Vector4d(0.0, 0.0, -1.0, -1.0);
        this.mag[0] = 1.0;
        this.mag[1] = 1.0;
        this.mag[2] = 1.0;
        this.mag[3] = 1.0;
        this.mag[4] = 1.0;
        this.mag[5] = 1.0;
        this.checkBoundsIsEmpty();
    }

    Point3d getCenter() {
        return this.centroid;
    }

    public void getCenter(Point3d point3d) {
        point3d.set((Tuple3d)this.centroid);
    }

    Bounds copy(Bounds bounds) {
        if (bounds != null && this.boundId == bounds.boundId) {
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            if (boundingPolytope.planes.length != this.planes.length) {
                int n;
                boundingPolytope.planes = new Vector4d[this.planes.length];
                for (n = 0; n < boundingPolytope.planes.length; ++n) {
                    boundingPolytope.planes[n] = new Vector4d();
                }
                boundingPolytope.mag = new double[this.planes.length];
                boundingPolytope.pDotN = new double[this.planes.length];
                boundingPolytope.verts = new Point3d[this.nVerts];
                boundingPolytope.nVerts = this.nVerts;
                for (n = 0; n < this.nVerts; ++n) {
                    boundingPolytope.verts[n] = new Point3d(this.verts[n]);
                }
            }
            for (int i = 0; i < this.planes.length; ++i) {
                boundingPolytope.planes[i].x = this.planes[i].x;
                boundingPolytope.planes[i].y = this.planes[i].y;
                boundingPolytope.planes[i].z = this.planes[i].z;
                boundingPolytope.planes[i].w = this.planes[i].w;
                boundingPolytope.mag[i] = this.mag[i];
            }
            boundingPolytope.boundsIsEmpty = this.boundsIsEmpty;
            boundingPolytope.boundsIsInfinite = this.boundsIsInfinite;
            return boundingPolytope;
        }
        return (Bounds)this.clone();
    }

    int getPickType() {
        return 8;
    }
}

