/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.Application;
import java.util.ArrayDeque;
import java.util.Deque;

public final class EventLoop {
    private static final Deque<EventLoop> stack = new ArrayDeque<EventLoop>();
    private State state = State.IDLE;
    private Object returnValue;

    EventLoop() {
    }

    public State getState() {
        Application.checkEventThread();
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object enter() {
        Object object;
        Application.checkEventThread();
        if (!this.state.equals((Object)State.IDLE)) {
            throw new IllegalStateException("The event loop object isn't idle");
        }
        this.state = State.ACTIVE;
        stack.push(this);
        try {
            Application.GetApplication();
            Object ret = Application.enterNestedEventLoop();
            assert (ret == this) : "Internal inconsistency - wrong EventLoop";
            assert (stack.peek() == this) : "Internal inconsistency - corrupted event loops stack";
            assert (this.state.equals((Object)State.LEAVING)) : "The event loop isn't leaving";
            object = this.returnValue;
            this.returnValue = null;
            this.state = State.IDLE;
            stack.pop();
        }
        catch (Throwable throwable) {
            this.returnValue = null;
            this.state = State.IDLE;
            stack.pop();
            if (!stack.isEmpty() && EventLoop.stack.peek().state.equals((Object)State.LEAVING)) {
                Application.GetApplication();
                Application.invokeLater(new Runnable(){

                    public void run() {
                        EventLoop loop = (EventLoop)stack.peek();
                        if (loop != null && loop.state.equals((Object)State.LEAVING)) {
                            Application.GetApplication();
                            Application.leaveNestedEventLoop(loop);
                        }
                    }
                });
            }
            throw throwable;
        }
        if (!stack.isEmpty() && EventLoop.stack.peek().state.equals((Object)State.LEAVING)) {
            Application.GetApplication();
            Application.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
        return object;
    }

    public void leave(Object ret) {
        Application.checkEventThread();
        if (!this.state.equals((Object)State.ACTIVE)) {
            throw new IllegalStateException("The event loop object isn't active");
        }
        this.state = State.LEAVING;
        this.returnValue = ret;
        if (stack.peek() == this) {
            Application.GetApplication();
            Application.leaveNestedEventLoop(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        IDLE,
        ACTIVE,
        LEAVING;

    }
}

