/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.effect;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.BoundsAccessor;
import javafx.scene.Node;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.Effect;

public class EffectUtils {
    public static BaseBounds transformBounds(BaseTransform baseTransform, BaseBounds baseBounds) {
        if (baseTransform == null || baseTransform.isIdentity()) {
            return baseBounds;
        }
        BaseBounds baseBounds2 = new RectBounds();
        baseBounds2 = baseTransform.transform(baseBounds, baseBounds2);
        return baseBounds2;
    }

    public static int getKernelSize(int n, int n2) {
        if (n < 1) {
            n = 1;
        }
        n = (n - 1) * n2 + 1;
        return (n |= 1) / 2;
    }

    public static BaseBounds getShadowBounds(BaseBounds baseBounds, BaseTransform baseTransform, float f, float f2, BlurType blurType) {
        int n = 0;
        int n2 = 0;
        switch (blurType) {
            case GAUSSIAN: {
                float f3 = f < 1.0f ? 0.0f : (f - 1.0f) / 2.0f;
                float f4 = f2 < 1.0f ? 0.0f : (f2 - 1.0f) / 2.0f;
                n = (int)Math.ceil(f3);
                n2 = (int)Math.ceil(f4);
                break;
            }
            case ONE_PASS_BOX: {
                n = EffectUtils.getKernelSize(Math.round(f / 3.0f), 1);
                n2 = EffectUtils.getKernelSize(Math.round(f2 / 3.0f), 1);
                break;
            }
            case TWO_PASS_BOX: {
                n = EffectUtils.getKernelSize(Math.round(f / 3.0f), 2);
                n2 = EffectUtils.getKernelSize(Math.round(f2 / 3.0f), 2);
                break;
            }
            case THREE_PASS_BOX: {
                n = EffectUtils.getKernelSize(Math.round(f / 3.0f), 3);
                n2 = EffectUtils.getKernelSize(Math.round(f2 / 3.0f), 3);
            }
        }
        baseBounds = baseBounds.deriveWithPadding(n, n2, 0.0f);
        return EffectUtils.transformBounds(baseTransform, baseBounds);
    }

    public static BaseBounds getInputBounds(BaseBounds baseBounds, BaseTransform baseTransform, Node node, BoundsAccessor boundsAccessor, Effect effect) {
        baseBounds = effect != null ? effect.impl_getBounds(baseBounds, baseTransform, node, boundsAccessor) : boundsAccessor.getGeomBounds(baseBounds, baseTransform, node);
        return baseBounds;
    }
}

