/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.apache.commons.collections.map.ReferenceMap;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.AbstractDialog;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.utils.ZapTextField;

public class FindDialog
extends AbstractDialog {
    private static final long serialVersionUID = -3223449799557586758L;
    private static Map<Object, FindDialog> parentsMap = new ReferenceMap(2, 0);
    private JPanel jPanel = null;
    private JButton btnFind = null;
    private JButton btnCancel = null;
    private ZapTextField txtFind = null;
    private JPanel jPanel1 = null;
    private JTextComponent lastInvoker = null;

    public void setLastInvoker(JTextComponent lastInvoker) {
        this.lastInvoker = lastInvoker;
    }

    @Deprecated
    public FindDialog() throws HeadlessException {
        this.initialize();
    }

    @Deprecated
    public FindDialog(Frame arg0, boolean arg1) throws HeadlessException {
        super(arg0, arg1);
        this.initialize();
    }

    public FindDialog(Window parent, boolean modal) throws HeadlessException {
        super(parent, modal);
        this.initialize();
    }

    private void initialize() {
        this.setVisible(false);
        this.setResizable(false);
        this.setTitle(Constant.messages.getString("edit.find.title"));
        this.setContentPane(this.getJPanel());
        if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.setSize(261, 111);
        }
        this.centreDialog();
        this.txtFind.requestFocus();
        this.getRootPane().setDefaultButton(this.btnFind);
        this.pack();
        this.setVisible(true);
    }

    private static Map<Object, FindDialog> getParentsMap() {
        return parentsMap;
    }

    public static FindDialog getDialog(final Window parent, boolean modal) {
        if (parent == null) {
            throw new IllegalArgumentException("The parent must not be null.");
        }
        FindDialog activeDialog = FindDialog.getParentsMap().get(parent);
        if (activeDialog != null) {
            activeDialog.getTxtFind().requestFocus();
            return activeDialog;
        }
        FindDialog newDialog = new FindDialog(parent, modal);
        FindDialog.getParentsMap().put(parent, newDialog);
        newDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                FindDialog.getParentsMap().remove(parent);
            }
        });
        return newDialog;
    }

    private void discard() {
        this.setVisible(false);
        this.dispose();
    }

    private void find() {
        JFrame parent;
        Component c;
        JTextComponent txtComp = this.lastInvoker;
        if (txtComp == null && (c = (parent = (JFrame)this.getParent()).getMostRecentFocusOwner()) instanceof JTextComponent) {
            txtComp = (JTextComponent)c;
        }
        if (txtComp == null) {
            return;
        }
        try {
            String findText = this.txtFind.getText().toLowerCase();
            String txt = txtComp.getText().toLowerCase();
            int startPos = txt.indexOf(findText, txtComp.getCaretPosition());
            if (startPos <= 0) {
                txtComp.setCaretPosition(0);
                startPos = txt.indexOf(findText, txtComp.getCaretPosition());
            }
            int length = findText.length();
            if (startPos > -1) {
                txtComp.select(startPos, startPos + length);
                txtComp.requestFocusInWindow();
                this.txtFind.requestFocusInWindow();
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            JLabel jLabel = new JLabel();
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            jLabel.setText(Constant.messages.getString("edit.find.label.what"));
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.insets = new Insets(2, 10, 2, 10);
            gridBagConstraints1.anchor = 17;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.insets = new Insets(12, 2, 8, 10);
            gridBagConstraints5.ipadx = 50;
            gridBagConstraints5.gridwidth = 2;
            gridBagConstraints6.gridwidth = 3;
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 1;
            gridBagConstraints6.insets = new Insets(2, 2, 2, 2);
            this.jPanel.add((Component)jLabel, gridBagConstraints1);
            this.jPanel.add((Component)this.getTxtFind(), gridBagConstraints5);
            this.jPanel.add((Component)this.getJPanel1(), gridBagConstraints6);
        }
        return this.jPanel;
    }

    private JButton getBtnFind() {
        if (this.btnFind == null) {
            this.btnFind = new JButton();
            this.btnFind.setText(Constant.messages.getString("edit.find.button.find"));
            this.btnFind.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FindDialog.this.find();
                }
            });
        }
        return this.btnFind;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setText(Constant.messages.getString("edit.find.button.cancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FindDialog.this.discard();
                    FindDialog.this.dispatchEvent(new WindowEvent(FindDialog.this, 201));
                }
            });
        }
        return this.btnCancel;
    }

    private ZapTextField getTxtFind() {
        if (this.txtFind == null) {
            this.txtFind = new ZapTextField();
            this.txtFind.setMinimumSize(new Dimension(120, 24));
            this.txtFind.setPreferredSize(new Dimension(120, 24));
        }
        return this.txtFind;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            this.jPanel1.setMinimumSize(new Dimension(155, 35));
            this.jPanel1.add((Component)this.getBtnFind(), null);
            this.jPanel1.add((Component)this.getBtnCancel(), null);
        }
        return this.jPanel1;
    }
}

