/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.protocol.json.internal;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.util.Base64;
import com.amazonaws.util.StringUtils;
import java.nio.charset.Charset;
import java.util.Date;

@SdkInternalApi
public class ValueToStringConverters {
    public static final ValueToString<String> FROM_STRING = new ValueToString<String>(){

        @Override
        public String convert(String val2) {
            return val2;
        }
    };
    public static final ValueToString<Integer> FROM_INTEGER = new ValueToString<Integer>(){

        @Override
        public String convert(Integer val2) {
            return StringUtils.fromInteger(val2);
        }
    };
    public static final ValueToString<Long> FROM_LONG = new ValueToString<Long>(){

        @Override
        public String convert(Long val2) {
            return StringUtils.fromLong(val2);
        }
    };
    public static final ValueToString<Float> FROM_FLOAT = new ValueToString<Float>(){

        @Override
        public String convert(Float val2) {
            return StringUtils.fromFloat(val2);
        }
    };
    public static final ValueToString<Double> FROM_DOUBLE = new ValueToString<Double>(){

        @Override
        public String convert(Double val2) {
            return StringUtils.fromDouble(val2);
        }
    };
    public static final ValueToString<Boolean> FROM_BOOLEAN = new ValueToString<Boolean>(){

        @Override
        public String convert(Boolean val2) {
            return StringUtils.fromBoolean(val2);
        }
    };
    public static final ValueToString<Date> FROM_DATE = new ValueToString<Date>(){

        @Override
        public String convert(Date val2) {
            return StringUtils.fromDate(val2);
        }
    };
    public static final ValueToString<String> FROM_JSON_VALUE_HEADER = new ValueToString<String>(){

        @Override
        public String convert(String val2) {
            return Base64.encodeAsString(val2.getBytes(Charset.forName("utf-8")));
        }
    };

    public static interface ValueToString<T> {
        public String convert(T var1);
    }
}

