/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.filemonitor.thread;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import net.sourceforge.glsof.common.lsof.LsofExecutorObserver;
import net.sourceforge.glsof.common.lsof.LsofParametersBuilder;
import net.sourceforge.glsof.common.model.Preferences;
import net.sourceforge.glsof.common.rmi.RmiService;
import net.sourceforge.glsof.common.rmi.RmiUtils;
import net.sourceforge.glsof.filemonitor.MonitorTable;
import net.sourceforge.glsof.filemonitor.repository.FileMonitorPreferencesRepository;
import net.sourceforge.glsof.filemonitor.thread.AbstractMonitorTableUpdater;

public class RemoteMonitorTableUpdater
extends AbstractMonitorTableUpdater {
    private static final long serialVersionUID = 1L;
    private RmiService _remoteService;

    public RemoteMonitorTableUpdater(MonitorTable table) {
        super(table);
    }

    @Override
    protected Void doInBackground() throws Exception {
        Preferences preferences = FileMonitorPreferencesRepository.getCurrentPreferences();
        this._remoteService = RmiUtils.initRmiService(new RmiClientObserver(), preferences.getLocation());
        String lsofParameters = new LsofParametersBuilder().build(preferences);
        while (!this.isCancelled()) {
            this._remoteService.fetch(lsofParameters);
        }
        return null;
    }

    @Override
    protected void stopLsofExecutor() {
        try {
            this._remoteService.stop();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private class RmiClientObserver
    extends UnicastRemoteObject
    implements LsofExecutorObserver {
        protected RmiClientObserver() throws RemoteException {
        }

        @Override
        public void flush(String[] row) {
            RemoteMonitorTableUpdater.this.flush(row);
        }

        @Override
        public void finished() {
            RemoteMonitorTableUpdater.this.finished();
        }

        @Override
        public void stop() {
            RemoteMonitorTableUpdater.this.stop();
        }

        @Override
        public void displayErrorMessage(String text) {
            RemoteMonitorTableUpdater.this.displayErrorMessage(text);
        }
    }
}

