/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_az extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "\u0259r\u0259b";
        final String metaValue_bn = "benqal";
        final String metaValue_bo = "tibet";
        final String metaValue_el = "yunan";
        final String metaValue_gu = "qucarat";
        final String metaValue_hy = "erm\u0259ni";
        final String metaValue_ja = "yapon";
        final String metaValue_ka = "g\u00fcrc\u00fc";
        final String metaValue_km = "kxmer";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "koreya";
        final String metaValue_la = "lat\u0131n";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "monqol";
        final String metaValue_or = "oriya";
        final String metaValue_si = "sinhal";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "teluqu";
        final String metaValue_th = "tay";
        final String metaValue_tl = "taqaloq";
        final String metaValue_chr = "\u00e7iroki";
        final String metaValue_sam = "samaritan";
        final String metaValue_syr = "siryak";
        final Object[][] data = new Object[][] {
            { "Ogam", "o\u011fam" },
            { "mwl", "mirand" },
            { "Zsym", "simvollar" },
            { "cch", "atsamca" },
            { "mwr", "maruari" },
            { "Tagb", "taqbanva" },
            { "egy", "q\u0259dimi misir" },
            { "raj", "racastan" },
            { "Phag", "faqs-pa" },
            { "tem", "timne" },
            { "teo", "teso" },
            { "rap", "rapanu" },
            { "ter", "tereno" },
            { "AC", "Y\u00fcks\u0259li\u015f Adas\u0131" },
            { "rar", "rarotonqan" },
            { "tet", "tetum" },
            { "AD", "Andorra" },
            { "AE", "Birl\u0259\u015fmi\u015f \u018fr\u0259b \u018fmirlikl\u0259ri" },
            { "nl_BE", "flamand" },
            { "AF", "\u018ffqan\u0131stan" },
            { "AG", "Antiqua v\u0259 Barbuda" },
            { "AI", "Angila" },
            { "AL", "Albaniya" },
            { "AM", "Erm\u0259nistan" },
            { "Teng", "tengvar" },
            { "AO", "Anqola" },
            { "AQ", "Antarktika" },
            { "AR", "Argentina" },
            { "Prti", "prti" },
            { "AS", "Amerika Samoas\u0131" },
            { "AT", "Avstriya" },
            { "AU", "Avstraliya" },
            { "AW", "Aruba" },
            { "en_US", "Amerika ingilisc\u0259si" },
            { "AX", "Aland Adalar\u0131" },
            { "AZ", "Az\u0259rbaycan" },
            { "BA", "Bosniya v\u0259 Hersoqovina" },
            { "BB", "Barbados" },
            { "ceb", "kebuano" },
            { "BD", "Banqlade\u015f" },
            { "kum", "kumuk" },
            { "BE", "Bel\u00e7ika" },
            { "gmh", "ortacaq y\u00fcks\u0259k almanca" },
            { "BF", "Burkina Faso" },
            { "BG", "Bolqariya" },
            { "BH", "B\u0259hreyn" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "San Bartolomey" },
            { "BM", "Bermuda" },
            { "kut", "kutenay" },
            { "myv", "erzya" },
            { "BN", "Bruney" },
            { "BO", "Boliviya" },
            { "BQ", "Karib Niderland\u0131" },
            { "BR", "Braziliya" },
            { "BS", "Baham Adalar\u0131" },
            { "xog", "soqa" },
            { "BT", "Butan" },
            { "BV", "Buve Adas\u0131" },
            { "BW", "Botsvana" },
            { "BY", "Belarus" },
            { "BZ", "Beliz" },
            { "Visp", "dan\u0131\u015fma s\u0259sl\u0259ri" },
            { "CA", "Kanada" },
            { "CC", "Kokos Adalar\u0131" },
            { "mzn", "mazandaran" },
            { "CD", "Konqo - Kin\u015fasa" },
            { "CF", "M\u0259rk\u0259zi Afrika Respublikas\u0131" },
            { "CG", "Konqo - Brazzavil" },
            { "CH", "\u0130sve\u00e7r\u0259" },
            { "CI", "Fil Di\u015fi Sahili" },
            { "CK", "Kuk Adalar\u0131" },
            { "CL", "\u00c7ili" },
            { "Kthi", "kti" },
            { "CM", "Kamerun" },
            { "CN", "\u00c7in" },
            { "CO", "Kolumbiya" },
            { "CP", "Klipperton Adas\u0131" },
            { "CR", "Kosta Rika" },
            { "CU", "Kuba" },
            { "CV", "Kape Verde" },
            { "CW", "Kurasao" },
            { "CX", "Milad Adas\u0131" },
            { "CY", "Kipr" },
            { "CZ", "\u00c7exiya" },
            { "eka", "ekacuk" },
            { "DE", "Almaniya" },
            { "goh", "q\u0259dimi almanca" },
            { "ace", "akin" },
            { "cgg", "\u00e7iqa" },
            { "DG", "Dieqo Qarsiya" },
            { "DJ", "Cibuti" },
            { "DK", "Danimarka" },
            { "ach", "akoli" },
            { "gon", "qondi" },
            { "Brai", "brayl" },
            { "Brah", "brahmi" },
            { "DM", "Dominika" },
            { "DO", "Dominikan Respublikas\u0131" },
            { "gor", "qorontalo" },
            { "got", "got\u00e7a" },
            { "Mtei", "meytey mayek" },
            { "zun", "zuni" },
            { "tig", "tiqre" },
            { "DZ", "\u018flc\u0259zair" },
            { "pag", "panqasinan" },
            { "pal", "paxlavi" },
            { "EA", "Seuta v\u0259 Melilya" },
            { "chb", "\u00e7ib\u00e7\u0259" },
            { "pam", "pampanqa" },
            { "EC", "Ekvador" },
            { "pap", "papyamento" },
            { "ada", "adangme" },
            { "EE", "Estoniya" },
            { "tiv", "tiv" },
            { "EG", "Misir" },
            { "EH", "Q\u0259rbi Sahara" },
            { "chg", "\u00e7a\u011fatay" },
            { "pau", "palayanca" },
            { "chk", "\u00e7ukiz" },
            { "chn", "\u00e7inuk l\u0259h\u00e7\u0259si" },
            { "chm", "mari" },
            { "chp", "\u00e7ipevyan" },
            { "cho", "\u00e7oktau" },
            { "chr", metaValue_chr },
            { "ER", "Eritreya" },
            { "ES", "\u0130spaniya" },
            { "ET", "Efiopiya" },
            { "EU", "Avropa Birliyi" },
            { "elx", "elamit" },
            { "chy", "\u00e7eyen" },
            { "Inds", "hindistan" },
            { "ady", "aduge" },
            { "FI", "Finlandiya" },
            { "FJ", "Fici" },
            { "FK", "Folklend Adalar\u0131" },
            { "FM", "Mikroneziya" },
            { "FO", "Farer Adalar\u0131" },
            { "Taml", metaValue_ta },
            { "FR", "Fransa" },
            { "tkl", "tokelay" },
            { "grb", "qrebo" },
            { "root", "rut" },
            { "grc", "q\u0259dimi yunanca" },
            { "GA", "Qabon" },
            { "vot", "votik" },
            { "GB", "Birl\u0259\u015fmi\u015f Krall\u0131q" },
            { "GD", "Qrenada" },
            { "GE", "G\u00fcrc\u00fcstan" },
            { "GF", "Frans\u0131z Qviyanas\u0131" },
            { "GG", "Gernsey" },
            { "GH", "Qana" },
            { "Tale", "tay le" },
            { "GI", "Gibraltar" },
            { "afh", "afrihili" },
            { "GL", "Qrenlandiya" },
            { "enm", "ortacaq ingilisc\u0259" },
            { "GM", "Qambiya" },
            { "GN", "Qvineya" },
            { "GP", "Qvadelupa" },
            { "GQ", "Ekvatorial Qvineya" },
            { "GR", "Yunan\u0131stan" },
            { "GS", "C\u0259nubi Corciya v\u0259 C\u0259nubi Sendvi\u00e7 Adalar\u0131" },
            { "GT", "Qvatemala" },
            { "GU", "Quam" },
            { "GW", "Qvineya-Bisau" },
            { "tli", "tlinqit" },
            { "tlh", "klinqon" },
            { "Talu", "t\u0259z\u0259 tay lu" },
            { "GY", "Qviyana" },
            { "ckb", "sorani k\u00fcrd" },
            { "zxx", "dil m\u0259zmunu yoxdur" },
            { "de_AT", "Avstriya almancas\u0131" },
            { "HK", "Honq Konq X\u00fcsusi \u0130nzibati \u018frazi \u00c7in" },
            { "Vaii", "vay" },
            { "HM", "Herd v\u0259 Mak Donald Adalar\u0131" },
            { "HN", "Honduras" },
            { "HR", "Xorvatiya" },
            { "agq", "aqhem" },
            { "gsw", "\u0130sve\u00e7r\u0259 almancas\u0131" },
            { "HT", "Haiti" },
            { "HU", "Macar\u0131stan" },
            { "tmh", "tama\u015fek" },
            { "IC", "Kanar Adalar\u0131" },
            { "ID", "\u0130ndoneziya" },
            { "peo", "q\u0259dimi farsca" },
            { "IE", "\u0130rlandiya" },
            { "nap", "neapolital" },
            { "naq", "nama" },
            { "zza", "zaza" },
            { "IL", "\u0130srail" },
            { "IM", "Men Adas\u0131" },
            { "IN", "Hindistan" },
            { "IO", "Britaniya Hind Okean\u0131 \u018frazisi" },
            { "IQ", "\u0130raq" },
            { "IR", "\u0130ran" },
            { "IS", "\u0130slandiya" },
            { "IT", "\u0130taliya" },
            { "Zmth", "zmth" },
            { "JE", "Cersi" },
            { "Beng", metaValue_bn },
            { "JM", "Yamayka" },
            { "JO", "\u0130ordaniya" },
            { "JP", "Yaponiya" },
            { "ain", "aynuca" },
            { "guz", "qusi" },
            { "tog", "niyasa tonga" },
            { "Kali", "kayax li" },
            { "de_CH", "\u0130sve\u00e7r\u0259 y\u00fcks\u0259k almancas\u0131" },
            { "KE", "Keniya" },
            { "419", "Lat\u0131n Amerikas\u0131" },
            { "KG", "Q\u0131r\u011f\u0131z\u0131stan" },
            { "KH", "Kamboca" },
            { "KI", "Kiribati" },
            { "KM", "Komor Adalar\u0131" },
            { "Knda", metaValue_kn },
            { "KN", "San Kits v\u0259 Nevis" },
            { "fr_CA", "Kanada frans\u0131zcas\u0131" },
            { "KP", "\u015eimali Koreya" },
            { "KR", "C\u0259nubi Koreya" },
            { "Plrd", "polard fonetik" },
            { "fr_CH", "\u0130sve\u00e7r\u0259 frans\u0131zcas\u0131" },
            { "KW", "K\u00fcveyt" },
            { "tpi", "tok pisin" },
            { "KY", "Kayman Adalar\u0131" },
            { "KZ", "Qazax\u0131stan" },
            { "Cyrl", "kiril" },
            { "LA", "Laos" },
            { "LB", "Livan" },
            { "LC", "San L\u00fcsiya" },
            { "phn", "foyenik" },
            { "Cyrs", "q\u0259dimi kilsa kirili" },
            { "gwi", "qvi\u00e7in" },
            { "nds", "a\u015fa\u011f\u0131 almanca" },
            { "LI", "Lixten\u015fteyn" },
            { "LK", "\u015eri Lanka" },
            { "akk", "akadianca" },
            { "cop", "kopt" },
            { "LR", "Liberiya" },
            { "LS", "Lesoto" },
            { "Phlv", "kitab paxlavi" },
            { "LT", "Litva" },
            { "LU", "L\u00fcksemburq" },
            { "LV", "Latviya" },
            { "Kana", "katakana" },
            { "LY", "Liviya" },
            { "lad", "ladin" },
            { "vun", "vunyo" },
            { "lah", "laxnda" },
            { "lag", "langi" },
            { "Thaa", "thana" },
            { "MA", "M\u0259rake\u015f" },
            { "MC", "Monako" },
            { "MD", "Moldova" },
            { "ME", "Monteneqro" },
            { "MF", "San Martin" },
            { "lam", "lamba" },
            { "MG", "Madaqaskar" },
            { "Thai", metaValue_th },
            { "MH", "Mar\u015fal Adalar\u0131" },
            { "ale", "aleutca" },
            { "MK", "Makedoniya" },
            { "ML", "Mali" },
            { "MM", "Myanma" },
            { "MN", "Monqoliya" },
            { "new", "nevari" },
            { "MO", "Makao X\u00fcsusi \u0130nzibati \u018frazi \u00c7in" },
            { "MP", "\u015eimali Mariana Adalar\u0131" },
            { "MQ", "Martinik" },
            { "MR", "Mavritaniya" },
            { "MS", "Monserat" },
            { "MT", "Malta" },
            { "MU", "Mavriki" },
            { "alt", "c\u0259nub altay" },
            { "MV", "Maldiv Adalar\u0131" },
            { "MW", "Malavi" },
            { "MX", "Meksika" },
            { "MY", "Malayziya" },
            { "MZ", "Mozambik" },
            { "Phli", "fli" },
            { "NA", "Namibiya" },
            { "NC", "Yeni Kaledoniya" },
            { "NE", "Niger" },
            { "NF", "Norfolk Adas\u0131" },
            { "NG", "Nigeriya" },
            { "Phlp", "flp" },
            { "NI", "Nikaraqua" },
            { "Hmng", "pahav monq" },
            { "NL", "Niderland" },
            { "NO", "Norve\u00e7" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "Phnx", "foenik" },
            { "rof", "rombo" },
            { "tsi", "sim\u015fyan" },
            { "NZ", "Yeni Zelandiya" },
            { "rom", "roman" },
            { "Mero", "meroytik" },
            { "crh", "kr\u0131m t\u00fcrk\u00e7\u0259" },
            { "ang", "q\u0259dimi ingilisc\u0259" },
            { "OM", "Oman" },
            { "anp", "angik\u0259" },
            { "Xpeo", "q\u0259dimi fars" },
            { "PA", "Panama" },
            { "csb", "ka\u015fubyan" },
            { "en_GB", "Britaniya ingilisc\u0259si" },
            { "PE", "Peru" },
            { "PF", "Frans\u0131z Polineziyas\u0131" },
            { "PG", "Papua Yeni Qvineya" },
            { "PH", "Filippin" },
            { "PK", "Pakistan" },
            { "PL", "Pol\u015fa" },
            { "ewo", "evondo" },
            { "PM", "San Pier v\u0259 Mikelon" },
            { "PN", "Pitkern Adalar\u0131" },
            { "PR", "Puerto Riko" },
            { "PS", "F\u0259l\u0259stin \u018frazil\u0259ri" },
            { "Bali", "bali" },
            { "PT", "Portuqal" },
            { "PW", "Palau" },
            { "nia", "nyas" },
            { "PY", "Paraqvay" },
            { "tum", "tumbuka" },
            { "Hebr", "ibrani" },
            { "QA", "Qatar" },
            { "niu", "niyuan" },
            { "QO", "Uzaq Okeaniya" },
            { "lez", "l\u0259zqi" },
            { "tvl", "tuvalu" },
            { "Tavt", "tavt" },
            { "001", "D\u00fcnya" },
            { "002", "Afrika" },
            { "003", "\u015eimali Amerika" },
            { "RE", "Reunion" },
            { "005", "C\u0259nubi Amerika" },
            { "jbo", "lo\u011fban" },
            { "Rjng", "rec\u0259ng" },
            { "009", "Okeaniya" },
            { "RO", "Rum\u0131niya" },
            { "RS", "Serbiya" },
            { "RU", "Rusiya" },
            { "RW", "Ruanda" },
            { "Mani", "mani\u00e7ayen" },
            { "Ugar", "uqarit" },
            { "Khar", "xaro\u015fti" },
            { "SA", "S\u0259udiyy\u0259 \u018fr\u0259bistan\u0131" },
            { "pon", "ponpeyan" },
            { "Mand", "mandayen" },
            { "SB", "Solomon Adalar\u0131" },
            { "twq", "tasavaq" },
            { "011", "Q\u0259rbi Afrika" },
            { "SC", "Sey\u015fel Adalar\u0131" },
            { "SD", "Sudan" },
            { "013", "M\u0259rk\u0259zi Amerika" },
            { "SE", "\u0130sve\u00e7" },
            { "014", "\u015e\u0259rqi Afrika" },
            { "arc", "aramik" },
            { "015", "\u015eimali Afrika" },
            { "SG", "Sinqapur" },
            { "SH", "M\u00fcq\u0259dd\u0259s Yelena" },
            { "017", "M\u0259rk\u0259zi Afrika" },
            { "SI", "Sloveniya" },
            { "018", "C\u0259nubi Afrika" },
            { "SJ", "Svalbard v\u0259 Yan Mayen" },
            { "019", "Amerikalar" },
            { "SK", "Slovakiya" },
            { "SL", "Siera Leon" },
            { "SM", "San Marino" },
            { "SN", "Seneqal" },
            { "SO", "Somali" },
            { "arn", "araukanca" },
            { "arp", "arapaho" },
            { "SR", "Surinam" },
            { "SS", "C\u0259nubi Sudan" },
            { "ST", "Sao Tome v\u0259 Prinsip" },
            { "SV", "Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Suriya" },
            { "yao", "yao" },
            { "SZ", "Svazilend" },
            { "arw", "aravak\u00e7a" },
            { "yap", "yapiz" },
            { "TA", "Tristan da Kunya" },
            { "asa", "asu" },
            { "021", "\u015eimal Amerikas\u0131" },
            { "TC", "Turks v\u0259 Kaikos Adalar\u0131" },
            { "TD", "\u00c7ad" },
            { "TF", "Fransa C\u0259nub \u018frazil\u0259ri" },
            { "TG", "Toqo" },
            { "TH", "Tayland" },
            { "TJ", "Tacikistan" },
            { "029", "Karib" },
            { "TK", "Tokelau" },
            { "TL", "\u015e\u0259rqi Timor" },
            { "TM", "T\u00fcrkm\u0259nistan" },
            { "TN", "Tunis" },
            { "TO", "Tonqa" },
            { "TR", "T\u00fcrkiya" },
            { "TT", "Trinidad v\u0259 Tobaqo" },
            { "TV", "Tuvalu" },
            { "TW", "Tayvan" },
            { "ast", "asturic\u0259" },
            { "Orkh", "orxon" },
            { "TZ", "Tanzaniya" },
            { "nmg", "kvasio" },
            { "Zzzz", "nam\u0259lum skript" },
            { "UA", "Ukrayna" },
            { "rup", "aromanca" },
            { "030", "\u015e\u0259rqi Asiya" },
            { "tyv", "tuvinyan" },
            { "sw_CD", "Konqo suahilic\u0259si" },
            { "034", "C\u0259nubi Asiya" },
            { "hai", "hayda" },
            { "035", "C\u0259nub-\u015e\u0259rqi Asiya" },
            { "UG", "Uqanda" },
            { "039", "C\u0259nubi Avropa" },
            { "Sinh", metaValue_si },
            { "UM", "Birl\u0259\u015fmi\u015f \u015etatlar Uzaq Adalar" },
            { "US", "Amerika Birl\u0259\u015fmi\u015f \u015etatlar\u0131" },
            { "haw", "havay" },
            { "UY", "Uruqvay" },
            { "UZ", "\u00d6zb\u0259kistan" },
            { "tzm", "M\u0259rk\u0259zi Atlas tamazic\u0259si" },
            { "VA", "Vatikan" },
            { "pro", "q\u0259dimi provensialca" },
            { "VC", "San Vinsent v\u0259 Qrenada" },
            { "VE", "Venesuela" },
            { "VG", "Britaniya Vircin Adalar\u0131" },
            { "VI", "AB\u015e Vircin Adalar\u0131" },
            { "VN", "Vyetnam" },
            { "VU", "Vanuatu" },
            { "nog", "noqay" },
            { "rwk", "rua" },
            { "non", "q\u0259dimi norsca" },
            { "053", "Avstralaziya" },
            { "054", "Melaneziya" },
            { "WF", "Uolis v\u0259 Futuna" },
            { "057", "Mikroneziya Regionu" },
            { "jgo", "nqomba" },
            { "lkt", "lakota" },
            { "WS", "Samoa" },
            { "wal", "valamo" },
            { "was", "va\u015fo" },
            { "war", "varay" },
            { "awa", "avadic\u0259" },
            { "061", "Polineziya" },
            { "XK", "Kosovo" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "yaz\u0131s\u0131z" },
            { "Olck", "ol \u00e7iki" },
            { "wbp", "Valpiri" },
            { "Batk", "batak" },
            { "Blis", "blissymbols" },
            { "YE", "Y\u0259m\u0259n" },
            { "nqo", "nqo" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "Sgnw", "i\u015far\u0259t yaz\u0131s\u0131" },
            { "YT", "Mayot" },
            { "ZA", "C\u0259nub Afrika" },
            { "Deva", "devanaqari" },
            { "Hira", "iraqana" },
            { "ZM", "Zambiya" },
            { "ZW", "Zimbabve" },
            { "ZZ", "Nam\u0259lum Region" },
            { "Runr", "runik" },
            { "lol", "monqo" },
            { "nso", "\u015fimal soto" },
            { "loz", "lozi" },
            { "jmc", "ma\u00e7am" },
            { "hil", "hiliqaynon" },
            { "nus", "nuer" },
            { "dak", "dakota" },
            { "hit", "hittit" },
            { "dar", "darqva" },
            { "dav", "taita" },
            { "Maya", "maya hiyeroqlifi" },
            { "lrc", "\u015fimali luri" },
            { "Copt", "koptik" },
            { "udm", "udmurt" },
            { "Khmr", metaValue_km },
            { "Limb", "limbu" },
            { "sad", "sandave" },
            { "sah", "yakut" },
            { "sam", metaValue_sam },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santal" },
            { "Tfng", "tifinaq" },
            { "jpr", "judo-farsca" },
            { "Guru", "qurmuxi" },
            { "lua", "luba-lulua" },
            { "sbp", "sanqu" },
            { "lui", "luyseno" },
            { "nyn", "nyankol" },
            { "nym", "nyamvezi" },
            { "lun", "lunda" },
            { "nyo", "niyoro" },
            { "luo", "luo" },
            { "fil", "filippin" },
            { "hmn", "monq" },
            { "del", "delaver" },
            { "lus", "lushayca" },
            { "bal", "baluc" },
            { "den", "slavey" },
            { "ban", "balinc\u0259" },
            { "uga", "uqaritik" },
            { "luy", "luyia" },
            { "bas", "basa" },
            { "jrb", "jude-\u0259r\u0259bc\u0259" },
            { "es_ES", "Kastiliya ispancas\u0131" },
            { "nzi", "nizima" },
            { "sco", "skots" },
            { "scn", "sisili" },
            { "aa", "afarca" },
            { "ab", "abxaz" },
            { "ae", "avestanca" },
            { "af", "afrikaans" },
            { "ak", "akanca" },
            { "am", "amhar" },
            { "Arab", metaValue_ar },
            { "an", "aragonca" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "katakana v\u0259ya hiraqana" },
            { "as", "assam" },
            { "av", "avarikc\u0259" },
            { "sdh", "c\u0259nubi k\u00fcrd" },
            { "ay", "aymarca" },
            { "az", "az\u0259rbaycan dili" },
            { "ba", "ba\u015fq\u0131rd" },
            { "be", "belarus" },
            { "bg", "bolqar" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "doqrib" },
            { "br", "Bretonca" },
            { "bs", "bosniak" },
            { "Mymr", "myanmar" },
            { "seh", "sena" },
            { "Nkoo", "nko" },
            { "sel", "selkup" },
            { "ca", "katalan" },
            { "ses", "koyraboro senni" },
            { "ce", "\u00e7e\u00e7en" },
            { "ch", "\u00e7amoro" },
            { "co", "korsika" },
            { "Orya", metaValue_or },
            { "cr", "kri dili" },
            { "cs", "\u00e7ex" },
            { "cu", "kils\u0259 slav" },
            { "cv", "\u00e7uva\u015f" },
            { "cy", "uels" },
            { "Yiii", "yi" },
            { "da", "danimarka" },
            { "pt_PT", "Portuqaliya portuqalcas\u0131" },
            { "de", "alman" },
            { "bej", "beja" },
            { "din", "dinka" },
            { "Bugi", "buqin" },
            { "bem", "bemba" },
            { "sga", "q\u0259dimi irlandca" },
            { "dv", "diveh" },
            { "es_419", "Lat\u0131n Amerikas\u0131 ispancas\u0131" },
            { "dz", "dzonqa" },
            { "bez", "bena" },
            { "dje", "zarma" },
            { "ee", "eve" },
            { "ro_MD", "moldav" },
            { "el", metaValue_el },
            { "en", "ingilis" },
            { "eo", "esperanto" },
            { "es", "ispan" },
            { "et", "eston" },
            { "eu", "bask" },
            { "Buhd", "buhid" },
            { "Hang", "hanq\u0131l" },
            { "Samr", metaValue_sam },
            { "shi", "ta\u00e7elit" },
            { "hsb", "yuxar\u0131 sorb" },
            { "Hani", "han" },
            { "shn", "\u015fan" },
            { "Hano", "hanunu" },
            { "fa", "fars" },
            { "Hans", "sad\u0259l\u0259\u015fmi\u015f" },
            { "Hant", "\u0259n\u0259n\u0259vi" },
            { "az_Arab", "c\u0259nubi az\u0259rbaycan" },
            { "ff", "fula" },
            { "fi", "fin" },
            { "fj", "fici" },
            { "fon", "fon" },
            { "bgn", "q\u0259rbi b\u0259luc" },
            { "fo", "farer" },
            { "umb", "umbundu" },
            { "fr", "frans\u0131z" },
            { "sid", "sidamo" },
            { "fy", "q\u0259rbi friz" },
            { "ga", "irland" },
            { "gd", "skot gaelik" },
            { "gl", "qalisian" },
            { "gn", "quarani" },
            { "bho", "bxo\u00e7puri" },
            { "und", "nam\u0259lum dil" },
            { "gu", metaValue_gu },
            { "gv", "manks" },
            { "ha", "hausa" },
            { "he", "ivrit" },
            { "hi", "hindi" },
            { "hup", "hupa" },
            { "bik", "bikolca" },
            { "bin", "bini" },
            { "ho", "hiri motu" },
            { "hr", "xorvat" },
            { "ht", "haiti" },
            { "hu", "macar" },
            { "hy", metaValue_hy },
            { "hz", "Herer" },
            { "ia", "interlingua" },
            { "id", "indonez" },
            { "ie", "interlingue" },
            { "ig", "iqbo" },
            { "ii", "si\u00e7uan yi" },
            { "frm", "ortacaq frans\u0131zca" },
            { "ik", "inupiaq" },
            { "fro", "q\u0259dimi frans\u0131zca" },
            { "io", "ido" },
            { "frr", "\u015fimal fris" },
            { "is", "island" },
            { "it", "italyan" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sara", "sarati" },
            { "doi", "doqri" },
            { "sma", "c\u0259nubi sami" },
            { "jv", "yava" },
            { "Shaw", "\u015favyan" },
            { "mad", "maduriz" },
            { "smj", "lule sami" },
            { "mag", "maqahi" },
            { "mai", "maitili" },
            { "smn", "inari sami" },
            { "ka", metaValue_ka },
            { "bla", "siksik\u0259" },
            { "mak", "makasar" },
            { "sms", "skolt" },
            { "man", "m\u0259ndinqo" },
            { "kg", "konqo" },
            { "Goth", "qotik" },
            { "ki", "kikuyu" },
            { "mas", "masay" },
            { "kj", "kuanyama" },
            { "kk", "qazax" },
            { "kl", "kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanur" },
            { "ks", "ka\u015fmir" },
            { "Cirt", "sirt" },
            { "Lepc", "lep\u00e7\u0259" },
            { "Avst", "avestan" },
            { "ku", "k\u00fcrd" },
            { "kv", "komi" },
            { "kw", "korn" },
            { "ky", "q\u0131r\u011f\u0131z" },
            { "snk", "soninke" },
            { "la", metaValue_la },
            { "lb", "l\u00fcksemburq" },
            { "lg", "qanda" },
            { "Roro", "ronqoronqo" },
            { "li", "limburqi\u015f" },
            { "Tibt", metaValue_bo },
            { "ln", "linqala" },
            { "fur", "friul" },
            { "lo", "laos" },
            { "lt", "litva" },
            { "lu", "luba-katanqa" },
            { "lv", "lat\u0131\u015f" },
            { "sog", "soqdiyen" },
            { "mg", "malaqas" },
            { "mh", "mar\u015fal" },
            { "mi", "maori" },
            { "mk", "makedon" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marati" },
            { "ms", "malay" },
            { "mt", "malta" },
            { "my", "birma" },
            { "Saur", "saurastra" },
            { "Armn", metaValue_hy },
            { "mdf", "mok\u015fa" },
            { "dsb", "a\u015fa\u011f\u0131 sorb" },
            { "Armi", "armi" },
            { "na", "nauru" },
            { "nb", "bokmal norve\u00e7" },
            { "nd", "\u015fimali ndebele" },
            { "ne", "nepal" },
            { "ng", "nqonka" },
            { "mdr", "mandar" },
            { "nl", "holland" },
            { "nn", "n\u00fcnorsk norve\u00e7" },
            { "no", "norve\u00e7" },
            { "nr", "c\u0259nub ndebele" },
            { "nv", "navayo" },
            { "kaa", "qara-qalpaq" },
            { "ny", "nyanca" },
            { "kac", "ka\u00e7inca" },
            { "kab", "kabile" },
            { "oc", "oksitanca" },
            { "kaj", "ju" },
            { "kam", "kamba" },
            { "men", "mende" },
            { "oj", "ocibva" },
            { "mer", "meru" },
            { "om", "oromo" },
            { "kaw", "kavi" },
            { "or", metaValue_or },
            { "os", "osetik" },
            { "kbd", "kabardca" },
            { "mfe", "morisien" },
            { "srn", "sranan tonqo" },
            { "pa", "p\u0259ncab" },
            { "dua", "duala" },
            { "srr", "serer dilii" },
            { "pi", "pali" },
            { "pl", "polyak" },
            { "dum", "ortacaq hollandca" },
            { "ps", "pu\u015ftu" },
            { "pt", "portuqal" },
            { "mga", "ortacaq irlandca" },
            { "pt_BR", "Braziliya portuqalcas\u0131" },
            { "kcg", "tiyap" },
            { "mgh", "maxuva-meetto" },
            { "bra", "braj" },
            { "Laoo", "lao" },
            { "mgo", "meta\u2019" },
            { "qu", "ke\u00e7ua" },
            { "zap", "zapotek" },
            { "brx", "bodo" },
            { "Lana", "lanna" },
            { "kde", "makond" },
            { "Ethi", "efiop" },
            { "rm", "retoroman" },
            { "rn", "rundi" },
            { "ro", "rum\u0131n" },
            { "ru", "rus" },
            { "rw", "kinyarvanda" },
            { "zbl", "blisimbols" },
            { "kea", "kabuverdian" },
            { "mic", "mikmak" },
            { "suk", "sukuma" },
            { "en_AU", "Avstraliya ingilisc\u0259si" },
            { "sa", "sanskrit" },
            { "sc", "sardin" },
            { "sus", "susu" },
            { "sd", "sindhi" },
            { "se", "\u015fimali sami" },
            { "min", "minanqkaban" },
            { "sg", "sanqo" },
            { "sh", "serb-xorvatca" },
            { "si", metaValue_si },
            { "sux", "sumeryan" },
            { "sk", "slovak" },
            { "sl", "sloven" },
            { "sm", "samoa" },
            { "sn", "\u015fona" },
            { "so", "somali" },
            { "sq", "alban" },
            { "sr", "serb" },
            { "ss", "svati" },
            { "st", "Sesoto" },
            { "Java", "cava" },
            { "sv", "isve\u00e7" },
            { "sw", "suahili" },
            { "iba", "iban" },
            { "ta", metaValue_ta },
            { "142", "Asiya" },
            { "bua", "buryat" },
            { "143", "M\u0259rk\u0259zi Asiya" },
            { "te", metaValue_te },
            { "145", "Q\u0259rbi Asiya" },
            { "tg", "tacik" },
            { "th", metaValue_th },
            { "ti", "tiqrin" },
            { "bug", "bugin" },
            { "kfo", "koro" },
            { "en_CA", "Kanada ingilisc\u0259si" },
            { "tk", "t\u00fcrkm\u0259n" },
            { "tl", metaValue_tl },
            { "tn", "svana" },
            { "to", "tonqa" },
            { "dyo", "diola" },
            { "tr", "t\u00fcrk" },
            { "ts", "sonqa" },
            { "Cakm", "kakm" },
            { "tt", "tatar" },
            { "dyu", "dyula" },
            { "tw", "Tvi" },
            { "ty", "taxiti" },
            { "150", "Avropa" },
            { "151", "\u015e\u0259rqi Avropa" },
            { "154", "\u015eimali Avropa" },
            { "155", "Q\u0259rbi Avropa" },
            { "ug", "uy\u011fur" },
            { "Kore", metaValue_ko },
            { "Ital", "q\u0259dimi italyal\u0131" },
            { "Zyyy", "\u00fcmumi yaz\u0131" },
            { "uk", "ukrayna" },
            { "ur", "urdu" },
            { "xal", "kalm\u0131qca" },
            { "zen", "zenaqa" },
            { "uz", "\u00f6zb\u0259k" },
            { "kha", "xazi" },
            { "nds_NL", "a\u015fa\u011f\u0131 sakson" },
            { "Sylo", "siloti n\u0259qri" },
            { "ve", "venda" },
            { "vi", "vyetnam" },
            { "kho", "xotan" },
            { "khq", "koyra \u00e7iini" },
            { "vo", "volap\u00fck" },
            { "Osma", "osmanya" },
            { "quc", "ki\u00e7e" },
            { "gaa", "qa" },
            { "wa", "valun" },
            { "gag", "qaqauz" },
            { "syr", metaValue_syr },
            { "Grek", metaValue_el },
            { "Lydi", "ludian" },
            { "Xsux", "sumer-akadyan kuneyform" },
            { "wo", "volof" },
            { "zgh", "tamazi" },
            { "ar_001", "Modern Standart \u018fr\u0259bc\u0259" },
            { "Cans", "birl\u0259\u015fmi\u015f kanada yerli yaz\u0131s\u0131" },
            { "gay", "qayo" },
            { "Mong", metaValue_mn },
            { "mnc", "man\u00e7u" },
            { "Latf", "fraktur lat\u0131n\u0131" },
            { "gba", "qabaya" },
            { "mni", "manip\u00fcri" },
            { "Latn", metaValue_la },
            { "Latg", "gael lat\u0131n\u0131" },
            { "xh", "xosa" },
            { "byn", "bilinc\u0259" },
            { "Lyci", "lusian" },
            { "osa", "osage" },
            { "Moon", "mun" },
            { "moh", "mohavk" },
            { "Syrc", metaValue_syr },
            { "yi", "Yahudi" },
            { "mos", "mosi" },
            { "Dsrt", "deseret" },
            { "yo", "yoruba" },
            { "es_MX", "Meksika ispancas\u0131" },
            { "ota", "osman" },
            { "Syre", "estrangela s\u00fcryanice" },
            { "vai", "vai" },
            { "za", "ju\u0259nq" },
            { "Cari", "kariyan" },
            { "kln", "kalencin" },
            { "zh", "\u00e7in" },
            { "Bopo", "bopomofo" },
            { "Perm", "q\u0259dimi permik" },
            { "zu", "zulu" },
            { "Geor", metaValue_ka },
            { "kmb", "kimbundu" },
            { "Cham", "\u00e7am" },
            { "gez", "qez" },
            { "Tglg", metaValue_tl },
            { "Egyd", "misir demotik" },
            { "Egyh", "misir hiyeratik" },
            { "ebu", "embu" },
            { "Egyp", "misir hiyeroqlif" },
            { "Geok", "g\u00fcrc\u00fc xutsuri" },
            { "zh_Hans", "sad\u0259l\u0259\u015fmi\u015f \u00e7in" },
            { "koi", "komi-permyak" },
            { "Hung", "q\u0259dimi macar" },
            { "kok", "konkan" },
            { "kos", "kosreyan" },
            { "zh_Hant", "\u0259n\u0259n\u0259vi \u00e7in" },
            { "Sund", "sundan" },
            { "kpe", "kpelle" },
            { "ilo", "iloko" },
            { "Cprt", "kipr" },
            { "mua", "mundanq" },
            { "mul", "dig\u0259r dill\u0259r" },
            { "cad", "kado" },
            { "mus", "krik" },
            { "Glag", "qlaqolitik" },
            { "gil", "qilbert gili" },
            { "Cher", metaValue_chr },
            { "car", "karib" },
            { "krc", "qara\u00e7ay-balkar" },
            { "inh", "inqu\u015f" },
            { "krl", "karelyan" },
            { "efi", "efik" },
            { "kru", "kurux" },
            { "ksb", "\u015fambala" },
            { "Telu", metaValue_te },
            { "ksf", "bafia" },
        };
        return data;
    }
}
