/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ms extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_AL = "Albania";
        final String metaValue_AM = "Armenia";
        final String metaValue_AZ = "Azerbaijan";
        final String metaValue_BG = "Bulgaria";
        final String metaValue_BY = "Belarus";
        final String metaValue_DE = "Jerman";
        final String metaValue_DK = "Denmark";
        final String metaValue_EE = "Estonia";
        final String metaValue_ES = "Sepanyol";
        final String metaValue_ET = "Ethiopia";
        final String metaValue_FI = "Finland";
        final String metaValue_FJ = "Fiji";
        final String metaValue_FR = "Perancis";
        final String metaValue_GE = "Georgia";
        final String metaValue_HR = "Croatia";
        final String metaValue_HT = "Haiti";
        final String metaValue_HU = "Hungary";
        final String metaValue_ID = "Indonesia";
        final String metaValue_IE = "Ireland";
        final String metaValue_IS = "Iceland";
        final String metaValue_IT = "Itali";
        final String metaValue_JP = "Jepun";
        final String metaValue_KZ = "Kazakhstan";
        final String metaValue_LA = "Laos";
        final String metaValue_LT = "Lithuania";
        final String metaValue_LU = "Luxembourg";
        final String metaValue_LV = "Latvia";
        final String metaValue_MK = "Macedonia";
        final String metaValue_MN = "Mongolia";
        final String metaValue_MT = "Malta";
        final String metaValue_NL = "Belanda";
        final String metaValue_NO = "Norway";
        final String metaValue_NP = "Nepal";
        final String metaValue_PH = "Filipina";
        final String metaValue_PL = "Poland";
        final String metaValue_RO = "Romania";
        final String metaValue_RS = "Serbia";
        final String metaValue_RU = "Rusia";
        final String metaValue_SE = "Sweden";
        final String metaValue_SI = "Slovenia";
        final String metaValue_TO = "Tonga";
        final String metaValue_TR = "Turki";
        final String metaValue_UA = "Ukraine";
        final String metaValue_UZ = "Uzbekistan";
        final String metaValue_VN = "Vietnam";
        final String metaValue_WS = "Samoa";
        final String metaValue_ar = "Arab";
        final String metaValue_bo = "Tibet";
        final String metaValue_el = "Greek";
        final String metaValue_he = "Ibrani";
        final String metaValue_km = "Khmer";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Korea";
        final String metaValue_la = "Latin";
        final String metaValue_ml = "Malayalam";
        final String metaValue_or = "Oriya";
        final String metaValue_si = "Sinhala";
        final String metaValue_ta = "Tamil";
        final String metaValue_te = "Telugu";
        final String metaValue_th = "Thai";
        final Object[][] data = new Object[][] {
            { "sbp", "Sangu" },
            { "ksh", "Colognian" },
            { "nyn", "Nyankole" },
            { "luo", "Luo" },
            { "Zsym", "Simbol" },
            { "fil", metaValue_PH },
            { "lus", "Mizo" },
            { "bal", "Baluchi" },
            { "luy", "Luyia" },
            { "bas", "Basaa" },
            { "bax", "Bamun" },
            { "es_ES", "Sepanyol Eropah" },
            { "teo", "Teso" },
            { "ab", "Abkhazia" },
            { "AC", "Pulau Ascension" },
            { "tet", "Tetum" },
            { "AD", "Andorra" },
            { "AE", "Emiriah Arab Bersatu" },
            { "ae", "Avestan" },
            { "nl_BE", "Flemish" },
            { "AF", "Afghanistan" },
            { "af", "Afrikaans" },
            { "AG", "Antigua dan Barbuda" },
            { "glk", "Gilaki" },
            { "AI", "Anguilla" },
            { "ak", "Akan" },
            { "AL", metaValue_AL },
            { "bbj", "Ghomala" },
            { "AM", metaValue_AM },
            { "am", "Amharic" },
            { "Arab", metaValue_ar },
            { "AO", "Angola" },
            { "Jpan", metaValue_JP },
            { "AQ", "Antartika" },
            { "ar", metaValue_ar },
            { "AR", "Argentina" },
            { "AS", "Samoa Amerika" },
            { "as", "Assam" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "av", "Avaric" },
            { "AW", "Aruba" },
            { "sdh", "Kurdish Selatan" },
            { "en_US", "Inggeris AS" },
            { "AX", "Kepulauan Aland" },
            { "ay", "Aymara" },
            { "mye", "Myene" },
            { "az", metaValue_AZ },
            { "AZ", metaValue_AZ },
            { "BA", "Bosnia dan Herzegovina" },
            { "ba", "Bashkir" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "be", metaValue_BY },
            { "BE", "Belgium" },
            { "BF", "Burkina Faso" },
            { "bg", metaValue_BG },
            { "BG", metaValue_BG },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "bm", "Bambara" },
            { "BN", "Brunei" },
            { "bn", "Benggala" },
            { "bo", metaValue_bo },
            { "BO", "Bolivia" },
            { "BQ", "Belanda Caribbean" },
            { "BR", "Brazil" },
            { "br", "Breton" },
            { "BS", "Bahamas" },
            { "bs", "Bosnia" },
            { "xog", "Soga" },
            { "BT", "Bhutan" },
            { "see", "Seneca" },
            { "BV", "Pulau Bouvet" },
            { "BW", "Botswana" },
            { "Mymr", "Myammar" },
            { "BY", metaValue_BY },
            { "seh", "Sena" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "ca", "Catalonia" },
            { "CC", "Kepulauan Cocos (Keeling)" },
            { "mzn", "Mazanderani" },
            { "ses", "Koyraboro Senni" },
            { "CD", "Congo - Kinshasa" },
            { "ce", "Chechen" },
            { "CF", "Republik Afrika Tengah" },
            { "CG", "Congo - Brazzaville" },
            { "CH", "Switzerland" },
            { "CI", "Cote d\u2019Ivoire" },
            { "CK", "Kepulauan Cook" },
            { "CL", "Chile" },
            { "CM", "Cameroon" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "co", "Corsica" },
            { "CP", "Pulau Clipperton" },
            { "Orya", metaValue_or },
            { "CR", "Costa Rica" },
            { "cs", "Czech" },
            { "CU", "Cuba" },
            { "cu", "Slavik Gereja" },
            { "CV", "Cape Verde" },
            { "cv", "Chuvash" },
            { "CW", "Curacao" },
            { "CX", "Pulau Krismas" },
            { "CY", "Cyprus" },
            { "cy", "Wales" },
            { "CZ", "Republik Czech" },
            { "da", metaValue_DK },
            { "pt_PT", "Portugis Eropah" },
            { "de", metaValue_DE },
            { "DE", metaValue_DE },
            { "cgg", "Chiga" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "bej", "Beja" },
            { "DK", metaValue_DK },
            { "ach", "Akoli" },
            { "Brai", "Braille" },
            { "DM", "Dominica" },
            { "DO", "Republik Dominica" },
            { "bem", "Bemba" },
            { "dv", "Divehi" },
            { "es_419", "Sepanyol Amerika Latin" },
            { "DZ", "Algeria" },
            { "dz", "Dzongkha" },
            { "bez", "Bena" },
            { "EA", "Ceuta dan Melilla" },
            { "EC", "Ecuador" },
            { "dje", "Zarma" },
            { "EE", metaValue_EE },
            { "ee", "Ewe" },
            { "bfd", "Bafut" },
            { "EG", "Mesir" },
            { "EH", "Sahara Barat" },
            { "ro_MD", "Moldavia" },
            { "el", metaValue_el },
            { "en", "Inggeris" },
            { "chm", "Mari" },
            { "eo", "Esperanto" },
            { "chr", "Cherokee" },
            { "ER", "Eritrea" },
            { "es", metaValue_ES },
            { "ES", metaValue_ES },
            { "et", metaValue_EE },
            { "ET", metaValue_ET },
            { "EU", "Kesatuan Eropah" },
            { "eu", "Basque" },
            { "Hang", "Hangul" },
            { "shi", "Tachelhit" },
            { "hsb", "Upper Sorbian" },
            { "Hani", "Han" },
            { "ady", "Adyghe" },
            { "fa", "Parsi" },
            { "Hans", "Ringkas" },
            { "Hant", "Tradisional" },
            { "aeb", "Arab Tunisia" },
            { "shu", "Chadian Arab" },
            { "fi", metaValue_FI },
            { "FI", metaValue_FI },
            { "fj", metaValue_FJ },
            { "FJ", metaValue_FJ },
            { "FK", "Kepulauan Falkland" },
            { "FM", "Micronesia" },
            { "bgn", "Balochi Barat" },
            { "FO", "Kepulauan Faroe" },
            { "fo", "Faroe" },
            { "Taml", metaValue_ta },
            { "fr", metaValue_FR },
            { "FR", metaValue_FR },
            { "fy", "Frisian Barat" },
            { "grc", "Greek Purba" },
            { "ga", metaValue_IE },
            { "GA", "Gabon" },
            { "GB", "United Kingdom" },
            { "GD", "Grenada" },
            { "gd", "Scots Gaelic" },
            { "GE", metaValue_GE },
            { "GF", "Guiana Perancis" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Greenland" },
            { "gl", "Galicia" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "gn", "Guarani" },
            { "GP", "Guadeloupe" },
            { "GQ", "Guinea Khatulistiwa" },
            { "und", "Bahasa Tidak Diketahui" },
            { "GR", "Greece" },
            { "GS", "Kepulauan Georgia Selatan & Sandwich Selatan" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "gu", "Gujerat" },
            { "gv", "Manx" },
            { "GW", "Guinea Bissau" },
            { "tlh", "Klingon" },
            { "GY", "Guyana" },
            { "ha", "Hausa" },
            { "ckb", "Kurdi Sorani" },
            { "zxx", "Tiada kandungan linguistik" },
            { "he", metaValue_he },
            { "tly", "Talysh" },
            { "hi", "Hindi" },
            { "de_AT", "Jerman Austria" },
            { "HK", "Hong Kong SAR China" },
            { "HM", "Kepulauan Heard & McDonald" },
            { "HN", "Honduras" },
            { "hr", metaValue_HR },
            { "HR", metaValue_HR },
            { "agq", "Aghem" },
            { "gsw", "Jerman Switzerland" },
            { "ht", metaValue_HT },
            { "HT", metaValue_HT },
            { "hu", metaValue_HU },
            { "HU", metaValue_HU },
            { "hy", metaValue_AM },
            { "ia", "Interlingua" },
            { "IC", "Kepulauan Canary" },
            { "id", metaValue_ID },
            { "ID", metaValue_ID },
            { "IE", metaValue_IE },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "naq", "Nama" },
            { "ii", "Sichuan Yi" },
            { "zza", "Zaza" },
            { "IL", "Israel" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "IO", "Wilayah Lautan Hindi British" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "is", metaValue_IS },
            { "IS", metaValue_IS },
            { "it", metaValue_IT },
            { "IT", metaValue_IT },
            { "iu", "Inuktitut" },
            { "ja", metaValue_JP },
            { "Mlym", metaValue_ml },
            { "JE", "Jersey" },
            { "doi", "Dogri" },
            { "JM", "Jamaica" },
            { "Beng", "Bengali" },
            { "JO", "Jordan" },
            { "bkm", "Kom" },
            { "JP", metaValue_JP },
            { "sma", "Sami Selatan" },
            { "jv", "Jawa" },
            { "guz", "Gusii" },
            { "smj", "Lule Sami" },
            { "maf", "Mafa" },
            { "de_CH", "Jerman Halus Switzerland" },
            { "smn", "Inari Sami" },
            { "ka", metaValue_GE },
            { "sms", "Skolt Sami" },
            { "KE", "Kenya" },
            { "419", "Amerika Latin" },
            { "KG", "Kyrgyzstan" },
            { "kg", "Kongo" },
            { "KH", "Kemboja" },
            { "KI", "Kiribati" },
            { "ki", "Kikuya" },
            { "mas", "Masai" },
            { "kk", metaValue_KZ },
            { "kl", "Kalaallisut" },
            { "km", metaValue_km },
            { "KM", "Comoros" },
            { "Knda", metaValue_kn },
            { "kn", metaValue_kn },
            { "KN", "Saint Kitts dan Nevis" },
            { "fr_CA", "Perancis Kanada" },
            { "ko", metaValue_ko },
            { "KP", "Korea Utara" },
            { "KR", "Korea Selatan" },
            { "ks", "Kashmir" },
            { "ku", "Kurdish" },
            { "fr_CH", "Perancis Switzerland" },
            { "KW", "Kuwait" },
            { "kw", "Cornish" },
            { "tpi", "Tok Pisin" },
            { "KY", "Kepulauan Cayman" },
            { "ky", "Kirghiz" },
            { "KZ", metaValue_KZ },
            { "Cyrl", "Cyril" },
            { "LA", metaValue_LA },
            { "la", metaValue_la },
            { "lb", metaValue_LU },
            { "LB", "Lubnan" },
            { "LC", "Saint Lucia" },
            { "lg", "Ganda" },
            { "nds", "Jerman Rendah" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "Tibt", metaValue_bo },
            { "ln", "Lingala" },
            { "lo", metaValue_LA },
            { "cop", "Coptic" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "lt", metaValue_LT },
            { "LT", metaValue_LT },
            { "LU", metaValue_LU },
            { "lu", "Luba-Katanga" },
            { "lv", metaValue_LV },
            { "LV", metaValue_LV },
            { "Kana", "Katakana" },
            { "LY", "Libya" },
            { "vun", "Vunjo" },
            { "lah", "Lahnda" },
            { "lag", "Langi" },
            { "Thaa", "Thaana" },
            { "MA", "Maghribi" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "MG", "Madagaskar" },
            { "mg", "Malagasy" },
            { "Thai", metaValue_th },
            { "MH", "Kepulauan Marshall" },
            { "mi", "Maori" },
            { "mk", metaValue_MK },
            { "MK", metaValue_MK },
            { "ml", metaValue_ml },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "mn", metaValue_MN },
            { "MN", metaValue_MN },
            { "MO", "Macau SAR China" },
            { "MP", "Kepulauan Mariana Utara" },
            { "MQ", "Martinique" },
            { "MR", "Mauritania" },
            { "mr", "Marathi" },
            { "MS", "Montserrat" },
            { "ms", "Bahasa Melayu" },
            { "mt", metaValue_MT },
            { "MT", metaValue_MT },
            { "MU", "Mauritius" },
            { "alt", "Altai Selatan" },
            { "MV", "Maldives" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "MY", "Malaysia" },
            { "my", "Burma" },
            { "Armn", metaValue_AM },
            { "MZ", "Mozambique" },
            { "mde", "Maba" },
            { "dsb", "Lower Sorbian" },
            { "NA", "Namibia" },
            { "nb", "Bokm\u00e5l Norway" },
            { "NC", "New Caledonia" },
            { "nd", "Ndebele Utara" },
            { "ne", metaValue_NP },
            { "NE", "Niger" },
            { "NF", "Pulau Norfolk" },
            { "NG", "Nigeria" },
            { "trv", "Taroko" },
            { "NI", "Nicaragua" },
            { "nl", metaValue_NL },
            { "NL", metaValue_NL },
            { "nn", "Nynorsk Norway" },
            { "no", metaValue_NO },
            { "NO", metaValue_NO },
            { "NP", metaValue_NP },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "rof", "Rombo" },
            { "ny", "Nyanja" },
            { "NZ", "New Zealand" },
            { "kab", "Kabyle" },
            { "oc", "Occitania" },
            { "kam", "Kamba" },
            { "crh", "Turki Krimea" },
            { "mer", "Meru" },
            { "OM", "Oman" },
            { "om", "Oromo" },
            { "or", metaValue_or },
            { "os", "Ossete" },
            { "bpy", "Bishnupriya" },
            { "mfe", "Morisyen" },
            { "PA", "Panama" },
            { "pa", "Punjabi" },
            { "dua", "Duala" },
            { "en_GB", "Inggeris British" },
            { "kbl", "Kanembu" },
            { "PE", "Peru" },
            { "PF", "Polinesia Perancis" },
            { "PG", "Papua New Guinea" },
            { "PH", metaValue_PH },
            { "PK", "Pakistan" },
            { "pl", metaValue_PL },
            { "PL", metaValue_PL },
            { "ewo", "Ewondo" },
            { "PM", "Saint Pierre dan Miquelon" },
            { "PN", "Kepulauan Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Wilayah Palestin" },
            { "ps", "Pashto" },
            { "Bali", "Bali" },
            { "PT", "Portugal" },
            { "pt", "Portugis" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "pt_BR", "Portugis Brazil" },
            { "tum", "Tumbuka" },
            { "Hebr", metaValue_he },
            { "mgh", "Makhuwa-Meetto" },
            { "QA", "Qatar" },
            { "Laoo", "Lao" },
            { "mgo", "Meta\u2019" },
            { "ssy", "Saho" },
            { "brh", "Brahui" },
            { "QO", "Oceania Terpencil" },
            { "qu", "Quechua" },
            { "brx", "Bodo" },
            { "kde", "Makonde" },
            { "Ethi", metaValue_ET },
            { "001", "Dunia" },
            { "002", "Afrika" },
            { "003", "Amerika Utara" },
            { "RE", "Reunion" },
            { "005", "Amerika Selatan" },
            { "009", "Oceania" },
            { "rm", "Romansh" },
            { "rn", "Rundi" },
            { "ro", metaValue_RO },
            { "RO", metaValue_RO },
            { "RS", metaValue_RS },
            { "ru", metaValue_RU },
            { "RU", metaValue_RU },
            { "bss", "Akoose" },
            { "RW", "Rwanda" },
            { "rw", "Kinyarwanda" },
            { "kea", "Kabuverdianu" },
            { "en_AU", "Inggeris Australia" },
            { "SA", "Arab Saudi" },
            { "sa", "Sanskrit" },
            { "SB", "Kepulauan Solomon" },
            { "twq", "Tasawaq" },
            { "011", "Afrika Barat" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "sd", "Sindhi" },
            { "SE", metaValue_SE },
            { "013", "Amerika Tengah" },
            { "se", "Sami Utara" },
            { "014", "Afrika Timur" },
            { "015", "Afrika Utara" },
            { "SG", "Singapura" },
            { "sg", "Sango" },
            { "SH", "Saint Helena" },
            { "sh", "SerboCroatia" },
            { "SI", metaValue_SI },
            { "si", metaValue_si },
            { "017", "Afrika Tengah" },
            { "018", "Selatan Afrika" },
            { "SJ", "Svalbard dan Jan Mayen" },
            { "019", "Amerika" },
            { "SK", "Slovakia" },
            { "sk", "Slovak" },
            { "Bamu", "Bamu" },
            { "sl", metaValue_SI },
            { "SL", "Sierra Leone" },
            { "sm", metaValue_WS },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "sn", "Shona" },
            { "SO", "Somalia" },
            { "so", "Somali" },
            { "arn", "Mapuche" },
            { "sq", metaValue_AL },
            { "sr", metaValue_RS },
            { "SR", "Surinam" },
            { "SS", "Sudan Selatan" },
            { "ss", "Swati" },
            { "ST", "Sao Tome dan Principe" },
            { "st", "Sotho Selatan" },
            { "arq", "Arab Algeria" },
            { "su", "Sunda" },
            { "sv", metaValue_SE },
            { "SV", "El Salvador" },
            { "sw", "Swahili" },
            { "SX", "Sint Maarten" },
            { "SY", "Syria" },
            { "SZ", "Swaziland" },
            { "arz", "Arab Mesir" },
            { "ibb", "Ibibio" },
            { "ary", "Arab Maghribi" },
            { "ta", metaValue_ta },
            { "TA", "Tristan da Cunha" },
            { "asa", "Asu" },
            { "021", "Utara Amerika" },
            { "142", "Asia" },
            { "TC", "Kepulauan Turks dan Caicos" },
            { "bua", "Buriat" },
            { "yav", "Yangben" },
            { "143", "Asia Tengah" },
            { "TD", "Chad" },
            { "te", metaValue_te },
            { "145", "Asia Barat" },
            { "TF", "Wilayah Selatan Perancis" },
            { "TG", "Togo" },
            { "tg", "Tajik" },
            { "th", metaValue_th },
            { "TH", "Thailand" },
            { "ti", "Tigrinya" },
            { "TJ", "Tajikistan" },
            { "en_CA", "Inggeris Kanada" },
            { "029", "Caribbean" },
            { "TK", "Tokelau" },
            { "tk", "Turkmen" },
            { "TL", "Timor-Leste" },
            { "ybb", "Yemba" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "tn", "Tswana" },
            { "to", metaValue_TO },
            { "TO", metaValue_TO },
            { "bum", "Bulu" },
            { "dyo", "Jola-Fonyi" },
            { "tr", metaValue_TR },
            { "TR", metaValue_TR },
            { "ts", "Tsonga" },
            { "swb", "Comoria" },
            { "TT", "Trinidad dan Tobago" },
            { "tt", "Tatar" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "tw", "Twi" },
            { "ty", "Tahiti" },
            { "TZ", "Tanzania" },
            { "nmg", "Kwasio" },
            { "Zzzz", "Skrip Tidak Diketahui" },
            { "UA", metaValue_UA },
            { "150", "Eropah" },
            { "030", "Asia Timur" },
            { "151", "Eropah Timur" },
            { "154", "Eropah Utara" },
            { "dzg", "Dazaga" },
            { "sw_CD", "Congo Swahili" },
            { "034", "Asia Selatan" },
            { "155", "Eropah Barat" },
            { "035", "Asia Tenggara" },
            { "UG", "Uganda" },
            { "ug", "Uyghur" },
            { "Kore", metaValue_ko },
            { "Zyyy", "Biasa" },
            { "uk", metaValue_UA },
            { "039", "Eropah Selatan" },
            { "Sinh", metaValue_si },
            { "UM", "Kepulauan Terpencil A.S." },
            { "ur", "Urdu" },
            { "US", "Amerika Syarikat" },
            { "haw", "Hawaii" },
            { "UY", "Uruguay" },
            { "uz", metaValue_UZ },
            { "UZ", metaValue_UZ },
            { "tzm", "Tamazight Atlas Tengah" },
            { "nnh", "Ngiemboon" },
            { "VA", "Kota Vatican" },
            { "nds_NL", "Saxon Rendah" },
            { "VC", "Saint Vincent dan Grenadines" },
            { "VE", "Venezuela" },
            { "ve", "Venda" },
            { "VG", "Kepulauan Virgin British" },
            { "vi", metaValue_VN },
            { "VI", "Kepulauan Virgin A.S." },
            { "khq", "Koyra Chiini" },
            { "VN", metaValue_VN },
            { "khw", "Khowar" },
            { "quc", "K\u02bciche\u02bc" },
            { "VU", "Vanuatu" },
            { "gaa", "Ga" },
            { "rwk", "Rwa" },
            { "gag", "Gagauz" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "WF", "Wallis dan Futuna" },
            { "Grek", metaValue_el },
            { "057", "Wilayah Mikronesia" },
            { "jgo", "Ngomba" },
            { "lkt", "Lakota" },
            { "wo", "Wolof" },
            { "wae", "Walser" },
            { "zgh", "Tamazight Maghribi Standard" },
            { "ar_001", "Arab Standard Moden" },
            { "WS", metaValue_WS },
            { "Cans", "Cans" },
            { "Mong", metaValue_MN },
            { "gba", "Gbaya" },
            { "mni", "Manipuri" },
            { "Latn", metaValue_la },
            { "061", "Polinesia" },
            { "xh", "Xhosa" },
            { "XK", "Kosovo" },
            { "Gujr", "Gujarat" },
            { "Zxxx", "Tidak ditulis" },
            { "byv", "Medumba" },
            { "gbz", "Zoroastrian Dari" },
            { "wbp", "Warlpiri" },
            { "moh", "Mohawk" },
            { "kkj", "Kako" },
            { "YE", "Yaman" },
            { "nqo", "N\u2019ko" },
            { "yi", "Yiddish" },
            { "yo", "Yoruba" },
            { "es_MX", "Sepanyol Mexico" },
            { "YT", "Mayotte" },
            { "vai", "Vai" },
            { "ZA", "Afrika Selatan" },
            { "kln", "Kalenjin" },
            { "Deva", "Devanagari" },
            { "zh", "Cina" },
            { "Hira", "Hiragana" },
            { "ZM", "Zambia" },
            { "Bopo", "Bopomofo" },
            { "zu", "Zulu" },
            { "ZW", "Zimbabwe" },
            { "Geor", metaValue_GE },
            { "ZZ", "Wilayah Tidak Diketahui" },
            { "nso", "Sotho Utara" },
            { "loz", "Lozi" },
            { "ebu", "Embu" },
            { "jmc", "Machame" },
            { "zh_Hans", "Cina Ringkas" },
            { "koi", "Komi-Permyak" },
            { "kok", "Konkani" },
            { "nus", "Nuer" },
            { "dav", "Taita" },
            { "lrc", "Luri Utara" },
            { "zh_Hant", "Cina Tradisional" },
            { "mua", "Mundang" },
            { "Khmr", metaValue_km },
            { "cay", "Cayuga" },
            { "saq", "Samburu" },
            { "efi", "Efik" },
            { "sba", "Ngambay" },
            { "Guru", "Gurmukhi" },
            { "lua", "Luba-Lulua" },
            { "ksb", "Shambala" },
            { "Telu", metaValue_te },
            { "ksf", "Bafia" },
        };
        return data;
    }
}
