/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import jdepend.framework.JavaClass;

public class JavaPackage {
    private String name;
    private int volatility;
    private HashSet classes;
    private List afferents;
    private List efferents;

    public JavaPackage(String name) {
        this(name, 1);
    }

    public JavaPackage(String name, int volatility) {
        this.name = name;
        this.setVolatility(volatility);
        this.classes = new HashSet();
        this.afferents = new ArrayList();
        this.efferents = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public int getVolatility() {
        return this.volatility;
    }

    public void setVolatility(int v) {
        this.volatility = v;
    }

    public boolean containsCycle() {
        return this.collectCycle(new ArrayList());
    }

    public boolean collectCycle(List list) {
        if (list.contains(this)) {
            list.add(this);
            return true;
        }
        list.add(this);
        for (JavaPackage efferent : this.getEfferents()) {
            if (!efferent.collectCycle(list)) continue;
            return true;
        }
        list.remove(this);
        return false;
    }

    public boolean collectAllCycles(List list) {
        if (list.contains(this)) {
            list.add(this);
            return true;
        }
        list.add(this);
        boolean containsCycle = false;
        for (JavaPackage efferent : this.getEfferents()) {
            if (!efferent.collectAllCycles(list)) continue;
            containsCycle = true;
        }
        if (containsCycle) {
            return true;
        }
        list.remove(this);
        return false;
    }

    public void addClass(JavaClass clazz) {
        this.classes.add(clazz);
    }

    public Collection getClasses() {
        return this.classes;
    }

    public int getClassCount() {
        return this.classes.size();
    }

    public int getAbstractClassCount() {
        int count = 0;
        for (JavaClass clazz : this.classes) {
            if (!clazz.isAbstract()) continue;
            ++count;
        }
        return count;
    }

    public int getConcreteClassCount() {
        int count = 0;
        for (JavaClass clazz : this.classes) {
            if (clazz.isAbstract()) continue;
            ++count;
        }
        return count;
    }

    public void dependsUpon(JavaPackage imported) {
        this.addEfferent(imported);
        imported.addAfferent(this);
    }

    public void addAfferent(JavaPackage jPackage) {
        if (!jPackage.getName().equals(this.getName()) && !this.afferents.contains(jPackage)) {
            this.afferents.add(jPackage);
        }
    }

    public Collection getAfferents() {
        return this.afferents;
    }

    public void setAfferents(Collection afferents) {
        this.afferents = new ArrayList(afferents);
    }

    public void addEfferent(JavaPackage jPackage) {
        if (!jPackage.getName().equals(this.getName()) && !this.efferents.contains(jPackage)) {
            this.efferents.add(jPackage);
        }
    }

    public Collection getEfferents() {
        return this.efferents;
    }

    public void setEfferents(Collection efferents) {
        this.efferents = new ArrayList(efferents);
    }

    public int afferentCoupling() {
        return this.afferents.size();
    }

    public int efferentCoupling() {
        return this.efferents.size();
    }

    public float instability() {
        float totalCoupling = (float)this.efferentCoupling() + (float)this.afferentCoupling();
        if (totalCoupling > 0.0f) {
            return (float)this.efferentCoupling() / totalCoupling;
        }
        return 0.0f;
    }

    public float abstractness() {
        if (this.getClassCount() > 0) {
            return (float)this.getAbstractClassCount() / (float)this.getClassCount();
        }
        return 0.0f;
    }

    public float distance() {
        float d = Math.abs(this.abstractness() + this.instability() - 1.0f);
        return d * (float)this.volatility;
    }

    public boolean equals(Object other) {
        if (other instanceof JavaPackage) {
            JavaPackage otherPackage = (JavaPackage)other;
            return otherPackage.getName().equals(this.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

