/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.client.shared;

import java.net.URI;
import java.net.URISyntaxException;

public final class UriUtils {
    private UriUtils() {
    }

    public static URI parseURI(String connectionString, URI defaultURI) {
        URI uri = UriUtils.parseWithNoScheme(connectionString);
        String path = "".equals(uri.getPath()) ? defaultURI.getPath() : uri.getPath();
        String query = uri.getQuery() == null ? defaultURI.getQuery() : uri.getQuery();
        int port = uri.getPort() < 0 ? defaultURI.getPort() : uri.getPort();
        try {
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), port, path, query, defaultURI.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid connection configuration [" + connectionString + "]: " + e.getMessage(), e);
        }
    }

    private static URI parseWithNoScheme(String connectionString) {
        URI uri;
        URISyntaxException firstException = null;
        try {
            uri = new URI(connectionString);
            if (uri.getHost() == null || uri.getScheme() == null) {
                uri = null;
            }
        }
        catch (URISyntaxException e) {
            firstException = e;
            uri = null;
        }
        if (uri == null) {
            try {
                return new URI("http://" + connectionString);
            }
            catch (URISyntaxException e) {
                IllegalArgumentException ie = new IllegalArgumentException("Invalid connection configuration [" + connectionString + "]: " + e.getMessage(), e);
                if (firstException != null) {
                    ie.addSuppressed(firstException);
                }
                throw ie;
            }
        }
        if (!"http".equals(uri.getScheme()) && !"https".equals(uri.getScheme())) {
            throw new IllegalArgumentException("Invalid connection configuration [" + connectionString + "]: Only http and https protocols are supported");
        }
        return uri;
    }

    public static URI removeQuery(URI uri, String connectionString, URI defaultURI) {
        try {
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), null, defaultURI.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid connection configuration [" + connectionString + "]: " + e.getMessage(), e);
        }
    }
}

