/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor.scroll;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.ClearScrollAction;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xpack.core.ml.MlClientHelper;
import org.elasticsearch.xpack.core.ml.datafeed.extractor.DataExtractor;
import org.elasticsearch.xpack.core.ml.datafeed.extractor.ExtractorUtils;
import org.elasticsearch.xpack.ml.datafeed.extractor.scroll.ScrollDataExtractorContext;
import org.elasticsearch.xpack.ml.datafeed.extractor.scroll.SearchHitToJsonProcessor;
import org.elasticsearch.xpack.ml.utils.DomainSplitFunction;

class ScrollDataExtractor
implements DataExtractor {
    private static final Logger LOGGER = Loggers.getLogger(ScrollDataExtractor.class);
    private static final TimeValue SCROLL_TIMEOUT = new TimeValue(30L, TimeUnit.MINUTES);
    private final Client client;
    private final ScrollDataExtractorContext context;
    private String scrollId;
    private boolean isCancelled;
    private boolean hasNext;
    private Long timestampOnCancel;
    protected Long lastTimestamp;
    private boolean searchHasShardFailure;

    ScrollDataExtractor(Client client, ScrollDataExtractorContext dataExtractorContext) {
        this.client = Objects.requireNonNull(client);
        this.context = Objects.requireNonNull(dataExtractorContext);
        this.hasNext = true;
        this.searchHasShardFailure = false;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void cancel() {
        LOGGER.trace("[{}] Data extractor received cancel request", (Object)this.context.jobId);
        this.isCancelled = true;
    }

    public Optional<InputStream> next() throws IOException {
        Optional<InputStream> stream;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Optional<InputStream> optional = stream = this.scrollId == null ? Optional.ofNullable(this.initScroll(this.context.start)) : Optional.ofNullable(this.continueScroll());
        if (!stream.isPresent()) {
            this.hasNext = false;
        }
        return stream;
    }

    protected InputStream initScroll(long startTimestamp) throws IOException {
        LOGGER.debug("[{}] Initializing scroll", (Object)this.context.jobId);
        SearchResponse searchResponse = this.executeSearchRequest(this.buildSearchRequest(startTimestamp));
        LOGGER.debug("[{}] Search response was obtained", (Object)this.context.jobId);
        return this.processSearchResponse(searchResponse);
    }

    protected SearchResponse executeSearchRequest(SearchRequestBuilder searchRequestBuilder) {
        return (SearchResponse)MlClientHelper.execute(this.context.headers, (Client)this.client, () -> ((SearchRequestBuilder)searchRequestBuilder).get());
    }

    private SearchRequestBuilder buildSearchRequest(long start) {
        SearchRequestBuilder searchRequestBuilder = SearchAction.INSTANCE.newRequestBuilder((ElasticsearchClient)this.client).setScroll(SCROLL_TIMEOUT).addSort(this.context.extractedFields.timeField(), SortOrder.ASC).setIndices(this.context.indices).setTypes(this.context.types).setSize(this.context.scrollSize).setQuery(ExtractorUtils.wrapInTimeRangeQuery((QueryBuilder)this.context.query, (String)this.context.extractedFields.timeField(), (long)start, (long)this.context.end));
        for (String docValueField : this.context.extractedFields.getDocValueFields()) {
            searchRequestBuilder.addDocValueField(docValueField);
        }
        String[] sourceFields = this.context.extractedFields.getSourceFields();
        if (sourceFields.length == 0) {
            searchRequestBuilder.setFetchSource(false);
            searchRequestBuilder.storedFields(new String[]{"_none_"});
        } else {
            searchRequestBuilder.setFetchSource(sourceFields, null);
        }
        this.context.scriptFields.forEach(f -> searchRequestBuilder.addScriptField(f.fieldName(), this.injectDomainSplit(f.script())));
        return searchRequestBuilder;
    }

    private Script injectDomainSplit(Script script) {
        String code = script.getIdOrCode();
        if (code.contains("domainSplit(") && script.getLang().equals("painless")) {
            String modifiedCode = DomainSplitFunction.function + code;
            HashMap<String, Object> modifiedParams = new HashMap<String, Object>(script.getParams().size() + DomainSplitFunction.params.size());
            modifiedParams.putAll(script.getParams());
            modifiedParams.putAll(DomainSplitFunction.params);
            return new Script(script.getType(), script.getLang(), modifiedCode, modifiedParams);
        }
        return script;
    }

    private InputStream processSearchResponse(SearchResponse searchResponse) throws IOException {
        if (searchResponse.getFailedShards() > 0 && !this.searchHasShardFailure) {
            LOGGER.debug("[{}] Resetting scroll search after shard failure", (Object)this.context.jobId);
            this.markScrollAsErrored();
            return this.initScroll(this.lastTimestamp == null ? this.context.start : this.lastTimestamp);
        }
        ExtractorUtils.checkSearchWasSuccessful((String)this.context.jobId, (SearchResponse)searchResponse);
        this.scrollId = searchResponse.getScrollId();
        if (searchResponse.getHits().getHits().length == 0) {
            this.hasNext = false;
            this.clearScroll(this.scrollId);
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (SearchHitToJsonProcessor hitProcessor = new SearchHitToJsonProcessor(this.context.extractedFields, outputStream);){
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                Long timestamp;
                if (this.isCancelled && (timestamp = this.context.extractedFields.timeFieldValue(hit)) != null) {
                    if (this.timestampOnCancel == null) {
                        this.timestampOnCancel = timestamp;
                    } else if (!timestamp.equals(this.timestampOnCancel)) {
                        this.hasNext = false;
                        this.clearScroll(this.scrollId);
                        break;
                    }
                }
                hitProcessor.process(hit);
            }
            SearchHit lastHit = searchResponse.getHits().getHits()[searchResponse.getHits().getHits().length - 1];
            this.lastTimestamp = this.context.extractedFields.timeFieldValue(lastHit);
        }
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    private InputStream continueScroll() throws IOException {
        SearchResponse searchResponse;
        LOGGER.debug("[{}] Continuing scroll with id [{}]", (Object)this.context.jobId, (Object)this.scrollId);
        try {
            searchResponse = this.executeSearchScrollRequest(this.scrollId);
        }
        catch (SearchPhaseExecutionException searchExecutionException) {
            if (!this.searchHasShardFailure) {
                LOGGER.debug("[{}] Reinitializing scroll due to SearchPhaseExecutionException", (Object)this.context.jobId);
                this.markScrollAsErrored();
                searchResponse = this.executeSearchRequest(this.buildSearchRequest(this.lastTimestamp == null ? this.context.start : this.lastTimestamp));
            }
            throw searchExecutionException;
        }
        LOGGER.debug("[{}] Search response was obtained", (Object)this.context.jobId);
        return this.processSearchResponse(searchResponse);
    }

    private void markScrollAsErrored() {
        this.resetScroll();
        if (this.lastTimestamp != null) {
            Long l = this.lastTimestamp;
            Long l2 = this.lastTimestamp = Long.valueOf(this.lastTimestamp + 1L);
        }
        this.searchHasShardFailure = true;
    }

    protected SearchResponse executeSearchScrollRequest(String scrollId) {
        return (SearchResponse)MlClientHelper.execute(this.context.headers, (Client)this.client, () -> (SearchResponse)SearchScrollAction.INSTANCE.newRequestBuilder((ElasticsearchClient)this.client).setScroll(SCROLL_TIMEOUT).setScrollId(scrollId).get());
    }

    private void resetScroll() {
        this.clearScroll(this.scrollId);
        this.scrollId = null;
    }

    private void clearScroll(String scrollId) {
        if (scrollId != null) {
            ClearScrollRequest request = new ClearScrollRequest();
            request.addScrollId(scrollId);
            MlClientHelper.execute(this.context.headers, (Client)this.client, () -> (ClearScrollResponse)this.client.execute((Action)ClearScrollAction.INSTANCE, (ActionRequest)request).actionGet());
        }
    }
}

