/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase.highlight;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.SourceFieldMapper;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.fetch.subphase.highlight.Highlighter;
import org.elasticsearch.search.fetch.subphase.highlight.HighlighterContext;
import org.elasticsearch.search.fetch.subphase.highlight.SearchContextHighlight;
import org.elasticsearch.search.internal.SearchContext;

public class HighlightPhase
extends AbstractComponent
implements FetchSubPhase {
    private final Map<String, Highlighter> highlighters;

    public HighlightPhase(Settings settings, Map<String, Highlighter> highlighters) {
        super(settings);
        this.highlighters = highlighters;
    }

    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) {
        if (context.highlight() == null) {
            return;
        }
        HashMap<String, HighlightField> highlightFields = new HashMap<String, HighlightField>();
        for (SearchContextHighlight.Field field : context.highlight().fields()) {
            SourceFieldMapper sourceFieldMapper;
            Collection<String> fieldNamesToHighlight;
            if (Regex.isSimpleMatchPattern(field.field())) {
                DocumentMapper documentMapper = context.mapperService().documentMapper(hitContext.hit().getType());
                fieldNamesToHighlight = documentMapper.mappers().simpleMatchToFullName(field.field());
            } else {
                fieldNamesToHighlight = Collections.singletonList(field.field());
            }
            if (context.highlight().forceSource(field) && !(sourceFieldMapper = context.mapperService().documentMapper(hitContext.hit().getType()).sourceMapper()).enabled()) {
                throw new IllegalArgumentException("source is forced for fields " + fieldNamesToHighlight + " but type [" + hitContext.hit().getType() + "] has disabled _source");
            }
            boolean fieldNameContainsWildcards = field.field().contains("*");
            for (String fieldName : fieldNamesToHighlight) {
                HighlightField highlightField;
                Highlighter highlighter;
                FieldMapper fieldMapper = this.getMapperForField(fieldName, context, hitContext);
                if (fieldMapper == null || fieldNameContainsWildcards && !fieldMapper.fieldType().typeName().equals("text") && !fieldMapper.fieldType().typeName().equals("keyword")) continue;
                String highlighterType = field.fieldOptions().highlighterType();
                if (highlighterType == null) {
                    highlighterType = "unified";
                }
                if ((highlighter = this.highlighters.get(highlighterType)) == null) {
                    throw new IllegalArgumentException("unknown highlighter type [" + highlighterType + "] for the field [" + fieldName + "]");
                }
                Query highlightQuery = field.fieldOptions().highlightQuery();
                if (highlightQuery == null) {
                    highlightQuery = context.parsedQuery().query();
                }
                HighlighterContext highlighterContext = new HighlighterContext(fieldName, field, fieldMapper, context, hitContext, highlightQuery);
                if (!highlighter.canHighlight(fieldMapper) && fieldNameContainsWildcards || (highlightField = highlighter.highlight(highlighterContext)) == null) continue;
                highlightFields.put(highlightField.name(), highlightField);
            }
        }
        hitContext.hit().highlightFields(highlightFields);
    }

    private FieldMapper getMapperForField(String fieldName, SearchContext searchContext, FetchSubPhase.HitContext hitContext) {
        DocumentMapper documentMapper = searchContext.mapperService().documentMapper(hitContext.hit().getType());
        return documentMapper.mappers().smartNameFieldMapper(fieldName);
    }
}

