/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.rankeval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.index.rankeval.EvaluationMetric;
import org.elasticsearch.index.rankeval.MetricDetail;
import org.elasticsearch.index.rankeval.RatedDocument;
import org.elasticsearch.index.rankeval.RatedSearchHit;

public class EvalQueryQuality
implements ToXContentFragment,
Writeable {
    private final String queryId;
    private final double evaluationResult;
    private MetricDetail optionalMetricDetails;
    private final List<RatedSearchHit> ratedHits;
    private static final ParseField QUALITY_LEVEL_FIELD = new ParseField("quality_level", new String[0]);
    private static final ParseField UNKNOWN_DOCS_FIELD = new ParseField("unknown_docs", new String[0]);
    private static final ParseField HITS_FIELD = new ParseField("hits", new String[0]);
    private static final ParseField METRIC_DETAILS_FIELD = new ParseField("metric_details", new String[0]);
    private static final ObjectParser<ParsedEvalQueryQuality, Void> PARSER = new ObjectParser("eval_query_quality", true, () -> new ParsedEvalQueryQuality());

    public EvalQueryQuality(String id, double evaluationResult) {
        this.queryId = id;
        this.evaluationResult = evaluationResult;
        this.ratedHits = new ArrayList<RatedSearchHit>();
    }

    public EvalQueryQuality(StreamInput in) throws IOException {
        this.queryId = in.readString();
        this.evaluationResult = in.readDouble();
        this.ratedHits = in.readList(RatedSearchHit::new);
        this.optionalMetricDetails = (MetricDetail)in.readOptionalNamedWriteable(MetricDetail.class);
    }

    private EvalQueryQuality(String queryId, ParsedEvalQueryQuality builder) {
        this.queryId = queryId;
        this.evaluationResult = builder.evaluationResult;
        this.optionalMetricDetails = builder.optionalMetricDetails;
        this.ratedHits = builder.ratedHits;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.queryId);
        out.writeDouble(this.evaluationResult);
        out.writeList(this.ratedHits);
        out.writeOptionalNamedWriteable((NamedWriteable)this.optionalMetricDetails);
    }

    public String getId() {
        return this.queryId;
    }

    public double getQualityLevel() {
        return this.evaluationResult;
    }

    public void setMetricDetails(MetricDetail breakdown) {
        this.optionalMetricDetails = breakdown;
    }

    public MetricDetail getMetricDetails() {
        return this.optionalMetricDetails;
    }

    public void addHitsAndRatings(List<RatedSearchHit> hits) {
        this.ratedHits.addAll(hits);
    }

    public List<RatedSearchHit> getHitsAndRatings() {
        return this.ratedHits;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.queryId);
        builder.field(QUALITY_LEVEL_FIELD.getPreferredName(), this.evaluationResult);
        builder.startArray(UNKNOWN_DOCS_FIELD.getPreferredName());
        for (RatedDocument.DocumentKey key : EvaluationMetric.filterUnknownDocuments(this.ratedHits)) {
            builder.startObject();
            builder.field(RatedDocument.INDEX_FIELD.getPreferredName(), key.getIndex());
            builder.field(RatedDocument.DOC_ID_FIELD.getPreferredName(), key.getDocId());
            builder.endObject();
        }
        builder.endArray();
        builder.startArray(HITS_FIELD.getPreferredName());
        for (RatedSearchHit hit : this.ratedHits) {
            hit.toXContent(builder, params);
        }
        builder.endArray();
        if (this.optionalMetricDetails != null) {
            builder.field(METRIC_DETAILS_FIELD.getPreferredName(), (ToXContent)this.optionalMetricDetails);
        }
        builder.endObject();
        return builder;
    }

    private static MetricDetail parseMetricDetail(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), () -> ((XContentParser)parser).getTokenLocation());
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)parser.nextToken(), () -> ((XContentParser)parser).getTokenLocation());
        MetricDetail metricDetail = (MetricDetail)parser.namedObject(MetricDetail.class, parser.currentName(), null);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)parser.nextToken(), () -> ((XContentParser)parser).getTokenLocation());
        return metricDetail;
    }

    public static EvalQueryQuality fromXContent(XContentParser parser, String queryId) throws IOException {
        return new EvalQueryQuality(queryId, (ParsedEvalQueryQuality)PARSER.apply(parser, null));
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EvalQueryQuality other = (EvalQueryQuality)obj;
        return Objects.equals(this.queryId, other.queryId) && Objects.equals(this.evaluationResult, other.evaluationResult) && Objects.equals(this.ratedHits, other.ratedHits) && Objects.equals(this.optionalMetricDetails, other.optionalMetricDetails);
    }

    public final int hashCode() {
        return Objects.hash(this.queryId, this.evaluationResult, this.ratedHits, this.optionalMetricDetails);
    }

    static {
        PARSER.declareDouble((obj, value) -> {
            obj.evaluationResult = value;
        }, QUALITY_LEVEL_FIELD);
        PARSER.declareObject((obj, value) -> {
            obj.optionalMetricDetails = value;
        }, (p, c) -> EvalQueryQuality.parseMetricDetail(p), METRIC_DETAILS_FIELD);
        PARSER.declareObjectArray((obj, list) -> {
            obj.ratedHits = list;
        }, (p, c) -> RatedSearchHit.parse(p), HITS_FIELD);
    }

    private static class ParsedEvalQueryQuality {
        double evaluationResult;
        MetricDetail optionalMetricDetails;
        List<RatedSearchHit> ratedHits = new ArrayList<RatedSearchHit>();

        private ParsedEvalQueryQuality() {
        }
    }
}

