/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plugin;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.function.Supplier;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.sql.plugin.AbstractSqlRequest;
import org.elasticsearch.xpack.sql.plugin.SqlTypedParamValue;

public abstract class AbstractSqlQueryRequest
extends AbstractSqlRequest
implements CompositeIndicesRequest,
ToXContentFragment {
    public static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getTimeZone("UTC");
    public static final int DEFAULT_FETCH_SIZE = 1000;
    public static final TimeValue DEFAULT_REQUEST_TIMEOUT = TimeValue.timeValueSeconds((long)90L);
    public static final TimeValue DEFAULT_PAGE_TIMEOUT = TimeValue.timeValueSeconds((long)45L);
    private String query = "";
    private TimeZone timeZone = DEFAULT_TIME_ZONE;
    private int fetchSize = 1000;
    private TimeValue requestTimeout = DEFAULT_REQUEST_TIMEOUT;
    private TimeValue pageTimeout = DEFAULT_PAGE_TIMEOUT;
    @Nullable
    private QueryBuilder filter = null;
    private List<SqlTypedParamValue> params = Collections.emptyList();

    public AbstractSqlQueryRequest() {
    }

    public AbstractSqlQueryRequest(AbstractSqlRequest.Mode mode, String query, List<SqlTypedParamValue> params, QueryBuilder filter, TimeZone timeZone, int fetchSize, TimeValue requestTimeout, TimeValue pageTimeout) {
        super(mode);
        this.query = query;
        this.params = params;
        this.timeZone = timeZone;
        this.fetchSize = fetchSize;
        this.requestTimeout = requestTimeout;
        this.pageTimeout = pageTimeout;
        this.filter = filter;
    }

    protected static <R extends AbstractSqlQueryRequest> ObjectParser<R, Void> objectParser(Supplier<R> supplier) {
        ObjectParser parser = new ObjectParser("sql/query", true, supplier);
        parser.declareString(AbstractSqlQueryRequest::query, new ParseField("query", new String[0]));
        parser.declareObjectArray(AbstractSqlQueryRequest::params, (p, c) -> SqlTypedParamValue.fromXContent(p), new ParseField("params", new String[0]));
        parser.declareString((request, zoneId) -> request.timeZone(TimeZone.getTimeZone(zoneId)), new ParseField("time_zone", new String[0]));
        parser.declareInt(AbstractSqlQueryRequest::fetchSize, new ParseField("fetch_size", new String[0]));
        parser.declareString((request, timeout) -> request.requestTimeout(TimeValue.parseTimeValue((String)timeout, (TimeValue)DEFAULT_REQUEST_TIMEOUT, (String)"request_timeout")), new ParseField("request_timeout", new String[0]));
        parser.declareString((request, timeout) -> request.pageTimeout(TimeValue.parseTimeValue((String)timeout, (TimeValue)DEFAULT_PAGE_TIMEOUT, (String)"page_timeout")), new ParseField("page_timeout", new String[0]));
        parser.declareObject(AbstractSqlQueryRequest::filter, (p, c) -> AbstractQueryBuilder.parseInnerQueryBuilder((XContentParser)p), new ParseField("filter", new String[0]));
        return parser;
    }

    public String query() {
        return this.query;
    }

    public AbstractSqlQueryRequest query(String query) {
        if (query == null) {
            throw new IllegalArgumentException("query may not be null.");
        }
        this.query = query;
        return this;
    }

    public List<SqlTypedParamValue> params() {
        return this.params;
    }

    public AbstractSqlQueryRequest params(List<SqlTypedParamValue> params) {
        if (params == null) {
            throw new IllegalArgumentException("params may not be null.");
        }
        this.params = params;
        return this;
    }

    public TimeZone timeZone() {
        return this.timeZone;
    }

    public AbstractSqlQueryRequest timeZone(TimeZone timeZone) {
        if (this.query == null) {
            throw new IllegalArgumentException("time zone may not be null.");
        }
        this.timeZone = timeZone;
        return this;
    }

    public int fetchSize() {
        return this.fetchSize;
    }

    public AbstractSqlQueryRequest fetchSize(int fetchSize) {
        if (fetchSize <= 0) {
            throw new IllegalArgumentException("fetch_size must be more than 0.");
        }
        this.fetchSize = fetchSize;
        return this;
    }

    public TimeValue requestTimeout() {
        return this.requestTimeout;
    }

    public AbstractSqlQueryRequest requestTimeout(TimeValue requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public TimeValue pageTimeout() {
        return this.pageTimeout;
    }

    public AbstractSqlQueryRequest pageTimeout(TimeValue pageTimeout) {
        this.pageTimeout = pageTimeout;
        return this;
    }

    public AbstractSqlQueryRequest filter(QueryBuilder filter) {
        this.filter = filter;
        return this;
    }

    public QueryBuilder filter() {
        return this.filter;
    }

    public AbstractSqlQueryRequest(StreamInput in) throws IOException {
        super(in);
        this.query = in.readString();
        this.params = in.readList(SqlTypedParamValue::new);
        this.timeZone = TimeZone.getTimeZone(in.readString());
        this.fetchSize = in.readVInt();
        this.requestTimeout = in.readTimeValue();
        this.pageTimeout = in.readTimeValue();
        this.filter = (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.query);
        out.writeList(this.params);
        out.writeString(this.timeZone.getID());
        out.writeVInt(this.fetchSize);
        out.writeTimeValue(this.requestTimeout);
        out.writeTimeValue(this.pageTimeout);
        out.writeOptionalNamedWriteable((NamedWriteable)this.filter);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractSqlQueryRequest that = (AbstractSqlQueryRequest)((Object)o);
        return this.fetchSize == that.fetchSize && Objects.equals(this.query, that.query) && Objects.equals(this.params, that.params) && Objects.equals(this.timeZone, that.timeZone) && Objects.equals(this.requestTimeout, that.requestTimeout) && Objects.equals(this.pageTimeout, that.pageTimeout) && Objects.equals(this.filter, that.filter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.query, this.timeZone, this.fetchSize, this.requestTimeout, this.pageTimeout, this.filter);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.query != null) {
            builder.field("query", this.query);
        }
        if (!this.params.isEmpty()) {
            builder.startArray("params");
            for (SqlTypedParamValue val : this.params) {
                val.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.timeZone != null) {
            builder.field("time_zone", this.timeZone.getID());
        }
        if (this.fetchSize != 1000) {
            builder.field("fetch_size", this.fetchSize);
        }
        if (this.requestTimeout != DEFAULT_REQUEST_TIMEOUT) {
            builder.field("request_timeout", this.requestTimeout.getStringRep());
        }
        if (this.pageTimeout != DEFAULT_PAGE_TIMEOUT) {
            builder.field("page_timeout", this.pageTimeout.getStringRep());
        }
        if (this.filter != null) {
            builder.field("filter");
            this.filter.toXContent(builder, params);
        }
        return builder;
    }
}

