/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plugin;

import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.sql.plugin.AbstractSqlQueryRequest;
import org.elasticsearch.xpack.sql.plugin.AbstractSqlRequest;
import org.elasticsearch.xpack.sql.plugin.SqlTranslateAction;
import org.elasticsearch.xpack.sql.plugin.SqlTranslateRequest;
import org.elasticsearch.xpack.sql.plugin.SqlTranslateResponse;
import org.elasticsearch.xpack.sql.plugin.SqlTypedParamValue;

public class SqlTranslateRequestBuilder
extends ActionRequestBuilder<SqlTranslateRequest, SqlTranslateResponse, SqlTranslateRequestBuilder> {
    public SqlTranslateRequestBuilder(ElasticsearchClient client, SqlTranslateAction action) {
        this(client, action, AbstractSqlRequest.Mode.PLAIN, null, null, Collections.emptyList(), AbstractSqlQueryRequest.DEFAULT_TIME_ZONE, 1000, AbstractSqlQueryRequest.DEFAULT_REQUEST_TIMEOUT, AbstractSqlQueryRequest.DEFAULT_PAGE_TIMEOUT);
    }

    public SqlTranslateRequestBuilder(ElasticsearchClient client, SqlTranslateAction action, AbstractSqlRequest.Mode mode, String query, QueryBuilder filter, List<SqlTypedParamValue> params, TimeZone timeZone, int fetchSize, TimeValue requestTimeout, TimeValue pageTimeout) {
        super(client, (Action)action, (ActionRequest)new SqlTranslateRequest(mode, query, params, filter, timeZone, fetchSize, requestTimeout, pageTimeout));
    }

    public SqlTranslateRequestBuilder query(String query) {
        ((SqlTranslateRequest)this.request).query(query);
        return this;
    }

    public SqlTranslateRequestBuilder timeZone(TimeZone timeZone) {
        ((SqlTranslateRequest)this.request).timeZone(timeZone);
        return this;
    }
}

