/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.saml;

import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.util.Base64;
import java.util.HashMap;
import java.util.Objects;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.saml.IdpConfiguration;
import org.elasticsearch.xpack.security.authc.saml.SamlNameId;
import org.elasticsearch.xpack.security.authc.saml.SamlRequestHandler;
import org.elasticsearch.xpack.security.authc.saml.SamlUtils;
import org.elasticsearch.xpack.security.authc.saml.SpConfiguration;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.EncryptedID;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.crypto.XMLSigningUtil;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.opensaml.xmlsec.signature.Signature;
import org.w3c.dom.Element;

public class SamlLogoutRequestHandler
extends SamlRequestHandler {
    private static final String REQUEST_TAG_NAME = "LogoutRequest";

    SamlLogoutRequestHandler(RealmConfig realmConfig, Clock clock, IdpConfiguration idp, SpConfiguration sp, TimeValue maxSkew) {
        super(realmConfig, clock, idp, sp, maxSkew);
    }

    public Result parseFromQueryString(String queryString) {
        ParsedQueryString parsed = this.parseQueryStringAndValidateSignature(queryString);
        Element root = this.parseSamlMessage(this.inflate(this.decodeBase64(parsed.samlRequest)));
        if (REQUEST_TAG_NAME.equals(root.getLocalName()) && "urn:oasis:names:tc:SAML:2.0:protocol".equals(root.getNamespaceURI())) {
            try {
                LogoutRequest logoutRequest = this.buildXmlObject(root, LogoutRequest.class);
                return this.parseLogout(logoutRequest, !parsed.hasSignature, parsed.relayState);
            }
            catch (ElasticsearchSecurityException e) {
                this.logger.trace("Rejecting SAML logout request {} because {}", (Object)SamlUtils.toString(root), (Object)e.getMessage());
                throw e;
            }
        }
        throw SamlUtils.samlException("SAML content [{}] should have a root element of Namespace=[{}] Tag=[{}]", root, "urn:oasis:names:tc:SAML:2.0:protocol", REQUEST_TAG_NAME);
    }

    private ParsedQueryString parseQueryStringAndValidateSignature(String queryString) {
        String signatureInput = queryString.replaceAll("&Signature=.*$", "");
        HashMap parameters = new HashMap();
        RestUtils.decodeQueryString((String)queryString, (int)0, parameters);
        String samlRequest = (String)parameters.get("SAMLRequest");
        if (samlRequest == null) {
            throw SamlUtils.samlException("Could not parse SAMLRequest from query string: [{}]", queryString);
        }
        String relayState = (String)parameters.get("RelayState");
        String signatureAlgorithm = (String)parameters.get("SigAlg");
        String signature = (String)parameters.get("Signature");
        if (signature == null || signatureAlgorithm == null) {
            return new ParsedQueryString(samlRequest, false, relayState);
        }
        this.validateSignature(signatureInput, signatureAlgorithm, signature);
        return new ParsedQueryString(samlRequest, true, relayState);
    }

    private Result parseLogout(LogoutRequest logoutRequest, boolean requireSignature, String relayState) {
        Signature signature = logoutRequest.getSignature();
        if (signature == null) {
            if (requireSignature) {
                throw SamlUtils.samlException("Logout request is not signed", new Object[0]);
            }
        } else {
            this.validateSignature(signature);
        }
        this.checkIssuer(logoutRequest.getIssuer(), (XMLObject)logoutRequest);
        this.checkDestination(logoutRequest);
        this.validateNotOnOrAfter(logoutRequest.getNotOnOrAfter());
        return new Result(logoutRequest.getID(), SamlNameId.fromXml(this.getNameID(logoutRequest)), this.getSessionIndex(logoutRequest), relayState);
    }

    private void validateSignature(String inputString, String signatureAlgorithm, String signature) {
        byte[] sigBytes = this.decodeBase64(signature);
        byte[] inputBytes = inputString.getBytes(StandardCharsets.US_ASCII);
        String signatureText = Strings.cleanTruncate((String)signature, (int)32);
        this.checkIdpSignature((CheckedFunction<Credential, Boolean, Exception>)((CheckedFunction)credential -> {
            if (XMLSigningUtil.verifyWithURI((Credential)credential, (String)signatureAlgorithm, (byte[])sigBytes, (byte[])inputBytes)) {
                this.logger.debug(() -> new ParameterizedMessage("SAML Signature [{}] matches credentials [{}] [{}]", new Object[]{signatureText, credential.getEntityId(), credential.getPublicKey()}));
                return true;
            }
            this.logger.debug(() -> new ParameterizedMessage("SAML Signature [{}] failed against credentials [{}] [{}]", new Object[]{signatureText, credential.getEntityId(), credential.getPublicKey()}));
            return false;
        }), signatureText);
    }

    private byte[] decodeBase64(String content) {
        try {
            return Base64.getDecoder().decode(content.replaceAll("\\s+", ""));
        }
        catch (IllegalArgumentException e) {
            this.logger.info("Failed to decode base64 string [{}] - {}", (Object)content, (Object)e.toString());
            throw SamlUtils.samlException("SAML message cannot be Base64 decoded", e, new Object[0]);
        }
    }

    /*
     * Exception decompiling
     */
    private byte[] inflate(byte[] bytes) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private NameID getNameID(LogoutRequest logoutRequest) {
        SAMLObject samlObject;
        EncryptedID encryptedID;
        NameID nameID = logoutRequest.getNameID();
        if (nameID == null && (encryptedID = logoutRequest.getEncryptedID()) != null && (samlObject = this.decrypt(encryptedID)) instanceof NameID) {
            return (NameID)samlObject;
        }
        return nameID;
    }

    private SAMLObject decrypt(EncryptedID encrypted) {
        if (this.decrypter == null) {
            throw SamlUtils.samlException("SAML EncryptedID [" + this.text((XMLObject)encrypted, 32) + "] is encrypted, but no decryption key is available", new Object[0]);
        }
        try {
            return this.decrypter.decrypt(encrypted);
        }
        catch (DecryptionException e) {
            this.logger.debug(() -> new ParameterizedMessage("Failed to decrypt SAML EncryptedID [{}] with [{}]", (Object)this.text((XMLObject)encrypted, 512), (Object)this.describe(this.getSpConfiguration().getEncryptionCredentials())), (Throwable)e);
            throw SamlUtils.samlException("Failed to decrypt SAML EncryptedID " + this.text((XMLObject)encrypted, 32), (Exception)((Object)e), new Object[0]);
        }
    }

    private String getSessionIndex(LogoutRequest logoutRequest) {
        return logoutRequest.getSessionIndexes().stream().map(as -> as.getSessionIndex()).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private void checkDestination(LogoutRequest request) {
        String url = this.getSpConfiguration().getLogoutUrl();
        if (url == null) {
            throw SamlUtils.samlException("SAML request " + request.getID() + " is for destination " + request.getDestination() + " but this realm is not configured for logout", new Object[0]);
        }
        if (!url.equals(request.getDestination())) {
            throw SamlUtils.samlException("SAML request " + request.getID() + " is for destination " + request.getDestination() + " but this realm uses " + url, new Object[0]);
        }
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    public static class Result {
        private final String requestId;
        private final SamlNameId nameId;
        private final String session;
        private final String relayState;

        public Result(String requestId, SamlNameId nameId, String session, String relayState) {
            this.requestId = requestId;
            this.nameId = nameId;
            this.session = session;
            this.relayState = relayState;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public SamlNameId getNameId() {
            return this.nameId;
        }

        public String getSession() {
            return this.session;
        }

        public String getRelayState() {
            return this.relayState;
        }

        public String toString() {
            return "SamlLogoutRequestHandler.Result{requestId='" + this.requestId + '\'' + ", nameId=" + this.nameId + ", session='" + this.session + '\'' + ", relayState='" + this.relayState + '\'' + '}';
        }
    }

    static class ParsedQueryString {
        final String samlRequest;
        final boolean hasSignature;
        final String relayState;

        ParsedQueryString(String samlRequest, boolean hasSignature, String relayState) {
            this.samlRequest = samlRequest;
            this.hasSignature = hasSignature;
            this.relayState = relayState;
        }
    }
}

