/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport;

import io.netty.channel.Channel;
import io.netty.handler.ssl.SslHandler;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.transport.TaskTransportChannel;
import org.elasticsearch.transport.TcpTransportChannel;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.netty4.NettyTcpChannel;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.permission.Role;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.core.security.user.KibanaUser;
import org.elasticsearch.xpack.core.security.user.SystemUser;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.action.SecurityActionMapper;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authz.AuthorizationService;
import org.elasticsearch.xpack.security.authz.AuthorizationUtils;

public interface ServerTransportFilter {
    public void inbound(String var1, TransportRequest var2, TransportChannel var3, ActionListener<Void> var4) throws IOException;

    public static void extractClientCertificates(Logger logger, ThreadContext threadContext, SSLEngine sslEngine, Channel channel) {
        block6: {
            try {
                Certificate[] certs = sslEngine.getSession().getPeerCertificates();
                if (certs instanceof X509Certificate[]) {
                    threadContext.putTransient("__SECURITY_CLIENT_CERTIFICATE", (Object)certs);
                }
            }
            catch (SSLPeerUnverifiedException e) {
                if (!1.$assertionsDisabled && sslEngine.getNeedClientAuth()) {
                    throw new AssertionError();
                }
                if (!1.$assertionsDisabled && !sslEngine.getWantClientAuth()) {
                    throw new AssertionError();
                }
                if (logger.isTraceEnabled()) {
                    logger.trace(() -> new ParameterizedMessage("SSL Peer did not present a certificate on channel [{}]", (Object)channel), (Throwable)e);
                }
                if (!logger.isDebugEnabled()) break block6;
                logger.debug("SSL Peer did not present a certificate on channel [{}]", (Object)channel);
            }
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static class ClientProfile
    extends NodeProfile {
        ClientProfile(AuthenticationService authcService, AuthorizationService authzService, ThreadContext threadContext, boolean extractClientCert, DestructiveOperations destructiveOperations, boolean reservedRealmEnabled, SecurityContext securityContext) {
            super(authcService, authzService, threadContext, extractClientCert, destructiveOperations, reservedRealmEnabled, securityContext);
        }

        @Override
        public void inbound(String action, TransportRequest request, TransportChannel transportChannel, ActionListener<Void> listener) throws IOException {
            boolean isInternalOrShardAction;
            boolean bl = isInternalOrShardAction = action.startsWith("internal:") || action.endsWith("]");
            if (isInternalOrShardAction && !"internal:transport/handshake".equals(action)) {
                throw Exceptions.authenticationError((String)"executing internal/shard actions is considered malicious and forbidden", (Object[])new Object[0]);
            }
            super.inbound(action, request, transportChannel, listener);
        }
    }

    public static class NodeProfile
    implements ServerTransportFilter {
        private static final Logger logger = Loggers.getLogger(NodeProfile.class);
        private final AuthenticationService authcService;
        private final AuthorizationService authzService;
        private final SecurityActionMapper actionMapper = new SecurityActionMapper();
        private final ThreadContext threadContext;
        private final boolean extractClientCert;
        private final DestructiveOperations destructiveOperations;
        private final boolean reservedRealmEnabled;
        private final SecurityContext securityContext;

        NodeProfile(AuthenticationService authcService, AuthorizationService authzService, ThreadContext threadContext, boolean extractClientCert, DestructiveOperations destructiveOperations, boolean reservedRealmEnabled, SecurityContext securityContext) {
            this.authcService = authcService;
            this.authzService = authzService;
            this.threadContext = threadContext;
            this.extractClientCert = extractClientCert;
            this.destructiveOperations = destructiveOperations;
            this.reservedRealmEnabled = reservedRealmEnabled;
            this.securityContext = securityContext;
        }

        @Override
        public void inbound(String action, TransportRequest request, TransportChannel transportChannel, ActionListener<Void> listener) throws IOException {
            if ("indices:admin/close".equals(action) || "indices:admin/open".equals(action) || "indices:admin/delete".equals(action)) {
                IndicesRequest indicesRequest = (IndicesRequest)request;
                try {
                    this.destructiveOperations.failDestructive(indicesRequest.indices());
                }
                catch (IllegalArgumentException e) {
                    listener.onFailure((Exception)e);
                    return;
                }
            }
            String securityAction = this.actionMapper.action(action, request);
            TransportChannel unwrappedChannel = transportChannel;
            if (unwrappedChannel instanceof TaskTransportChannel) {
                unwrappedChannel = ((TaskTransportChannel)unwrappedChannel).getChannel();
            }
            if (this.extractClientCert && unwrappedChannel instanceof TcpTransportChannel && ((TcpTransportChannel)unwrappedChannel).getChannel() instanceof NettyTcpChannel) {
                Channel channel = ((NettyTcpChannel)((TcpTransportChannel)unwrappedChannel).getChannel()).getLowLevelChannel();
                SslHandler sslHandler = (SslHandler)channel.pipeline().get(SslHandler.class);
                if (channel.isOpen()) {
                    assert (sslHandler != null) : "channel [" + channel + "] did not have a ssl handler. pipeline " + channel.pipeline();
                    ServerTransportFilter.extractClientCertificates(logger, this.threadContext, sslHandler.engine(), channel);
                }
            }
            Version version = transportChannel.getVersion().equals((Object)Version.V_5_4_0) ? Version.CURRENT : transportChannel.getVersion();
            this.authcService.authenticate(securityAction, (TransportMessage)request, (User)null, (ActionListener<Authentication>)ActionListener.wrap(authentication -> {
                if (this.reservedRealmEnabled && authentication.getVersion().before(Version.V_5_2_0) && "kibana".equals(authentication.getUser().authenticatedUser().principal())) {
                    this.executeAsCurrentVersionKibanaUser(securityAction, request, transportChannel, listener, (Authentication)authentication);
                } else if (securityAction.equals("internal:transport/handshake") && !SystemUser.is((User)authentication.getUser())) {
                    this.securityContext.executeAsUser(SystemUser.INSTANCE, ctx -> {
                        Authentication replaced = Authentication.getAuthentication((ThreadContext)this.threadContext);
                        AuthorizationUtils.AsyncAuthorizer asyncAuthorizer = new AuthorizationUtils.AsyncAuthorizer(replaced, listener, (userRoles, runAsRoles) -> {
                            this.authzService.authorize(replaced, securityAction, request, (Role)userRoles, (Role)runAsRoles);
                            listener.onResponse(null);
                        });
                        asyncAuthorizer.authorize(this.authzService);
                    }, version);
                } else if (authentication.getVersion().before(Version.V_5_6_1) && "_xpack".equals(authentication.getUser().authenticatedUser().principal())) {
                    this.executeAsOldVersionXPackUser(securityAction, request, transportChannel, listener);
                } else {
                    AuthorizationUtils.AsyncAuthorizer asyncAuthorizer = new AuthorizationUtils.AsyncAuthorizer((Authentication)authentication, (ActionListener)listener, (userRoles, runAsRoles) -> {
                        this.authzService.authorize((Authentication)authentication, securityAction, request, (Role)userRoles, (Role)runAsRoles);
                        listener.onResponse(null);
                    });
                    asyncAuthorizer.authorize(this.authzService);
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        }

        private void executeAsCurrentVersionKibanaUser(String securityAction, TransportRequest request, TransportChannel transportChannel, ActionListener<Void> listener, Authentication authentication) {
            KibanaUser kibanaUser = new KibanaUser(authentication.getUser().enabled());
            if (!kibanaUser.enabled()) {
                throw new IllegalStateException("a disabled user should never be sent. " + kibanaUser);
            }
            this.executeAsUser((User)kibanaUser, securityAction, request, transportChannel, listener);
        }

        private void executeAsOldVersionXPackUser(String securityAction, TransportRequest request, TransportChannel transportChannel, ActionListener<Void> listener) {
            User xpackUser = new User("_xpack", new String[]{"superuser"});
            this.executeAsUser(xpackUser, securityAction, request, transportChannel, listener);
        }

        private void executeAsUser(User user, String securityAction, TransportRequest request, TransportChannel transportChannel, ActionListener<Void> listener) {
            this.securityContext.executeAsUser(user, original -> {
                Authentication replacedUserAuth = this.securityContext.getAuthentication();
                AuthorizationUtils.AsyncAuthorizer asyncAuthorizer = new AuthorizationUtils.AsyncAuthorizer(replacedUserAuth, listener, (userRoles, runAsRoles) -> {
                    this.authzService.authorize(replacedUserAuth, securityAction, request, (Role)userRoles, (Role)runAsRoles);
                    listener.onResponse(null);
                });
                asyncAuthorizer.authorize(this.authzService);
            }, transportChannel.getVersion());
        }
    }
}

