/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.config;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public enum RuleConditionType implements Writeable
{
    CATEGORICAL(false, true),
    NUMERICAL_ACTUAL(true, false),
    NUMERICAL_TYPICAL(true, false),
    NUMERICAL_DIFF_ABS(true, false),
    TIME(false, false),
    CATEGORICAL_COMPLEMENT(false, true);

    private final boolean isNumerical;
    private final boolean isCategorical;

    private RuleConditionType(boolean isNumerical, boolean isCategorical) {
        this.isNumerical = isNumerical;
        this.isCategorical = isCategorical;
    }

    public boolean isNumerical() {
        return this.isNumerical;
    }

    public boolean isCategorical() {
        return this.isCategorical;
    }

    public static RuleConditionType fromString(String value) {
        return RuleConditionType.valueOf(value.toUpperCase(Locale.ROOT));
    }

    public static RuleConditionType readFromStream(StreamInput in) throws IOException {
        return (RuleConditionType)in.readEnum(RuleConditionType.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this == CATEGORICAL_COMPLEMENT && out.getVersion().before(Version.V_6_3_0)) {
            out.writeEnum((Enum)CATEGORICAL);
        } else {
            out.writeEnum((Enum)this);
        }
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

