/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.process.autodetect.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshotField;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelState;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.Quantiles;
import org.elasticsearch.xpack.core.ml.utils.time.TimeUtils;

public class ModelSnapshot
implements ToXContentObject,
Writeable {
    public static final ParseField TIMESTAMP = new ParseField("timestamp", new String[0]);
    public static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
    public static final ParseField SNAPSHOT_DOC_COUNT = new ParseField("snapshot_doc_count", new String[0]);
    public static final ParseField LATEST_RECORD_TIME = new ParseField("latest_record_time_stamp", new String[0]);
    public static final ParseField LATEST_RESULT_TIME = new ParseField("latest_result_time_stamp", new String[0]);
    public static final ParseField QUANTILES = new ParseField("quantiles", new String[0]);
    public static final ParseField RETAIN = new ParseField("retain", new String[0]);
    public static final ParseField RESULTS_FIELD = new ParseField("model_snapshots", new String[0]);
    public static final ParseField TYPE = new ParseField("model_snapshot", new String[0]);
    public static final ObjectParser<Builder, Void> STRICT_PARSER = ModelSnapshot.createParser(false);
    public static final ObjectParser<Builder, Void> LENIENT_PARSER = ModelSnapshot.createParser(true);
    private final String jobId;
    private final Date timestamp;
    private final String description;
    private final String snapshotId;
    private final int snapshotDocCount;
    private final ModelSizeStats modelSizeStats;
    private final Date latestRecordTimeStamp;
    private final Date latestResultTimeStamp;
    private final Quantiles quantiles;
    private final boolean retain;

    private static ObjectParser<Builder, Void> createParser(boolean ignoreUnknownFields) {
        ObjectParser parser = new ObjectParser(TYPE.getPreferredName(), ignoreUnknownFields, Builder::new);
        parser.declareString(Builder::setJobId, Job.ID);
        parser.declareField(Builder::setTimestamp, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return new Date(p.longValue());
            }
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return new Date(TimeUtils.dateStringToEpoch(p.text()));
            }
            throw new IllegalArgumentException("unexpected token [" + p.currentToken() + "] for [" + TIMESTAMP.getPreferredName() + "]");
        }, TIMESTAMP, ObjectParser.ValueType.VALUE);
        parser.declareString(Builder::setDescription, DESCRIPTION);
        parser.declareString(Builder::setSnapshotId, ModelSnapshotField.SNAPSHOT_ID);
        parser.declareInt(Builder::setSnapshotDocCount, SNAPSHOT_DOC_COUNT);
        parser.declareObject(Builder::setModelSizeStats, ignoreUnknownFields ? ModelSizeStats.LENIENT_PARSER : ModelSizeStats.STRICT_PARSER, ModelSizeStats.RESULT_TYPE_FIELD);
        parser.declareField(Builder::setLatestRecordTimeStamp, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return new Date(p.longValue());
            }
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return new Date(TimeUtils.dateStringToEpoch(p.text()));
            }
            throw new IllegalArgumentException("unexpected token [" + p.currentToken() + "] for [" + LATEST_RECORD_TIME.getPreferredName() + "]");
        }, LATEST_RECORD_TIME, ObjectParser.ValueType.VALUE);
        parser.declareField(Builder::setLatestResultTimeStamp, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return new Date(p.longValue());
            }
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return new Date(TimeUtils.dateStringToEpoch(p.text()));
            }
            throw new IllegalArgumentException("unexpected token [" + p.currentToken() + "] for [" + LATEST_RESULT_TIME.getPreferredName() + "]");
        }, LATEST_RESULT_TIME, ObjectParser.ValueType.VALUE);
        parser.declareObject(Builder::setQuantiles, ignoreUnknownFields ? Quantiles.LENIENT_PARSER : Quantiles.STRICT_PARSER, QUANTILES);
        parser.declareBoolean(Builder::setRetain, RETAIN);
        return parser;
    }

    private ModelSnapshot(String jobId, Date timestamp, String description, String snapshotId, int snapshotDocCount, ModelSizeStats modelSizeStats, Date latestRecordTimeStamp, Date latestResultTimeStamp, Quantiles quantiles, boolean retain) {
        this.jobId = jobId;
        this.timestamp = timestamp;
        this.description = description;
        this.snapshotId = snapshotId;
        this.snapshotDocCount = snapshotDocCount;
        this.modelSizeStats = modelSizeStats;
        this.latestRecordTimeStamp = latestRecordTimeStamp;
        this.latestResultTimeStamp = latestResultTimeStamp;
        this.quantiles = quantiles;
        this.retain = retain;
    }

    public ModelSnapshot(StreamInput in) throws IOException {
        this.jobId = in.readString();
        this.timestamp = in.readBoolean() ? new Date(in.readVLong()) : null;
        this.description = in.readOptionalString();
        this.snapshotId = in.readOptionalString();
        this.snapshotDocCount = in.readInt();
        this.modelSizeStats = (ModelSizeStats)in.readOptionalWriteable(ModelSizeStats::new);
        this.latestRecordTimeStamp = in.readBoolean() ? new Date(in.readVLong()) : null;
        this.latestResultTimeStamp = in.readBoolean() ? new Date(in.readVLong()) : null;
        this.quantiles = (Quantiles)in.readOptionalWriteable(Quantiles::new);
        this.retain = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        if (this.timestamp != null) {
            out.writeBoolean(true);
            out.writeVLong(this.timestamp.getTime());
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.description);
        out.writeOptionalString(this.snapshotId);
        out.writeInt(this.snapshotDocCount);
        out.writeOptionalWriteable((Writeable)this.modelSizeStats);
        if (this.latestRecordTimeStamp != null) {
            out.writeBoolean(true);
            out.writeVLong(this.latestRecordTimeStamp.getTime());
        } else {
            out.writeBoolean(false);
        }
        if (this.latestResultTimeStamp != null) {
            out.writeBoolean(true);
            out.writeVLong(this.latestResultTimeStamp.getTime());
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalWriteable((Writeable)this.quantiles);
        out.writeBoolean(this.retain);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        if (this.timestamp != null) {
            builder.timeField(TIMESTAMP.getPreferredName(), TIMESTAMP.getPreferredName() + "_string", this.timestamp.getTime());
        }
        if (this.description != null) {
            builder.field(DESCRIPTION.getPreferredName(), this.description);
        }
        if (this.snapshotId != null) {
            builder.field(ModelSnapshotField.SNAPSHOT_ID.getPreferredName(), this.snapshotId);
        }
        builder.field(SNAPSHOT_DOC_COUNT.getPreferredName(), this.snapshotDocCount);
        if (this.modelSizeStats != null) {
            builder.field(ModelSizeStats.RESULT_TYPE_FIELD.getPreferredName(), (ToXContent)this.modelSizeStats);
        }
        if (this.latestRecordTimeStamp != null) {
            builder.timeField(LATEST_RECORD_TIME.getPreferredName(), LATEST_RECORD_TIME.getPreferredName() + "_string", this.latestRecordTimeStamp.getTime());
        }
        if (this.latestResultTimeStamp != null) {
            builder.timeField(LATEST_RESULT_TIME.getPreferredName(), LATEST_RESULT_TIME.getPreferredName() + "_string", this.latestResultTimeStamp.getTime());
        }
        if (this.quantiles != null) {
            builder.field(QUANTILES.getPreferredName(), (ToXContent)this.quantiles);
        }
        builder.field(RETAIN.getPreferredName(), this.retain);
        builder.endObject();
        return builder;
    }

    public String getJobId() {
        return this.jobId;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public int getSnapshotDocCount() {
        return this.snapshotDocCount;
    }

    public ModelSizeStats getModelSizeStats() {
        return this.modelSizeStats;
    }

    public Quantiles getQuantiles() {
        return this.quantiles;
    }

    public Date getLatestRecordTimeStamp() {
        return this.latestRecordTimeStamp;
    }

    public Date getLatestResultTimeStamp() {
        return this.latestResultTimeStamp;
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.timestamp, this.description, this.snapshotId, this.quantiles, this.snapshotDocCount, this.modelSizeStats, this.latestRecordTimeStamp, this.latestResultTimeStamp, this.retain);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ModelSnapshot)) {
            return false;
        }
        ModelSnapshot that = (ModelSnapshot)other;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.description, that.description) && Objects.equals(this.snapshotId, that.snapshotId) && this.snapshotDocCount == that.snapshotDocCount && Objects.equals(this.modelSizeStats, that.modelSizeStats) && Objects.equals(this.quantiles, that.quantiles) && Objects.equals(this.latestRecordTimeStamp, that.latestRecordTimeStamp) && Objects.equals(this.latestResultTimeStamp, that.latestResultTimeStamp) && this.retain == that.retain;
    }

    public List<String> stateDocumentIds() {
        ArrayList<String> stateDocumentIds = new ArrayList<String>(this.snapshotDocCount);
        for (int i = 1; i <= this.snapshotDocCount; ++i) {
            stateDocumentIds.add(ModelState.documentId(this.jobId, this.snapshotId, i));
        }
        return stateDocumentIds;
    }

    public List<String> legacyStateDocumentIds() {
        ArrayList<String> stateDocumentIds = new ArrayList<String>(this.snapshotDocCount);
        for (int i = 1; i <= this.snapshotDocCount; ++i) {
            stateDocumentIds.add(ModelState.v54DocumentId(this.jobId, this.snapshotId, i));
        }
        return stateDocumentIds;
    }

    public static String documentIdPrefix(String jobId) {
        return jobId + "_" + TYPE + "_";
    }

    public static String documentId(ModelSnapshot snapshot) {
        return ModelSnapshot.documentId(snapshot.getJobId(), snapshot.getSnapshotId());
    }

    public static String v54DocumentId(ModelSnapshot snapshot) {
        return ModelSnapshot.v54DocumentId(snapshot.getJobId(), snapshot.getSnapshotId());
    }

    public static String documentId(String jobId, String snapshotId) {
        return ModelSnapshot.documentIdPrefix(jobId) + snapshotId;
    }

    public static String v54DocumentId(String jobId, String snapshotId) {
        return jobId + "-" + snapshotId;
    }

    /*
     * Exception decompiling
     */
    public static ModelSnapshot fromJson(BytesReference bytesReference) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    public static class Builder {
        private String jobId;
        private Date timestamp;
        private String description;
        private String snapshotId;
        private int snapshotDocCount;
        private ModelSizeStats modelSizeStats;
        private Date latestRecordTimeStamp;
        private Date latestResultTimeStamp;
        private Quantiles quantiles;
        private boolean retain;

        public Builder() {
        }

        public Builder(String jobId) {
            this();
            this.jobId = jobId;
        }

        public Builder(ModelSnapshot modelSnapshot) {
            this.jobId = modelSnapshot.jobId;
            this.timestamp = modelSnapshot.timestamp;
            this.description = modelSnapshot.description;
            this.snapshotId = modelSnapshot.snapshotId;
            this.snapshotDocCount = modelSnapshot.snapshotDocCount;
            this.modelSizeStats = modelSnapshot.modelSizeStats;
            this.latestRecordTimeStamp = modelSnapshot.latestRecordTimeStamp;
            this.latestResultTimeStamp = modelSnapshot.latestResultTimeStamp;
            this.quantiles = modelSnapshot.quantiles;
            this.retain = modelSnapshot.retain;
        }

        public Builder setJobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public Builder setSnapshotDocCount(int snapshotDocCount) {
            this.snapshotDocCount = snapshotDocCount;
            return this;
        }

        public Builder setModelSizeStats(ModelSizeStats.Builder modelSizeStats) {
            this.modelSizeStats = modelSizeStats.build();
            return this;
        }

        public Builder setModelSizeStats(ModelSizeStats modelSizeStats) {
            this.modelSizeStats = modelSizeStats;
            return this;
        }

        public Builder setLatestRecordTimeStamp(Date latestRecordTimeStamp) {
            this.latestRecordTimeStamp = latestRecordTimeStamp;
            return this;
        }

        public Builder setLatestResultTimeStamp(Date latestResultTimeStamp) {
            this.latestResultTimeStamp = latestResultTimeStamp;
            return this;
        }

        public Builder setQuantiles(Quantiles quantiles) {
            this.quantiles = quantiles;
            return this;
        }

        public Builder setRetain(boolean value) {
            this.retain = value;
            return this;
        }

        public ModelSnapshot build() {
            return new ModelSnapshot(this.jobId, this.timestamp, this.description, this.snapshotId, this.snapshotDocCount, this.modelSizeStats, this.latestRecordTimeStamp, this.latestResultTimeStamp, this.quantiles, this.retain);
        }
    }
}

