/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.aggregate;

import java.util.List;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.function.Function;
import org.elasticsearch.xpack.sql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.sql.expression.function.aggregate.AggregateFunctionAttribute;
import org.elasticsearch.xpack.sql.expression.function.aggregate.CompoundNumericAggregate;
import org.elasticsearch.xpack.sql.expression.function.aggregate.EnclosedAgg;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.type.DataType;

public class InnerAggregate
extends AggregateFunction {
    private final AggregateFunction inner;
    private final CompoundNumericAggregate outer;
    private final String innerId;
    private final Expression innerKey;

    public InnerAggregate(AggregateFunction inner, CompoundNumericAggregate outer) {
        this(inner.location(), inner, outer, null);
    }

    public InnerAggregate(Location location, AggregateFunction inner, CompoundNumericAggregate outer, Expression innerKey) {
        super(location, outer.field(), outer.arguments());
        this.inner = inner;
        this.outer = outer;
        this.innerId = ((EnclosedAgg)((Object)inner)).innerName();
        this.innerKey = innerKey;
    }

    @Override
    protected NodeInfo<InnerAggregate> info() {
        return NodeInfo.create(this, InnerAggregate::new, this.inner, this.outer, this.innerKey);
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        throw new UnsupportedOperationException("can't be rewritten");
    }

    public AggregateFunction inner() {
        return this.inner;
    }

    public CompoundNumericAggregate outer() {
        return this.outer;
    }

    public String innerId() {
        return this.innerId;
    }

    public Expression innerKey() {
        return this.innerKey;
    }

    @Override
    public DataType dataType() {
        return this.inner.dataType();
    }

    @Override
    public String functionId() {
        return this.outer.id().toString();
    }

    @Override
    public AggregateFunctionAttribute toAttribute() {
        return new AggregateFunctionAttribute(this.location(), this.name(), this.dataType(), this.outer.id(), this.functionId(), InnerAggregate.aggMetricValue(this.functionId(), this.innerId));
    }

    public static String aggMetricValue(String aggPath, String valueName) {
        return aggPath + "[" + valueName + "]";
    }

    @Override
    public boolean functionEquals(Function f) {
        if (super.equals(f)) {
            InnerAggregate other = (InnerAggregate)f;
            return this.inner.equals(other.inner) && this.outer.equals(other.outer);
        }
        return false;
    }

    @Override
    public String name() {
        return this.inner.name();
    }
}

