/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.arithmetic;

import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.NamedExpression;
import org.elasticsearch.xpack.sql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.arithmetic.Arithmetics;
import org.elasticsearch.xpack.sql.expression.function.scalar.arithmetic.UnaryArithmeticProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.definition.ProcessorDefinition;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.definition.ProcessorDefinitions;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.definition.UnaryProcessorDefinition;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.type.DataType;

public class Neg
extends UnaryScalarFunction {
    public Neg(Location location, Expression field) {
        super(location, field);
    }

    @Override
    protected NodeInfo<Neg> info() {
        return NodeInfo.create(this, Neg::new, this.field());
    }

    @Override
    protected UnaryScalarFunction replaceChild(Expression newChild) {
        return new Neg(this.location(), newChild);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return Expressions.typeMustBeNumeric(this.field());
    }

    @Override
    public Object fold() {
        return Arithmetics.negate((Number)this.field().fold());
    }

    @Override
    public DataType dataType() {
        return this.field().dataType();
    }

    @Override
    public String name() {
        return "-" + (this.field() instanceof NamedExpression && this.field().resolved() ? Expressions.name(this.field()) : this.field().toString());
    }

    @Override
    protected String formatScript(String template) {
        return super.formatScript("-" + template);
    }

    @Override
    protected ProcessorDefinition makeProcessorDefinition() {
        return new UnaryProcessorDefinition(this.location(), this, ProcessorDefinitions.toProcessorDefinition(this.field()), new UnaryArithmeticProcessor(UnaryArithmeticProcessor.UnaryArithmeticOperation.NEGATE));
    }
}

