/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan;

import java.util.Objects;
import org.elasticsearch.xpack.sql.tree.Location;

public class TableIdentifier {
    private final Location location;
    private final String cluster;
    private final String index;

    public TableIdentifier(Location location, String catalog, String index) {
        this.location = location;
        this.cluster = catalog;
        this.index = index;
    }

    public String cluster() {
        return this.cluster;
    }

    public String index() {
        return this.index;
    }

    public int hashCode() {
        return Objects.hash(this.cluster, this.index);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TableIdentifier other = (TableIdentifier)obj;
        return Objects.equals(this.index, other.index) && Objects.equals(this.cluster, other.cluster);
    }

    public Location location() {
        return this.location;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        if (this.cluster != null) {
            builder.append(this.cluster);
        }
        builder.append("][index=");
        builder.append(this.index);
        builder.append("]");
        return builder.toString();
    }
}

