/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ar.ArabicNormalizationFilter;
import org.apache.lucene.analysis.ar.ArabicStemFilter;
import org.apache.lucene.analysis.bn.BengaliNormalizationFilter;
import org.apache.lucene.analysis.br.BrazilianStemFilter;
import org.apache.lucene.analysis.charfilter.HTMLStripCharFilter;
import org.apache.lucene.analysis.cjk.CJKBigramFilter;
import org.apache.lucene.analysis.cjk.CJKWidthFilter;
import org.apache.lucene.analysis.ckb.SoraniNormalizationFilter;
import org.apache.lucene.analysis.commongrams.CommonGramsFilter;
import org.apache.lucene.analysis.core.DecimalDigitFilter;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.core.LowerCaseTokenizer;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.core.UpperCaseFilter;
import org.apache.lucene.analysis.cz.CzechStemFilter;
import org.apache.lucene.analysis.de.GermanNormalizationFilter;
import org.apache.lucene.analysis.de.GermanStemFilter;
import org.apache.lucene.analysis.en.KStemFilter;
import org.apache.lucene.analysis.en.PorterStemFilter;
import org.apache.lucene.analysis.fa.PersianNormalizationFilter;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.hi.HindiNormalizationFilter;
import org.apache.lucene.analysis.in.IndicNormalizationFilter;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.apache.lucene.analysis.miscellaneous.DisableGraphAttribute;
import org.apache.lucene.analysis.miscellaneous.KeywordRepeatFilter;
import org.apache.lucene.analysis.miscellaneous.LengthFilter;
import org.apache.lucene.analysis.miscellaneous.LimitTokenCountFilter;
import org.apache.lucene.analysis.miscellaneous.ScandinavianFoldingFilter;
import org.apache.lucene.analysis.miscellaneous.ScandinavianNormalizationFilter;
import org.apache.lucene.analysis.miscellaneous.TrimFilter;
import org.apache.lucene.analysis.miscellaneous.TruncateTokenFilter;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterFilter;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterGraphFilter;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;
import org.apache.lucene.analysis.ngram.NGramTokenFilter;
import org.apache.lucene.analysis.payloads.DelimitedPayloadTokenFilter;
import org.apache.lucene.analysis.payloads.TypeAsPayloadTokenFilter;
import org.apache.lucene.analysis.reverse.ReverseStringFilter;
import org.apache.lucene.analysis.shingle.ShingleFilter;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.standard.ClassicFilter;
import org.apache.lucene.analysis.tr.ApostropheFilter;
import org.apache.lucene.analysis.util.ElisionFilter;
import org.elasticsearch.Version;
import org.elasticsearch.analysis.common.ASCIIFoldingTokenFilterFactory;
import org.elasticsearch.analysis.common.ApostropheFilterFactory;
import org.elasticsearch.analysis.common.ArabicNormalizationFilterFactory;
import org.elasticsearch.analysis.common.ArabicStemTokenFilterFactory;
import org.elasticsearch.analysis.common.BengaliNormalizationFilterFactory;
import org.elasticsearch.analysis.common.BrazilianStemTokenFilterFactory;
import org.elasticsearch.analysis.common.CJKBigramFilterFactory;
import org.elasticsearch.analysis.common.CJKWidthFilterFactory;
import org.elasticsearch.analysis.common.ClassicFilterFactory;
import org.elasticsearch.analysis.common.CommonGramsTokenFilterFactory;
import org.elasticsearch.analysis.common.CzechStemTokenFilterFactory;
import org.elasticsearch.analysis.common.DecimalDigitFilterFactory;
import org.elasticsearch.analysis.common.DelimitedPayloadTokenFilterFactory;
import org.elasticsearch.analysis.common.DictionaryCompoundWordTokenFilterFactory;
import org.elasticsearch.analysis.common.DutchStemTokenFilterFactory;
import org.elasticsearch.analysis.common.EdgeNGramTokenFilterFactory;
import org.elasticsearch.analysis.common.ElisionTokenFilterFactory;
import org.elasticsearch.analysis.common.FingerprintTokenFilterFactory;
import org.elasticsearch.analysis.common.FlattenGraphTokenFilterFactory;
import org.elasticsearch.analysis.common.FrenchStemTokenFilterFactory;
import org.elasticsearch.analysis.common.GermanNormalizationFilterFactory;
import org.elasticsearch.analysis.common.GermanStemTokenFilterFactory;
import org.elasticsearch.analysis.common.HindiNormalizationFilterFactory;
import org.elasticsearch.analysis.common.HtmlStripCharFilterFactory;
import org.elasticsearch.analysis.common.HyphenationCompoundWordTokenFilterFactory;
import org.elasticsearch.analysis.common.IndicNormalizationFilterFactory;
import org.elasticsearch.analysis.common.KStemTokenFilterFactory;
import org.elasticsearch.analysis.common.KeepTypesFilterFactory;
import org.elasticsearch.analysis.common.KeepWordFilterFactory;
import org.elasticsearch.analysis.common.KeywordMarkerTokenFilterFactory;
import org.elasticsearch.analysis.common.LegacyDelimitedPayloadTokenFilterFactory;
import org.elasticsearch.analysis.common.LengthTokenFilterFactory;
import org.elasticsearch.analysis.common.LimitTokenCountFilterFactory;
import org.elasticsearch.analysis.common.LowerCaseTokenFilterFactory;
import org.elasticsearch.analysis.common.MappingCharFilterFactory;
import org.elasticsearch.analysis.common.MinHashTokenFilterFactory;
import org.elasticsearch.analysis.common.NGramTokenFilterFactory;
import org.elasticsearch.analysis.common.PatternCaptureGroupTokenFilterFactory;
import org.elasticsearch.analysis.common.PatternReplaceCharFilterFactory;
import org.elasticsearch.analysis.common.PatternReplaceTokenFilterFactory;
import org.elasticsearch.analysis.common.PersianNormalizationFilterFactory;
import org.elasticsearch.analysis.common.PorterStemTokenFilterFactory;
import org.elasticsearch.analysis.common.ReverseTokenFilterFactory;
import org.elasticsearch.analysis.common.RussianStemTokenFilterFactory;
import org.elasticsearch.analysis.common.ScandinavianFoldingFilterFactory;
import org.elasticsearch.analysis.common.ScandinavianNormalizationFilterFactory;
import org.elasticsearch.analysis.common.SerbianNormalizationFilterFactory;
import org.elasticsearch.analysis.common.SimplePatternSplitTokenizerFactory;
import org.elasticsearch.analysis.common.SimplePatternTokenizerFactory;
import org.elasticsearch.analysis.common.SnowballTokenFilterFactory;
import org.elasticsearch.analysis.common.StemmerOverrideTokenFilterFactory;
import org.elasticsearch.analysis.common.StemmerTokenFilterFactory;
import org.elasticsearch.analysis.common.TrimTokenFilterFactory;
import org.elasticsearch.analysis.common.TruncateTokenFilterFactory;
import org.elasticsearch.analysis.common.UniqueTokenFilter;
import org.elasticsearch.analysis.common.UniqueTokenFilterFactory;
import org.elasticsearch.analysis.common.UpperCaseTokenFilterFactory;
import org.elasticsearch.analysis.common.WordDelimiterGraphTokenFilterFactory;
import org.elasticsearch.analysis.common.WordDelimiterTokenFilterFactory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.PreConfiguredCharFilter;
import org.elasticsearch.index.analysis.PreConfiguredTokenFilter;
import org.elasticsearch.index.analysis.PreConfiguredTokenizer;
import org.elasticsearch.index.analysis.SoraniNormalizationFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.plugins.AnalysisPlugin;
import org.elasticsearch.plugins.Plugin;
import org.tartarus.snowball.SnowballProgram;
import org.tartarus.snowball.ext.DutchStemmer;
import org.tartarus.snowball.ext.FrenchStemmer;

public class CommonAnalysisPlugin
extends Plugin
implements AnalysisPlugin {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(CommonAnalysisPlugin.class));

    public Map<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>> getTokenFilters() {
        TreeMap<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>> filters = new TreeMap<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>>();
        filters.put("apostrophe", ApostropheFilterFactory::new);
        filters.put("arabic_normalization", ArabicNormalizationFilterFactory::new);
        filters.put("arabic_stem", ArabicStemTokenFilterFactory::new);
        filters.put("asciifolding", ASCIIFoldingTokenFilterFactory::new);
        filters.put("bengali_normalization", BengaliNormalizationFilterFactory::new);
        filters.put("brazilian_stem", BrazilianStemTokenFilterFactory::new);
        filters.put("cjk_bigram", CJKBigramFilterFactory::new);
        filters.put("cjk_width", CJKWidthFilterFactory::new);
        filters.put("classic", ClassicFilterFactory::new);
        filters.put("czech_stem", CzechStemTokenFilterFactory::new);
        filters.put("common_grams", AnalysisPlugin.requriesAnalysisSettings(CommonGramsTokenFilterFactory::new));
        filters.put("decimal_digit", DecimalDigitFilterFactory::new);
        filters.put("delimited_payload_filter", LegacyDelimitedPayloadTokenFilterFactory::new);
        filters.put("delimited_payload", DelimitedPayloadTokenFilterFactory::new);
        filters.put("dictionary_decompounder", AnalysisPlugin.requriesAnalysisSettings(DictionaryCompoundWordTokenFilterFactory::new));
        filters.put("dutch_stem", DutchStemTokenFilterFactory::new);
        filters.put("edge_ngram", EdgeNGramTokenFilterFactory::new);
        filters.put("edgeNGram", EdgeNGramTokenFilterFactory::new);
        filters.put("elision", ElisionTokenFilterFactory::new);
        filters.put("fingerprint", FingerprintTokenFilterFactory::new);
        filters.put("flatten_graph", FlattenGraphTokenFilterFactory::new);
        filters.put("french_stem", FrenchStemTokenFilterFactory::new);
        filters.put("german_normalization", GermanNormalizationFilterFactory::new);
        filters.put("german_stem", GermanStemTokenFilterFactory::new);
        filters.put("hindi_normalization", HindiNormalizationFilterFactory::new);
        filters.put("hyphenation_decompounder", AnalysisPlugin.requriesAnalysisSettings(HyphenationCompoundWordTokenFilterFactory::new));
        filters.put("indic_normalization", IndicNormalizationFilterFactory::new);
        filters.put("keep", AnalysisPlugin.requriesAnalysisSettings(KeepWordFilterFactory::new));
        filters.put("keep_types", AnalysisPlugin.requriesAnalysisSettings(KeepTypesFilterFactory::new));
        filters.put("keyword_marker", AnalysisPlugin.requriesAnalysisSettings(KeywordMarkerTokenFilterFactory::new));
        filters.put("kstem", KStemTokenFilterFactory::new);
        filters.put("length", LengthTokenFilterFactory::new);
        filters.put("limit", LimitTokenCountFilterFactory::new);
        filters.put("lowercase", LowerCaseTokenFilterFactory::new);
        filters.put("min_hash", MinHashTokenFilterFactory::new);
        filters.put("ngram", NGramTokenFilterFactory::new);
        filters.put("nGram", NGramTokenFilterFactory::new);
        filters.put("pattern_capture", AnalysisPlugin.requriesAnalysisSettings(PatternCaptureGroupTokenFilterFactory::new));
        filters.put("pattern_replace", AnalysisPlugin.requriesAnalysisSettings(PatternReplaceTokenFilterFactory::new));
        filters.put("persian_normalization", PersianNormalizationFilterFactory::new);
        filters.put("porter_stem", PorterStemTokenFilterFactory::new);
        filters.put("reverse", ReverseTokenFilterFactory::new);
        filters.put("russian_stem", RussianStemTokenFilterFactory::new);
        filters.put("scandinavian_folding", ScandinavianFoldingFilterFactory::new);
        filters.put("scandinavian_normalization", ScandinavianNormalizationFilterFactory::new);
        filters.put("serbian_normalization", SerbianNormalizationFilterFactory::new);
        filters.put("snowball", SnowballTokenFilterFactory::new);
        filters.put("sorani_normalization", SoraniNormalizationFilterFactory::new);
        filters.put("stemmer_override", AnalysisPlugin.requriesAnalysisSettings(StemmerOverrideTokenFilterFactory::new));
        filters.put("stemmer", StemmerTokenFilterFactory::new);
        filters.put("trim", TrimTokenFilterFactory::new);
        filters.put("truncate", AnalysisPlugin.requriesAnalysisSettings(TruncateTokenFilterFactory::new));
        filters.put("unique", UniqueTokenFilterFactory::new);
        filters.put("uppercase", UpperCaseTokenFilterFactory::new);
        filters.put("word_delimiter_graph", WordDelimiterGraphTokenFilterFactory::new);
        filters.put("word_delimiter", WordDelimiterTokenFilterFactory::new);
        return filters;
    }

    public Map<String, AnalysisModule.AnalysisProvider<CharFilterFactory>> getCharFilters() {
        TreeMap<String, AnalysisModule.AnalysisProvider<CharFilterFactory>> filters = new TreeMap<String, AnalysisModule.AnalysisProvider<CharFilterFactory>>();
        filters.put("html_strip", HtmlStripCharFilterFactory::new);
        filters.put("pattern_replace", AnalysisPlugin.requriesAnalysisSettings(PatternReplaceCharFilterFactory::new));
        filters.put("mapping", AnalysisPlugin.requriesAnalysisSettings(MappingCharFilterFactory::new));
        return filters;
    }

    public Map<String, AnalysisModule.AnalysisProvider<TokenizerFactory>> getTokenizers() {
        TreeMap<String, AnalysisModule.AnalysisProvider<TokenizerFactory>> tokenizers = new TreeMap<String, AnalysisModule.AnalysisProvider<TokenizerFactory>>();
        tokenizers.put("simple_pattern", SimplePatternTokenizerFactory::new);
        tokenizers.put("simple_pattern_split", SimplePatternSplitTokenizerFactory::new);
        return tokenizers;
    }

    public List<PreConfiguredCharFilter> getPreConfiguredCharFilters() {
        ArrayList<PreConfiguredCharFilter> filters = new ArrayList<PreConfiguredCharFilter>();
        filters.add(PreConfiguredCharFilter.singleton((String)"html_strip", (boolean)false, HTMLStripCharFilter::new));
        filters.add(PreConfiguredCharFilter.singletonWithVersion((String)"htmlStrip", (boolean)false, (reader, version) -> {
            if (version.onOrAfter(Version.V_6_3_0)) {
                DEPRECATION_LOGGER.deprecatedAndMaybeLog("htmlStrip_deprecation", "The [htmpStrip] char filter name is deprecated and will be removed in a future version. Please change the filter name to [html_strip] instead.", new Object[0]);
            }
            return new HTMLStripCharFilter(reader);
        }));
        return filters;
    }

    public List<PreConfiguredTokenFilter> getPreConfiguredTokenFilters() {
        ArrayList<PreConfiguredTokenFilter> filters = new ArrayList<PreConfiguredTokenFilter>();
        filters.add(PreConfiguredTokenFilter.singleton((String)"apostrophe", (boolean)false, ApostropheFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"arabic_normalization", (boolean)true, ArabicNormalizationFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"arabic_stem", (boolean)false, ArabicStemFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"asciifolding", (boolean)true, ASCIIFoldingFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"bengali_normalization", (boolean)true, BengaliNormalizationFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"brazilian_stem", (boolean)false, BrazilianStemFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"cjk_bigram", (boolean)false, CJKBigramFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"cjk_width", (boolean)true, CJKWidthFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"classic", (boolean)false, ClassicFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"common_grams", (boolean)false, input -> new CommonGramsFilter(input, CharArraySet.EMPTY_SET)));
        filters.add(PreConfiguredTokenFilter.singleton((String)"czech_stem", (boolean)false, CzechStemFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"decimal_digit", (boolean)true, DecimalDigitFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"delimited_payload_filter", (boolean)false, input -> new DelimitedPayloadTokenFilter(input, '|', DelimitedPayloadTokenFilterFactory.DEFAULT_ENCODER)));
        filters.add(PreConfiguredTokenFilter.singleton((String)"delimited_payload", (boolean)false, input -> new DelimitedPayloadTokenFilter(input, '|', DelimitedPayloadTokenFilterFactory.DEFAULT_ENCODER)));
        filters.add(PreConfiguredTokenFilter.singleton((String)"dutch_stem", (boolean)false, input -> new SnowballFilter(input, (SnowballProgram)new DutchStemmer())));
        filters.add(PreConfiguredTokenFilter.singleton((String)"edge_ngram", (boolean)false, input -> new EdgeNGramTokenFilter(input, 1, 1)));
        filters.add(PreConfiguredTokenFilter.singleton((String)"edgeNGram", (boolean)false, input -> new EdgeNGramTokenFilter(input, 1, 1)));
        filters.add(PreConfiguredTokenFilter.singleton((String)"elision", (boolean)true, input -> new ElisionFilter(input, FrenchAnalyzer.DEFAULT_ARTICLES)));
        filters.add(PreConfiguredTokenFilter.singleton((String)"french_stem", (boolean)false, input -> new SnowballFilter(input, (SnowballProgram)new FrenchStemmer())));
        filters.add(PreConfiguredTokenFilter.singleton((String)"german_normalization", (boolean)true, GermanNormalizationFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"german_stem", (boolean)false, GermanStemFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"hindi_normalization", (boolean)true, HindiNormalizationFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"indic_normalization", (boolean)true, IndicNormalizationFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"keyword_repeat", (boolean)false, KeywordRepeatFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"kstem", (boolean)false, KStemFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"length", (boolean)false, input -> new LengthFilter(input, 0, Integer.MAX_VALUE)));
        filters.add(PreConfiguredTokenFilter.singleton((String)"limit", (boolean)false, input -> new LimitTokenCountFilter(input, 1, false)));
        filters.add(PreConfiguredTokenFilter.singleton((String)"ngram", (boolean)false, NGramTokenFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"nGram", (boolean)false, NGramTokenFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"persian_normalization", (boolean)true, PersianNormalizationFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"porter_stem", (boolean)false, PorterStemFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"reverse", (boolean)false, ReverseStringFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"russian_stem", (boolean)false, input -> new SnowballFilter(input, "Russian")));
        filters.add(PreConfiguredTokenFilter.singleton((String)"scandinavian_folding", (boolean)true, ScandinavianFoldingFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"scandinavian_normalization", (boolean)true, ScandinavianNormalizationFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"shingle", (boolean)false, input -> {
            ShingleFilter ts = new ShingleFilter(input);
            ts.addAttribute(DisableGraphAttribute.class);
            return ts;
        }));
        filters.add(PreConfiguredTokenFilter.singleton((String)"snowball", (boolean)false, input -> new SnowballFilter(input, "English")));
        filters.add(PreConfiguredTokenFilter.singleton((String)"sorani_normalization", (boolean)true, SoraniNormalizationFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"stemmer", (boolean)false, PorterStemFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"stop", (boolean)false, input -> new StopFilter(input, StopAnalyzer.ENGLISH_STOP_WORDS_SET)));
        filters.add(PreConfiguredTokenFilter.singleton((String)"trim", (boolean)true, TrimFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"truncate", (boolean)false, input -> new TruncateTokenFilter(input, 10)));
        filters.add(PreConfiguredTokenFilter.singleton((String)"type_as_payload", (boolean)false, TypeAsPayloadTokenFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"unique", (boolean)false, UniqueTokenFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"uppercase", (boolean)true, UpperCaseFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton((String)"word_delimiter", (boolean)false, input -> new WordDelimiterFilter(input, 451, null)));
        filters.add(PreConfiguredTokenFilter.singleton((String)"word_delimiter_graph", (boolean)false, input -> new WordDelimiterGraphFilter(input, 451, null)));
        return filters;
    }

    public List<PreConfiguredTokenizer> getPreConfiguredTokenizers() {
        ArrayList<PreConfiguredTokenizer> tokenizers = new ArrayList<PreConfiguredTokenizer>();
        tokenizers.add(PreConfiguredTokenizer.singleton((String)"keyword", KeywordTokenizer::new, null));
        tokenizers.add(PreConfiguredTokenizer.singleton((String)"lowercase", LowerCaseTokenizer::new, () -> new TokenFilterFactory(){

            public String name() {
                return "lowercase";
            }

            public TokenStream create(TokenStream tokenStream) {
                return new LowerCaseFilter(tokenStream);
            }
        }));
        return tokenizers;
    }
}

