/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.condition;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.xpack.core.watcher.condition.Condition;
import org.elasticsearch.xpack.core.watcher.condition.ExecutableCondition;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.core.watcher.support.Exceptions;
import org.elasticsearch.xpack.watcher.Watcher;
import org.elasticsearch.xpack.watcher.support.Variables;

public final class ScriptCondition
implements ExecutableCondition {
    public static final String TYPE = "script";
    private static final Condition.Result MET = new Condition.Result(null, "script", true);
    private static final Condition.Result UNMET = new Condition.Result(null, "script", false);
    private final ScriptService scriptService;
    private final Script script;
    private final ExecutableScript.Factory scriptFactory;

    public ScriptCondition(Script script) {
        this.script = script;
        this.scriptService = null;
        this.scriptFactory = null;
    }

    ScriptCondition(Script script, ScriptService scriptService) {
        this.scriptService = scriptService;
        this.script = script;
        this.scriptFactory = (ExecutableScript.Factory)scriptService.compile(script, Watcher.SCRIPT_EXECUTABLE_CONTEXT);
    }

    public Script getScript() {
        return this.script;
    }

    public static ScriptCondition parse(ScriptService scriptService, String watchId, XContentParser parser) throws IOException {
        try {
            Script script = Script.parse((XContentParser)parser);
            return new ScriptCondition(script, scriptService);
        }
        catch (ElasticsearchParseException pe) {
            throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. failed to parse script", (Throwable)pe, new Object[]{TYPE, watchId});
        }
    }

    public Condition.Result execute(WatchExecutionContext ctx) {
        return this.doExecute(ctx);
    }

    public Condition.Result doExecute(WatchExecutionContext ctx) {
        ExecutableScript executable;
        Object value;
        Map<String, Object> parameters = Variables.createCtxModel(ctx, ctx.payload());
        if (this.script.getParams() != null && !this.script.getParams().isEmpty()) {
            parameters.putAll(this.script.getParams());
        }
        if ((value = (executable = this.scriptFactory.newInstance(parameters)).run()) instanceof Boolean) {
            return (Boolean)value != false ? MET : UNMET;
        }
        throw Exceptions.illegalState((String)"condition [{}] must return a boolean value (true|false) but instead returned [{}]", (Object[])new Object[]{this.type(), ctx.watch().id(), this.script, value});
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.script.toXContent(builder, params);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptCondition condition = (ScriptCondition)o;
        return this.script.equals((Object)condition.script);
    }

    public int hashCode() {
        return this.script.hashCode();
    }

    public String type() {
        return TYPE;
    }
}

