/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.xpack.core.common.IteratingActionListener;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringDoc;
import org.elasticsearch.xpack.monitoring.exporter.ExportException;

public abstract class ExportBulk {
    protected final String name;
    protected final ThreadContext threadContext;
    private final AtomicReference<State> state = new AtomicReference<State>(State.INITIALIZING);

    public ExportBulk(String name, ThreadContext threadContext) {
        this.name = Objects.requireNonNull(name);
        this.threadContext = Objects.requireNonNull(threadContext);
    }

    public String getName() {
        return this.name;
    }

    public void add(Collection<MonitoringDoc> docs) throws ExportException {
        if (this.state.get() == State.INITIALIZING) {
            this.doAdd(docs);
        }
    }

    protected abstract void doAdd(Collection<MonitoringDoc> var1) throws ExportException;

    public void flush(ActionListener<Void> listener) {
        if (this.state.compareAndSet(State.INITIALIZING, State.FLUSHING)) {
            this.doFlush(listener);
        } else {
            listener.onResponse(null);
        }
    }

    protected abstract void doFlush(ActionListener<Void> var1);

    public void close(boolean flush, ActionListener<Void> listener) {
        if (this.state.getAndSet(State.CLOSED) != State.CLOSED) {
            if (flush) {
                this.flushAndClose(listener);
            } else {
                this.doClose(listener);
            }
        } else {
            listener.onResponse(null);
        }
    }

    private void flushAndClose(final ActionListener<Void> listener) {
        this.doFlush(new ActionListener<Void>(){

            public void onResponse(Void aVoid) {
                ExportBulk.this.doClose((ActionListener<Void>)listener);
            }

            public void onFailure(final Exception e) {
                ExportBulk.this.doClose(new ActionListener<Void>(){
                    private final ExportException exportException;
                    {
                        this.exportException = new ExportException("Exception when closing export bulk", e, new Object[0]);
                    }

                    public void onResponse(Void aVoid) {
                        listener.onFailure((Exception)((Object)this.exportException));
                    }

                    public void onFailure(Exception e2) {
                        this.exportException.addSuppressed(e2);
                        listener.onFailure((Exception)((Object)this.exportException));
                    }
                });
            }
        });
    }

    protected abstract void doClose(ActionListener<Void> var1);

    protected boolean isClosed() {
        return this.state.get() == State.CLOSED;
    }

    private static enum State {
        INITIALIZING,
        FLUSHING,
        CLOSED;

    }

    public static class Compound
    extends ExportBulk {
        private final List<ExportBulk> bulks;

        public Compound(List<ExportBulk> bulks, ThreadContext threadContext) {
            super("all", threadContext);
            this.bulks = bulks;
        }

        @Override
        protected void doAdd(Collection<MonitoringDoc> docs) throws ExportException {
            ExportException exception = null;
            for (ExportBulk bulk : this.bulks) {
                try {
                    bulk.add(docs);
                }
                catch (ExportException e) {
                    if (exception == null) {
                        exception = new ExportException("failed to add documents to export bulks", new Object[0]);
                    }
                    exception.addExportException(e);
                }
            }
            if (exception != null) {
                throw exception;
            }
        }

        @Override
        protected void doFlush(ActionListener<Void> listener) {
            SetOnce exceptionRef = new SetOnce();
            BiConsumer<ExportBulk, ActionListener> bulkBiConsumer = (exportBulk, iteratingListener) -> exportBulk.flush((ActionListener<Void>)ActionListener.wrap(arg_0 -> ((ActionListener)iteratingListener).onResponse(arg_0), e -> {
                if (exceptionRef.get() == null) {
                    exceptionRef.set((Object)new ExportException("failed to flush export bulks", (Throwable)e, new Object[0]));
                } else if (e instanceof ExportException) {
                    ((ExportException)exceptionRef.get()).addExportException((ExportException)((Object)e));
                } else {
                    ((ExportException)exceptionRef.get()).addSuppressed((Throwable)e);
                }
                iteratingListener.onResponse(null);
            }));
            IteratingActionListener iteratingActionListener = new IteratingActionListener(Compound.newExceptionHandlingListener((SetOnce<ExportException>)exceptionRef, listener), bulkBiConsumer, this.bulks, this.threadContext);
            iteratingActionListener.run();
        }

        @Override
        protected void doClose(ActionListener<Void> listener) {
            SetOnce exceptionRef = new SetOnce();
            BiConsumer<ExportBulk, ActionListener> bulkBiConsumer = (exportBulk, iteratingListener) -> exportBulk.doClose((ActionListener<Void>)ActionListener.wrap(arg_0 -> ((ActionListener)iteratingListener).onResponse(arg_0), e -> {
                if (exceptionRef.get() == null) {
                    exceptionRef.set((Object)new ExportException("failed to close export bulks", (Throwable)e, new Object[0]));
                } else if (e instanceof ExportException) {
                    ((ExportException)exceptionRef.get()).addExportException((ExportException)((Object)e));
                } else {
                    ((ExportException)exceptionRef.get()).addSuppressed((Throwable)e);
                }
                iteratingListener.onResponse(null);
            }));
            IteratingActionListener iteratingActionListener = new IteratingActionListener(Compound.newExceptionHandlingListener((SetOnce<ExportException>)exceptionRef, listener), bulkBiConsumer, this.bulks, this.threadContext);
            iteratingActionListener.run();
        }

        private static ActionListener<Void> newExceptionHandlingListener(final SetOnce<ExportException> exceptionRef, final ActionListener<Void> listener) {
            return new ActionListener<Void>(){

                public void onResponse(Void aVoid) {
                    if (exceptionRef.get() == null) {
                        listener.onResponse(null);
                    } else {
                        listener.onFailure((Exception)exceptionRef.get());
                    }
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            };
        }
    }
}

