/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.http;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.core.monitoring.MonitoredSystem;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringDoc;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringTemplateUtils;
import org.elasticsearch.xpack.monitoring.exporter.ExportBulk;
import org.elasticsearch.xpack.monitoring.exporter.ExportException;
import org.elasticsearch.xpack.monitoring.exporter.http.HttpExportBulkResponseListener;
import org.joda.time.format.DateTimeFormatter;

class HttpExportBulk
extends ExportBulk {
    private static final Logger logger = Loggers.getLogger(HttpExportBulk.class);
    private final RestClient client;
    private final Map<String, String> params;
    private final DateTimeFormatter formatter;
    private byte[] payload = null;

    HttpExportBulk(String name, RestClient client, Map<String, String> parameters, DateTimeFormatter dateTimeFormatter, ThreadContext threadContext) {
        super(name, threadContext);
        this.client = client;
        this.params = parameters;
        this.formatter = dateTimeFormatter;
    }

    @Override
    public void doAdd(Collection<MonitoringDoc> docs) throws ExportException {
        block8: {
            try {
                if (docs == null || docs.isEmpty()) break block8;
                try (BytesStreamOutput payload = new BytesStreamOutput();){
                    for (MonitoringDoc monitoringDoc : docs) {
                        payload.write(this.toBulkBytes(monitoringDoc));
                    }
                    this.payload = BytesReference.toBytes((BytesReference)payload.bytes());
                }
            }
            catch (Exception e) {
                throw new ExportException("failed to add documents to export bulk [{}]", e, this.name);
            }
        }
    }

    @Override
    public void doFlush(final ActionListener<Void> listener) throws ExportException {
        if (this.payload == null) {
            listener.onFailure((Exception)((Object)new ExportException("unable to send documents because none were loaded for export bulk [{}]", this.name)));
        } else if (this.payload.length != 0) {
            ByteArrayEntity body = new ByteArrayEntity(this.payload, ContentType.APPLICATION_JSON);
            this.client.performRequestAsync("POST", "/_bulk", this.params, (HttpEntity)body, new ResponseListener(){

                public void onSuccess(Response response) {
                    try {
                        HttpExportBulkResponseListener.INSTANCE.onSuccess(response);
                    }
                    finally {
                        listener.onResponse(null);
                    }
                }

                public void onFailure(Exception exception) {
                    try {
                        HttpExportBulkResponseListener.INSTANCE.onFailure(exception);
                    }
                    finally {
                        listener.onFailure(exception);
                    }
                }
            }, new Header[0]);
        }
    }

    @Override
    protected void doClose(ActionListener<Void> listener) {
        listener.onResponse(null);
    }

    private byte[] toBulkBytes(MonitoringDoc doc) throws IOException {
        Object object;
        XContentType xContentType = XContentType.JSON;
        XContent xContent = xContentType.xContent();
        String index = MonitoringTemplateUtils.indexName((DateTimeFormatter)this.formatter, (MonitoredSystem)doc.getSystem(), (long)doc.getTimestamp());
        String id = doc.getId();
        BytesStreamOutput out = new BytesStreamOutput();
        Throwable throwable = null;
        try {
            object = null;
            try (XContentBuilder builder = new XContentBuilder(xContent, (OutputStream)out);){
                builder.startObject();
                builder.startObject("index");
                builder.field("_index", index);
                builder.field("_type", "doc");
                if (id != null) {
                    builder.field("_id", id);
                }
                builder.endObject();
                builder.endObject();
            }
            catch (Throwable throwable2) {
                object = throwable2;
                throw throwable2;
            }
            out.write((int)xContent.streamSeparator());
            BytesRef source = XContentHelper.toXContent((ToXContent)doc, (XContentType)xContentType, (boolean)false).toBytesRef();
            out.write(source.bytes, source.offset, source.length);
            out.write((int)xContent.streamSeparator());
            logger.trace("added index request [index={}, type={}, id={}]", (Object)index, (Object)doc.getType(), (Object)id);
            object = BytesReference.toBytes((BytesReference)out.bytes());
        }
        catch (Throwable throwable3) {
            try {
                try {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    HttpExportBulk.$closeResource(throwable, (AutoCloseable)out);
                    throw throwable4;
                }
            }
            catch (Exception e) {
                logger.warn(() -> new ParameterizedMessage("failed to render document [{}], skipping it [{}]", (Object)doc, (Object)this.name), (Throwable)e);
                return BytesRef.EMPTY_BYTES;
            }
        }
        HttpExportBulk.$closeResource(throwable, (AutoCloseable)out);
        return object;
    }
}

