/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.asn1;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1Messages;
import com.unboundid.util.ByteString;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ASN1OctetString
extends ASN1Element
implements ByteString {
    private static final long serialVersionUID = -7857753188341295516L;
    private byte[] valueBytes;
    private volatile byte[] valueBytesGuard;
    private int length;
    private int offset;
    private String stringValue;

    public ASN1OctetString() {
        super((byte)4);
        this.valueBytes = StaticUtils.NO_BYTES;
        this.stringValue = "";
        this.offset = 0;
        this.length = 0;
    }

    public ASN1OctetString(byte type) {
        super(type);
        this.valueBytes = StaticUtils.NO_BYTES;
        this.stringValue = "";
        this.offset = 0;
        this.length = 0;
    }

    public ASN1OctetString(byte[] value) {
        super((byte)4);
        if (value == null) {
            this.valueBytes = StaticUtils.NO_BYTES;
            this.stringValue = "";
            this.offset = 0;
            this.length = 0;
        } else {
            this.valueBytes = value;
            this.stringValue = null;
            this.offset = 0;
            this.length = value.length;
        }
    }

    public ASN1OctetString(byte[] value, int offset, int length) {
        super((byte)4);
        Validator.ensureNotNull(value);
        Validator.ensureTrue(offset >= 0 && length >= 0 && offset + length <= value.length);
        this.valueBytes = value;
        this.stringValue = null;
        this.offset = offset;
        this.length = length;
    }

    public ASN1OctetString(byte type, byte[] value) {
        super(type);
        if (value == null) {
            this.valueBytes = StaticUtils.NO_BYTES;
            this.stringValue = "";
            this.offset = 0;
            this.length = 0;
        } else {
            this.valueBytes = value;
            this.stringValue = null;
            this.offset = 0;
            this.length = value.length;
        }
    }

    public ASN1OctetString(byte type, byte[] value, int offset, int length) {
        super(type);
        Validator.ensureTrue(offset >= 0 && length >= 0 && offset + length <= value.length);
        this.valueBytes = value;
        this.stringValue = null;
        this.offset = offset;
        this.length = length;
    }

    public ASN1OctetString(String value) {
        super((byte)4);
        if (value == null) {
            this.valueBytes = StaticUtils.NO_BYTES;
            this.stringValue = "";
            this.offset = 0;
            this.length = 0;
        } else {
            this.valueBytes = null;
            this.stringValue = value;
            this.offset = -1;
            this.length = -1;
        }
    }

    public ASN1OctetString(byte type, String value) {
        super(type);
        if (value == null) {
            this.valueBytes = StaticUtils.NO_BYTES;
            this.stringValue = "";
            this.offset = 0;
            this.length = 0;
        } else {
            this.valueBytes = null;
            this.stringValue = value;
            this.offset = -1;
            this.length = -1;
        }
    }

    byte[] getValueArray() {
        return this.getValue();
    }

    int getValueOffset() {
        return 0;
    }

    public int getValueLength() {
        return this.getValue().length;
    }

    public byte[] getValue() {
        if (this.valueBytes == null) {
            this.valueBytesGuard = StaticUtils.getBytes(this.stringValue);
            this.offset = 0;
            this.length = this.valueBytesGuard.length;
            this.valueBytes = this.valueBytesGuard;
        } else if (this.offset != 0 || this.length != this.valueBytes.length) {
            byte[] newArray = new byte[this.length];
            System.arraycopy(this.valueBytes, this.offset, newArray, 0, this.length);
            this.offset = 0;
            this.valueBytesGuard = newArray;
            this.valueBytes = this.valueBytesGuard;
        }
        return this.valueBytes;
    }

    public void encodeTo(ByteStringBuffer buffer) {
        buffer.append(this.getType());
        if (this.valueBytes == null) {
            int stringLength = this.stringValue.length();
            int lengthStartPos = buffer.length();
            ASN1OctetString.encodeLengthTo(stringLength, buffer);
            int valueStartPos = buffer.length();
            buffer.append(this.stringValue);
            int stringBytesLength = buffer.length() - valueStartPos;
            if (stringBytesLength != stringLength) {
                byte[] newLengthBytes = ASN1OctetString.encodeLength(stringBytesLength);
                if (newLengthBytes.length == valueStartPos - lengthStartPos) {
                    System.arraycopy(newLengthBytes, 0, buffer.getBackingArray(), lengthStartPos, newLengthBytes.length);
                } else {
                    buffer.setLength(lengthStartPos);
                    buffer.append(newLengthBytes);
                    buffer.append(this.stringValue);
                }
            }
        } else {
            ASN1OctetString.encodeLengthTo(this.length, buffer);
            buffer.append(this.valueBytes, this.offset, this.length);
        }
    }

    public String stringValue() {
        if (this.stringValue == null) {
            this.stringValue = this.length == 0 ? "" : StaticUtils.toUTF8String(this.valueBytes, this.offset, this.length);
        }
        return this.stringValue;
    }

    public static ASN1OctetString decodeAsOctetString(byte[] elementBytes) throws ASN1Exception {
        try {
            int valueStartPos = 2;
            int length = elementBytes[1] & 0x7F;
            if (length != elementBytes[1]) {
                int numLengthBytes = length;
                length = 0;
                for (int i = 0; i < numLengthBytes; ++i) {
                    length <<= 8;
                    length |= elementBytes[valueStartPos++] & 0xFF;
                }
            }
            if (elementBytes.length - valueStartPos != length) {
                throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_LENGTH_MISMATCH.get(length, elementBytes.length - valueStartPos));
            }
            return new ASN1OctetString(elementBytes[0], elementBytes, valueStartPos, length);
        }
        catch (ASN1Exception ae) {
            Debug.debugException(ae);
            throw ae;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_DECODE_EXCEPTION.get(e), e);
        }
    }

    public static ASN1OctetString decodeAsOctetString(ASN1Element element) {
        return new ASN1OctetString(element.getType(), element.getValue());
    }

    public void appendValueTo(ByteStringBuffer buffer) {
        if (this.valueBytes == null) {
            buffer.append(this.stringValue);
        } else {
            buffer.append(this.valueBytes, this.offset, this.length);
        }
    }

    public ASN1OctetString toASN1OctetString() {
        return this;
    }

    public void toString(StringBuilder buffer) {
        buffer.append(this.stringValue());
    }
}

