/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.ToCodeArgHelper;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InternalUseOnly
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ToCodeHelper {
    private ToCodeHelper() {
    }

    public static void generateMethodCall(List<String> lineList, int indentSpaces, String returnType, String variableName, String methodName, ToCodeArgHelper ... methodArgs) {
        ToCodeHelper.generateMethodCall(lineList, indentSpaces, returnType, variableName, methodName, StaticUtils.toList(methodArgs));
    }

    public static void generateMethodCall(List<String> lineList, int indentSpaces, String returnType, String variableName, String methodName, List<ToCodeArgHelper> methodArgs) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < indentSpaces; ++i) {
            buffer.append(' ');
        }
        String indent = buffer.toString();
        if (returnType != null) {
            buffer.append(returnType);
            buffer.append(' ');
        }
        if (variableName != null) {
            buffer.append(variableName);
            buffer.append(" = ");
        }
        buffer.append(methodName);
        buffer.append('(');
        if (methodArgs == null || methodArgs.isEmpty()) {
            buffer.append(");");
            lineList.add(buffer.toString());
        } else {
            lineList.add(buffer.toString());
            Iterator<ToCodeArgHelper> argIterator = methodArgs.iterator();
            while (argIterator.hasNext()) {
                ToCodeArgHelper arg = argIterator.next();
                boolean firstLine = true;
                Iterator<String> argLineIterator = arg.getLines().iterator();
                while (argLineIterator.hasNext()) {
                    buffer.setLength(0);
                    buffer.append(indent);
                    buffer.append("     ");
                    buffer.append(argLineIterator.next());
                    if (!argLineIterator.hasNext()) {
                        if (argIterator.hasNext()) {
                            buffer.append(',');
                        } else {
                            buffer.append(");");
                        }
                    }
                    if (firstLine) {
                        firstLine = false;
                        String comment = arg.getComment();
                        if (comment != null) {
                            buffer.append(" // ");
                            buffer.append(comment);
                        }
                    }
                    lineList.add(buffer.toString());
                }
            }
        }
    }

    public static void generateVariableAssignment(List<String> lineList, int indentSpaces, String dataType, String variableName, ToCodeArgHelper valueArg) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < indentSpaces; ++i) {
            buffer.append(' ');
        }
        String indent = buffer.toString();
        if (dataType != null) {
            buffer.append(dataType);
            buffer.append(' ');
        }
        buffer.append(variableName);
        buffer.append(" = ");
        boolean firstLine = true;
        Iterator<String> valueLineIterator = valueArg.getLines().iterator();
        while (valueLineIterator.hasNext()) {
            String s = valueLineIterator.next();
            if (!firstLine) {
                buffer.setLength(0);
                buffer.append(indent);
            }
            buffer.append(s);
            if (!valueLineIterator.hasNext()) {
                buffer.append(';');
            }
            if (firstLine) {
                firstLine = false;
                String comment = valueArg.getComment();
                if (comment != null) {
                    buffer.append(" // ");
                    buffer.append(comment);
                }
            }
            lineList.add(buffer.toString());
        }
    }
}

