/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.json;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.AuthenticationDetails;
import com.unboundid.util.json.ConnectionOptions;
import com.unboundid.util.json.ConnectionPoolOptions;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONException;
import com.unboundid.util.json.JSONMessages;
import com.unboundid.util.json.JSONNumber;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import com.unboundid.util.json.SecurityOptions;
import com.unboundid.util.json.ServerDetails;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDAPConnectionDetailsJSONSpecification {
    static final String FIELD_AUTHENTICATION_DETAILS = "authentication-details";
    static final String FIELD_COMMUNICATION_SECURITY = "communication-security";
    static final String FIELD_CONNECTION_OPTIONS = "connection-options";
    static final String FIELD_CONNECTION_POOL_OPTIONS = "connection-pool-options";
    static final String FIELD_SERVER_DETAILS = "server-details";
    private final BindRequest bindRequest;
    private final ConnectionPoolOptions connectionPoolOptionsSpec;
    private final SecurityOptions securityOptionsSpec;
    private final ServerSet serverSet;

    public LDAPConnectionDetailsJSONSpecification(JSONObject connectionDetailsObject) throws LDAPException {
        ConnectionOptions connectionOptionsSpec;
        LDAPConnectionDetailsJSONSpecification.validateTopLevelFields(connectionDetailsObject);
        try {
            this.securityOptionsSpec = new SecurityOptions(connectionDetailsObject);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPException(le.getResultCode(), JSONMessages.ERR_LDAP_SPEC_ERROR_PROCESSING_FIELD.get(FIELD_COMMUNICATION_SECURITY, le.getMessage()), le);
        }
        try {
            connectionOptionsSpec = new ConnectionOptions(connectionDetailsObject);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPException(le.getResultCode(), JSONMessages.ERR_LDAP_SPEC_ERROR_PROCESSING_FIELD.get(FIELD_CONNECTION_OPTIONS, le.getMessage()), le);
        }
        try {
            ServerDetails serverDetailsSpec = new ServerDetails(connectionDetailsObject, this.securityOptionsSpec, connectionOptionsSpec);
            this.serverSet = serverDetailsSpec.getServerSet();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPException(le.getResultCode(), JSONMessages.ERR_LDAP_SPEC_ERROR_PROCESSING_FIELD.get(FIELD_SERVER_DETAILS, le.getMessage()), le);
        }
        try {
            AuthenticationDetails authenticationDetailsSpec = new AuthenticationDetails(connectionDetailsObject);
            this.bindRequest = authenticationDetailsSpec.getBindRequest();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPException(le.getResultCode(), JSONMessages.ERR_LDAP_SPEC_ERROR_PROCESSING_FIELD.get(FIELD_AUTHENTICATION_DETAILS, le.getMessage()), le);
        }
        try {
            this.connectionPoolOptionsSpec = new ConnectionPoolOptions(connectionDetailsObject);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPException(le.getResultCode(), JSONMessages.ERR_LDAP_SPEC_ERROR_PROCESSING_FIELD.get(FIELD_CONNECTION_POOL_OPTIONS, le.getMessage()), le);
        }
    }

    public static LDAPConnectionDetailsJSONSpecification fromString(String jsonString) throws JSONException, LDAPException {
        return new LDAPConnectionDetailsJSONSpecification(new JSONObject(jsonString));
    }

    public static LDAPConnectionDetailsJSONSpecification fromFile(String path) throws IOException, JSONException, LDAPException {
        return LDAPConnectionDetailsJSONSpecification.fromFile(new File(path));
    }

    public static LDAPConnectionDetailsJSONSpecification fromFile(File file) throws IOException, JSONException, LDAPException {
        return LDAPConnectionDetailsJSONSpecification.fromInputStream(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LDAPConnectionDetailsJSONSpecification fromInputStream(InputStream inputStream) throws IOException, JSONException, LDAPException {
        LDAPConnectionDetailsJSONSpecification lDAPConnectionDetailsJSONSpecification;
        try {
            int bytesRead;
            ByteStringBuffer b = new ByteStringBuffer();
            byte[] readBuffer = new byte[8192];
            while ((bytesRead = inputStream.read(readBuffer)) >= 0) {
                b.append(readBuffer, 0, bytesRead);
            }
            lDAPConnectionDetailsJSONSpecification = new LDAPConnectionDetailsJSONSpecification(new JSONObject(b.toString()));
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return lDAPConnectionDetailsJSONSpecification;
    }

    public ServerSet getServerSet() {
        return this.serverSet;
    }

    public BindRequest getBindRequest() {
        return this.bindRequest;
    }

    public LDAPConnection createConnection() throws LDAPException {
        LDAPConnection connection = this.createUnauthenticatedConnection();
        if (this.bindRequest != null) {
            try {
                connection.bind(this.bindRequest);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                connection.close();
                throw le;
            }
        }
        return connection;
    }

    public LDAPConnection createUnauthenticatedConnection() throws LDAPException {
        return this.serverSet.getConnection();
    }

    public LDAPConnectionPool createConnectionPool(int initialConnections, int maximumConnections) throws LDAPException {
        LDAPConnectionPool connectionPool = new LDAPConnectionPool(this.serverSet, this.bindRequest, initialConnections, maximumConnections, this.connectionPoolOptionsSpec.getInitialConnectThreads(), this.securityOptionsSpec.getPostConnectProcessor(), false, this.connectionPoolOptionsSpec.getHealthCheck());
        this.connectionPoolOptionsSpec.applyConnectionPoolSettings(connectionPool);
        return connectionPool;
    }

    public LDAPConnectionPool createUnauthenticatedConnectionPool(int initialConnections, int maximumConnections) throws LDAPException {
        LDAPConnectionPool connectionPool = new LDAPConnectionPool(this.serverSet, null, initialConnections, maximumConnections, this.connectionPoolOptionsSpec.getInitialConnectThreads(), this.securityOptionsSpec.getPostConnectProcessor(), false, this.connectionPoolOptionsSpec.getHealthCheck());
        this.connectionPoolOptionsSpec.applyConnectionPoolSettings(connectionPool);
        return connectionPool;
    }

    private static void validateTopLevelFields(JSONObject o) throws LDAPException {
        boolean serverDetailsProvided = false;
        for (String s : o.getFields().keySet()) {
            if (s.equals(FIELD_SERVER_DETAILS)) {
                serverDetailsProvided = true;
                continue;
            }
            if (s.equals(FIELD_CONNECTION_OPTIONS) || s.equals(FIELD_COMMUNICATION_SECURITY) || s.equals(FIELD_AUTHENTICATION_DETAILS) || s.equals(FIELD_CONNECTION_POOL_OPTIONS)) continue;
            throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_UNRECOGNIZED_TOP_LEVEL_FIELD.get(s));
        }
        if (!serverDetailsProvided) {
            throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_MISSING_SERVER_DETAILS.get(FIELD_SERVER_DETAILS));
        }
    }

    static void validateAllowedFields(JSONObject o, String f, String ... a) throws LDAPException {
        HashSet<String> s = new HashSet<String>(Arrays.asList(a));
        for (String n : o.getFields().keySet()) {
            if (s.contains(n)) continue;
            throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_UNRECOGNIZED_FIELD.get(n, f));
        }
    }

    static boolean getBoolean(JSONObject o, String f, boolean d) throws LDAPException {
        JSONValue v = o.getField(f);
        if (v == null) {
            return d;
        }
        if (v instanceof JSONBoolean) {
            return ((JSONBoolean)v).booleanValue();
        }
        throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_VALUE_NOT_BOOLEAN.get(f));
    }

    static Integer getInt(JSONObject o, String f, Integer d, Integer n, Integer x) throws LDAPException {
        JSONValue v = o.getField(f);
        if (v == null) {
            return d;
        }
        if (v instanceof JSONNumber) {
            try {
                int i = ((JSONNumber)v).getValue().intValueExact();
                if (n != null && i < n) {
                    throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_VALUE_BELOW_MIN.get(f, n));
                }
                if (x != null && i > x) {
                    throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_VALUE_ABOVE_MAX.get(f, n));
                }
                return i;
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                throw le;
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_VALUE_NOT_INTEGER.get(f), e);
            }
        }
        throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_VALUE_NOT_INTEGER.get(f));
    }

    static Long getLong(JSONObject o, String f, Long d, Long n, Long x) throws LDAPException {
        JSONValue v = o.getField(f);
        if (v == null) {
            return d;
        }
        if (v instanceof JSONNumber) {
            try {
                long l = ((JSONNumber)v).getValue().longValueExact();
                if (n != null && l < n) {
                    throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_VALUE_BELOW_MIN.get(f, n));
                }
                if (x != null && l > x) {
                    throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_VALUE_ABOVE_MAX.get(f, n));
                }
                return l;
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                throw le;
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_VALUE_NOT_INTEGER.get(f), e);
            }
        }
        throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_VALUE_NOT_INTEGER.get(f));
    }

    static JSONObject getObject(JSONObject o, String f) throws LDAPException {
        JSONValue v = o.getField(f);
        if (v == null) {
            return null;
        }
        if (v instanceof JSONObject) {
            return (JSONObject)v;
        }
        throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_VALUE_NOT_OBJECT.get(f));
    }

    static String getString(JSONObject o, String f, String d) throws LDAPException {
        JSONValue v = o.getField(f);
        if (v == null) {
            return d;
        }
        if (v instanceof JSONString) {
            return ((JSONString)v).stringValue();
        }
        throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_VALUE_NOT_STRING.get(f));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getStringFromFile(String path, String fieldName) throws LDAPException {
        String string;
        BufferedReader r = null;
        try {
            try {
                r = new BufferedReader(new FileReader(path));
                String line = r.readLine();
                if (line == null) {
                    throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_READ_FILE_EMPTY.get(path, fieldName));
                }
                if (r.readLine() != null) {
                    throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_READ_FILE_MULTIPLE_LINES.get(path, fieldName));
                }
                if (line.length() == 0) {
                    throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_READ_FILE_EMPTY_LINE.get(path, fieldName));
                }
                string = line;
                Object var6_7 = null;
                if (r == null) return string;
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                throw le;
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_READ_FILE_ERROR.get(path, fieldName, StaticUtils.getExceptionMessage(e)), e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (r == null) throw throwable;
            try {
                r.close();
                throw throwable;
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            Debug.debugException(e);
            return string;
        }
        r.close();
        return string;
    }

    static void rejectConflictingFields(JSONObject o, String existingField, String ... conflictingFields) throws LDAPException {
        for (String fieldName : conflictingFields) {
            if (o.getField(fieldName) == null) continue;
            throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_CONFLICTING_FIELD.get(fieldName, existingField));
        }
    }

    static void rejectUnresolvedDependency(JSONObject o, String requiredField, String ... dependentFields) throws LDAPException {
        for (String fieldName : dependentFields) {
            if (o.getField(fieldName) == null) continue;
            throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_LDAP_SPEC_MISSING_DEPENDENT_FIELD.get(fieldName, requiredField));
        }
    }
}

