/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.watermark;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.watermark.SubstanceWatermark;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class SubstanceStripeWatermark
implements SubstanceWatermark {
    private static Image watermarkImage = null;

    @Override
    public void drawWatermarkImage(Graphics graphics, Component c, int x, int y, int width, int height) {
        if (!c.isShowing()) {
            return;
        }
        int dx = c.getLocationOnScreen().x;
        int dy = c.getLocationOnScreen().y;
        graphics.drawImage(watermarkImage, x, y, x + width, y + height, x + dx, y + dy, x + dx + width, y + dy + height, null);
    }

    @Override
    public boolean updateWatermarkImage(SubstanceSkin skin) {
        GraphicsDevice[] gds;
        Rectangle virtualBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gds = ge.getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            virtualBounds = virtualBounds.union(gc.getBounds());
        }
        int screenWidth = virtualBounds.width;
        int screenHeight = virtualBounds.height;
        watermarkImage = SubstanceCoreUtilities.getBlankImage(screenWidth, screenHeight);
        Graphics2D graphics = (Graphics2D)watermarkImage.getGraphics().create();
        boolean status = this.drawWatermarkImage(skin, graphics, 0, 0, screenWidth, screenHeight, false);
        graphics.dispose();
        return status;
    }

    @Override
    public void previewWatermark(Graphics g, SubstanceSkin skin, int x, int y, int width, int height) {
        this.drawWatermarkImage(skin, (Graphics2D)g, x, y, width, height, true);
    }

    private boolean drawWatermarkImage(SubstanceSkin skin, Graphics2D graphics, int x, int y, int width, int height, boolean isPreview) {
        int row;
        Color stampColor = null;
        SubstanceColorScheme scheme = skin.getWatermarkColorScheme();
        stampColor = isPreview ? (scheme.isDark() ? Color.lightGray : Color.darkGray) : scheme.getWatermarkStampColor();
        graphics.setColor(stampColor);
        for (row = y; row < y + height; row += 2) {
            graphics.drawLine(x, row, x + width, row);
        }
        if (isPreview) {
            graphics.setColor(Color.gray);
            for (row = y + 1; row < y + height; row += 2) {
                graphics.drawLine(x, row, x + width, row);
            }
        }
        return true;
    }

    @Override
    public String getDisplayName() {
        return "Stripes";
    }

    @Override
    public void dispose() {
        watermarkImage = null;
    }
}

