/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import groovy.lang.Closure;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.internal.WithEstimatedSize;
import org.gradle.api.internal.collections.BroadcastingCollectionEventRegister;
import org.gradle.api.internal.collections.CollectionEventRegister;
import org.gradle.api.internal.collections.CollectionFilter;
import org.gradle.api.internal.collections.ElementSource;
import org.gradle.api.internal.collections.FilteredCollection;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.ImmutableActionSet;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDomainObjectCollection<T>
extends AbstractCollection<T>
implements DomainObjectCollection<T>,
WithEstimatedSize {
    private final Class<? extends T> type;
    private final CollectionEventRegister<T> eventRegister;
    private final ElementSource<T> store;
    private ImmutableActionSet<Void> mutateAction = ImmutableActionSet.empty();

    protected DefaultDomainObjectCollection(Class<? extends T> type, ElementSource<T> store) {
        this(type, store, new BroadcastingCollectionEventRegister<T>(type));
    }

    protected DefaultDomainObjectCollection(Class<? extends T> type, ElementSource<T> store, final CollectionEventRegister<T> eventRegister) {
        this.type = type;
        this.store = store;
        this.eventRegister = eventRegister;
        this.store.onRealize(new Action<ProviderInternal<? extends T>>(){

            public void execute(ProviderInternal<? extends T> provider) {
                DefaultDomainObjectCollection.this.doAdd(provider.get(), eventRegister.getAddActions());
            }
        });
    }

    protected DefaultDomainObjectCollection(DefaultDomainObjectCollection<? super T> collection, CollectionFilter<T> filter) {
        this(filter.getType(), collection.filteredStore(filter), collection.filteredEvents(filter));
    }

    protected void realized(ProviderInternal<? extends T> provider) {
        this.getStore().removePending(provider);
    }

    public Class<? extends T> getType() {
        return this.type;
    }

    protected ElementSource<T> getStore() {
        return this.store;
    }

    protected CollectionEventRegister<T> getEventRegister() {
        return this.eventRegister;
    }

    protected CollectionFilter<T> createFilter(Spec<? super T> filter) {
        return this.createFilter(this.getType(), filter);
    }

    protected <S extends T> CollectionFilter<S> createFilter(Class<S> type) {
        return new CollectionFilter<S>(type);
    }

    protected <S extends T> CollectionFilter<S> createFilter(Class<? extends S> type, Spec<? super S> spec) {
        return new CollectionFilter<S>(type, spec);
    }

    protected <S extends T> DefaultDomainObjectCollection<S> filtered(CollectionFilter<S> filter) {
        return new DefaultDomainObjectCollection<S>(this, filter);
    }

    protected <S extends T> ElementSource<S> filteredStore(CollectionFilter<S> filter) {
        return this.filteredStore(filter, this.store);
    }

    protected <S extends T> ElementSource<S> filteredStore(CollectionFilter<S> filter, ElementSource<T> elementSource) {
        return new FilteredCollection<T, S>(elementSource, filter);
    }

    protected <S extends T> CollectionEventRegister<S> filteredEvents(CollectionFilter<S> filter) {
        return new FlushingEventRegister<S>(filter, this.getEventRegister());
    }

    public DomainObjectCollection<T> matching(Spec<? super T> spec) {
        return this.filtered(this.createFilter(spec));
    }

    public DomainObjectCollection<T> matching(Closure spec) {
        return this.matching(Specs.convertClosureToSpec((Closure)spec));
    }

    public <S extends T> DomainObjectCollection<S> withType(Class<S> type) {
        return this.filtered(this.createFilter(type));
    }

    @Override
    public Iterator<T> iterator() {
        return new IteratorImpl(this.store.iterator());
    }

    Iterator<T> iteratorNoFlush() {
        if (this.store.constantTimeIsEmpty()) {
            return Iterators.emptyIterator();
        }
        return new IteratorImpl(this.store.iteratorNoFlush());
    }

    public void all(Action<? super T> action) {
        action = this.whenObjectAdded(action);
        if (this.store.constantTimeIsEmpty()) {
            return;
        }
        Collection copied = null;
        for (Object t : this) {
            if (copied == null) {
                copied = Lists.newArrayListWithExpectedSize((int)this.estimatedSize());
            }
            copied.add(t);
        }
        if (copied != null) {
            for (Object t : copied) {
                action.execute(t);
            }
        }
    }

    public void configureEach(Action<? super T> action) {
        this.eventRegister.registerLazyAddAction(action);
        Iterator<T> iterator = this.iteratorNoFlush();
        while (iterator.hasNext()) {
            T next = iterator.next();
            action.execute(next);
        }
    }

    public void all(Closure action) {
        this.all(this.toAction(action));
    }

    public <S extends T> DomainObjectCollection<S> withType(Class<S> type, Action<? super S> configureAction) {
        DomainObjectCollection<S> result = this.withType(type);
        result.all(configureAction);
        return result;
    }

    public <S extends T> DomainObjectCollection<S> withType(Class<S> type, Closure configureClosure) {
        DomainObjectCollection<S> result = this.withType(type);
        result.all(configureClosure);
        return result;
    }

    public Action<? super T> whenObjectAdded(Action<? super T> action) {
        this.store.realizePending(this.type);
        this.eventRegister.registerEagerAddAction(this.type, action);
        return action;
    }

    public Action<? super T> whenObjectRemoved(Action<? super T> action) {
        this.eventRegister.registerRemoveAction(this.type, action);
        return action;
    }

    public void whenObjectAdded(Closure action) {
        this.whenObjectAdded(this.toAction(action));
    }

    public void whenObjectRemoved(Closure action) {
        this.whenObjectRemoved(this.toAction(action));
    }

    public void beforeChange(Action<Void> action) {
        this.mutateAction = this.mutateAction.add(action);
    }

    private Action<? super T> toAction(Closure action) {
        return ConfigureUtil.configureUsing(action);
    }

    @Override
    public boolean add(T toAdd) {
        this.assertMutable();
        return this.doAdd((Object)toAdd, (Action)this.eventRegister.getAddActions());
    }

    protected <I extends T> boolean add(I toAdd, Action<? super I> notification) {
        this.assertMutable();
        return this.doAdd(toAdd, notification);
    }

    private <I extends T> boolean doAdd(I toAdd, Action<? super I> notification) {
        if (this.getStore().add(toAdd)) {
            this.didAdd(toAdd);
            notification.execute(toAdd);
            return true;
        }
        return false;
    }

    public void addLater(Provider<? extends T> provider) {
        this.assertMutable();
        ProviderInternal providerInternal = (ProviderInternal)Cast.uncheckedCast(provider);
        if (this.eventRegister.isSubscribed(providerInternal.getType())) {
            this.doAdd((Object)provider.get(), (Action)this.eventRegister.getAddActions());
            return;
        }
        this.store.addPending(providerInternal);
    }

    protected void didAdd(T toAdd) {
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.assertMutable();
        boolean changed = false;
        for (T o : c) {
            if (!this.doAdd((Object)o, (Action)this.eventRegister.getAddActions())) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.assertMutable();
        if (this.store.constantTimeIsEmpty()) {
            return;
        }
        Object[] c = this.toArray();
        this.getStore().clear();
        for (Object o : c) {
            this.eventRegister.fireObjectRemoved(o);
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.getStore().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getStore().containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.getStore().isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        this.assertMutable();
        return this.doRemove(o);
    }

    private boolean doRemove(Object o) {
        if (this.getStore().remove(o)) {
            Object cast = o;
            this.didRemove(cast);
            this.eventRegister.fireObjectRemoved(cast);
            return true;
        }
        return false;
    }

    protected void didRemove(T t) {
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.assertMutable();
        if (this.store.constantTimeIsEmpty()) {
            return false;
        }
        boolean changed = false;
        for (Object o : c) {
            if (!this.doRemove(o)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> target) {
        this.assertMutable();
        Object[] existingItems = this.toArray();
        boolean changed = false;
        for (Object existingItem : existingItems) {
            if (target.contains(existingItem)) continue;
            this.doRemove(existingItem);
            changed = true;
        }
        return changed;
    }

    @Override
    public int size() {
        return this.store.size();
    }

    @Override
    public int estimatedSize() {
        return this.store.estimatedSize();
    }

    public Collection<T> findAll(Closure cl) {
        return this.findAll(cl, new ArrayList());
    }

    protected <S extends Collection<? super T>> S findAll(Closure cl, S matches) {
        if (this.store.constantTimeIsEmpty()) {
            return matches;
        }
        for (T t : this.filteredStore(this.createFilter(Specs.convertClosureToSpec((Closure)cl)))) {
            matches.add(t);
        }
        return matches;
    }

    protected void assertMutable() {
        this.mutateAction.execute(null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FlushingEventRegister<S extends T>
    implements CollectionEventRegister<S> {
        private final CollectionFilter<S> filter;
        private final CollectionEventRegister<S> delegate;

        FlushingEventRegister(CollectionFilter<S> filter, CollectionEventRegister<T> delegate) {
            this.filter = filter;
            this.delegate = (CollectionEventRegister)Cast.uncheckedCast(delegate);
        }

        @Override
        public ImmutableActionSet<S> getAddActions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void fireObjectAdded(S element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void fireObjectRemoved(S element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isSubscribed(Class<?> type) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void registerEagerAddAction(Class<? extends S> type, Action<? super S> addAction) {
            this.delegate.registerEagerAddAction(this.filter.getType(), Actions.filter(addAction, this.filter));
        }

        @Override
        public void registerLazyAddAction(Action<? super S> addAction) {
            this.delegate.registerLazyAddAction(Actions.filter(addAction, this.filter));
        }

        @Override
        public void registerRemoveAction(Class<? extends S> type, Action<? super S> removeAction) {
            this.delegate.registerRemoveAction(this.filter.getType(), Actions.filter(removeAction, this.filter));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class IteratorImpl
    implements Iterator<T>,
    WithEstimatedSize {
        private final Iterator<T> iterator;
        private T currentElement;

        public IteratorImpl(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            this.currentElement = this.iterator.next();
            return this.currentElement;
        }

        @Override
        public void remove() {
            DefaultDomainObjectCollection.this.assertMutable();
            this.iterator.remove();
            DefaultDomainObjectCollection.this.didRemove(this.currentElement);
            DefaultDomainObjectCollection.this.getEventRegister().fireObjectRemoved(this.currentElement);
            this.currentElement = null;
        }

        @Override
        public int estimatedSize() {
            return DefaultDomainObjectCollection.this.estimatedSize();
        }
    }
}

