/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.gradle.api.internal.changedetection.rules.FileChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChangeVisitor;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.TaskFilePropertyCompareStrategy;
import org.gradle.caching.internal.BuildCacheHasher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OrderSensitiveTaskFilePropertyCompareStrategy
implements TaskFilePropertyCompareStrategy.Impl {
    OrderSensitiveTaskFilePropertyCompareStrategy() {
    }

    @Override
    public boolean accept(TaskStateChangeVisitor visitor, Map<String, NormalizedFileSnapshot> currentSnapshots, Map<String, NormalizedFileSnapshot> previousSnapshots, String propertyTitle, boolean pathIsAbsolute, boolean includeAdded) {
        block5: {
            Iterator<Map.Entry<String, NormalizedFileSnapshot>> currentEntries = currentSnapshots.entrySet().iterator();
            Iterator<Map.Entry<String, NormalizedFileSnapshot>> previousEntries = previousSnapshots.entrySet().iterator();
            while (true) {
                if (currentEntries.hasNext()) {
                    Map.Entry<String, NormalizedFileSnapshot> current = currentEntries.next();
                    String currentAbsolutePath = current.getKey();
                    if (previousEntries.hasNext()) {
                        String previousNormalizedPath;
                        Map.Entry<String, NormalizedFileSnapshot> previous = previousEntries.next();
                        NormalizedFileSnapshot currentNormalizedSnapshot = current.getValue();
                        NormalizedFileSnapshot previousNormalizedSnapshot = previous.getValue();
                        String currentNormalizedPath = currentNormalizedSnapshot.getNormalizedPath();
                        if (currentNormalizedPath.equals(previousNormalizedPath = previousNormalizedSnapshot.getNormalizedPath())) {
                            if (currentNormalizedSnapshot.getSnapshot().isContentUpToDate(previousNormalizedSnapshot.getSnapshot()) || visitor.visitChange(FileChange.modified(currentAbsolutePath, propertyTitle, previousNormalizedSnapshot.getSnapshot().getType(), currentNormalizedSnapshot.getSnapshot().getType()))) continue;
                            return false;
                        }
                        String previousAbsolutePath = previous.getKey();
                        if (!visitor.visitChange(FileChange.removed(previousAbsolutePath, propertyTitle, previousNormalizedSnapshot.getSnapshot().getType()))) {
                            return false;
                        }
                        if (!includeAdded || visitor.visitChange(FileChange.added(currentAbsolutePath, propertyTitle, currentNormalizedSnapshot.getSnapshot().getType()))) continue;
                        return false;
                    }
                    if (!includeAdded || visitor.visitChange(FileChange.added(currentAbsolutePath, propertyTitle, current.getValue().getSnapshot().getType()))) continue;
                    return false;
                }
                if (!previousEntries.hasNext()) break block5;
                Map.Entry<String, NormalizedFileSnapshot> previousEntry = previousEntries.next();
                if (!visitor.visitChange(FileChange.removed(previousEntry.getKey(), propertyTitle, previousEntry.getValue().getSnapshot().getType()))) break;
            }
            return false;
        }
        return true;
    }

    @Override
    public void appendToHasher(BuildCacheHasher hasher, Collection<NormalizedFileSnapshot> snapshots) {
        for (NormalizedFileSnapshot normalizedSnapshot : snapshots) {
            normalizedSnapshot.appendToHasher(hasher);
        }
    }
}

