/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.LanguageUtil;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.editor.ex.DocumentEx;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Segment;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiDocumentManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiDocumentManagerBase;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SelfElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;

class FileElementInfo
extends SmartPointerElementInfo {
    private final VirtualFile myVirtualFile;
    private final Project myProject;
    private final Language myLanguage;
    private final Class<? extends PsiFile> myFileClass;

    public FileElementInfo(@NotNull PsiFile file2) {
        if (file2 == null) {
            FileElementInfo.$$$reportNull$$$0(0);
        }
        this.myVirtualFile = file2.getVirtualFile();
        this.myProject = file2.getProject();
        this.myLanguage = LanguageUtil.getRootLanguage(file2);
        this.myFileClass = file2.getClass();
    }

    @Override
    public PsiElement restoreElement() {
        PsiFile file2 = SelfElementInfo.restoreFileFromVirtual(this.myVirtualFile, this.myProject, this.myLanguage);
        return this.myFileClass.isInstance(file2) ? file2 : null;
    }

    @Override
    public PsiFile restoreFile() {
        PsiElement element = this.restoreElement();
        return element == null ? null : element.getContainingFile();
    }

    @Override
    public int elementHashCode() {
        return this.myVirtualFile.hashCode();
    }

    @Override
    public boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other) {
        if (other == null) {
            FileElementInfo.$$$reportNull$$$0(1);
        }
        return other instanceof FileElementInfo && Comparing.equal(this.myVirtualFile, ((FileElementInfo)other).myVirtualFile);
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    @Override
    public Segment getRange() {
        if (!this.myVirtualFile.isValid()) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(this.myVirtualFile);
        return document == null ? null : TextRange.from(0, document.getTextLength());
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            FileElementInfo.$$$reportNull$$$0(2);
        }
        return project;
    }

    @Override
    @Nullable
    public Segment getPsiRange() {
        Document currentDoc = FileDocumentManager.getInstance().getCachedDocument(this.myVirtualFile);
        DocumentEx committedDoc = currentDoc == null ? null : ((PsiDocumentManagerBase)PsiDocumentManager.getInstance(this.myProject)).getLastCommittedDocument(currentDoc);
        return committedDoc == null ? this.getRange() : new TextRange(0, committedDoc.getTextLength());
    }

    public String toString() {
        return "file{" + this.myVirtualFile + ", " + this.myLanguage + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/FileElementInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/FileElementInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "pointsToTheSameElementAs";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

