/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.visitor.OsmPrimitiveVisitor;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class Test
implements OsmPrimitiveVisitor,
Comparable<Test> {
    protected static final Predicate<OsmPrimitive> IN_DOWNLOADED_AREA = new SearchCompiler.NotOutsideDataSourceArea();
    protected static final Predicate<OsmPrimitive> IN_DOWNLOADED_AREA_STRICT = new SearchCompiler.InDataSourceArea(true);
    protected final String name;
    protected final String description;
    public boolean enabled = true;
    protected JCheckBox checkEnabled;
    protected JCheckBox checkBeforeUpload;
    public boolean testBeforeUpload = true;
    protected boolean isBeforeUpload;
    protected List<TestError> errors = new ArrayList<TestError>(30);
    protected boolean partialSelection;
    protected ProgressMonitor progressMonitor;
    protected long startTime;

    public Test(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public Test(String name) {
        this(name, null);
    }

    public void initialize() throws Exception {
        this.startTime = -1L;
    }

    public void startTest(ProgressMonitor progressMonitor) {
        this.progressMonitor = Optional.ofNullable(progressMonitor).orElse(NullProgressMonitor.INSTANCE);
        String startMessage = I18n.tr("Running test {0}", this.name);
        this.progressMonitor.beginTask(startMessage);
        Logging.debug(startMessage);
        this.errors = new ArrayList<TestError>(30);
        this.startTime = System.currentTimeMillis();
    }

    public void setPartialSelection(boolean partialSelection) {
        this.partialSelection = partialSelection;
    }

    public List<TestError> getErrors() {
        return this.errors;
    }

    public void endTest() {
        this.progressMonitor.finishTask();
        this.progressMonitor = null;
        if (this.startTime > 0L) {
            long elapsedTime = Math.max(0L, System.currentTimeMillis() - this.startTime);
            Logging.debug(I18n.tr("Test ''{0}'' completed in {1}", this.getName(), Utils.getDurationString(elapsedTime)));
        }
    }

    public void visit(Collection<OsmPrimitive> selection) {
        if (this.progressMonitor != null) {
            this.progressMonitor.setTicksCount(selection.size());
        }
        for (OsmPrimitive p : selection) {
            if (this.isCanceled()) break;
            if (this.isPrimitiveUsable(p)) {
                p.accept(this);
            }
            if (this.progressMonitor == null) continue;
            this.progressMonitor.worked(1);
        }
    }

    public boolean isPrimitiveUsable(OsmPrimitive p) {
        return p.isUsable() && (!(p instanceof Way) || ((Way)p).getNodesCount() > 1);
    }

    @Override
    public void visit(Node n) {
    }

    @Override
    public void visit(Way w) {
    }

    @Override
    public void visit(Relation r) {
    }

    public void addGui(JPanel testPanel) {
        this.checkEnabled = new JCheckBox(this.name, this.enabled);
        this.checkEnabled.setToolTipText(this.description);
        testPanel.add((Component)this.checkEnabled, GBC.std());
        GBC a = GBC.eol();
        a.anchor = 13;
        this.checkBeforeUpload = new JCheckBox();
        this.checkBeforeUpload.setSelected(this.testBeforeUpload);
        testPanel.add((Component)this.checkBeforeUpload, a);
    }

    public boolean ok() {
        this.enabled = this.checkEnabled.isSelected();
        this.testBeforeUpload = this.checkBeforeUpload.isSelected();
        return false;
    }

    public Command fixError(TestError testError) {
        return null;
    }

    public boolean isFixable(TestError testError) {
        return false;
    }

    public boolean testBeforeUpload() {
        return this.testBeforeUpload;
    }

    public void setBeforeUpload(boolean isUpload) {
        this.isBeforeUpload = isUpload;
    }

    public String getName() {
        return this.name;
    }

    public boolean isCanceled() {
        return this.progressMonitor != null ? this.progressMonitor.isCanceled() : false;
    }

    protected final Command deletePrimitivesIfNeeded(Collection<? extends OsmPrimitive> primitives) {
        ArrayList<OsmPrimitive> primitivesToDelete = new ArrayList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : primitives) {
            if (osmPrimitive.isDeleted()) continue;
            primitivesToDelete.add(osmPrimitive);
        }
        if (!primitivesToDelete.isEmpty()) {
            return DeleteCommand.delete(primitivesToDelete);
        }
        return null;
    }

    protected static final boolean isBuilding(OsmPrimitive p) {
        return p.hasTagDifferent("building", "no", "entrance");
    }

    protected static final boolean isResidentialArea(OsmPrimitive p) {
        return p.hasTag("landuse", "residential");
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Test test = (Test)obj;
        return Objects.equals(this.name, test.name) && Objects.equals(this.description, test.description);
    }

    @Override
    public int compareTo(Test t) {
        return this.name.compareTo(t.name);
    }

    public static abstract class TagTest
    extends Test {
        public TagTest(String name, String description) {
            super(name, description);
        }

        public TagTest(String name) {
            super(name);
        }

        public abstract void check(OsmPrimitive var1);

        @Override
        public void visit(Node n) {
            this.check(n);
        }

        @Override
        public void visit(Way w) {
            this.check(w);
        }

        @Override
        public void visit(Relation r) {
            this.check(r);
        }
    }
}

