/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialog;
import org.openstreetmap.josm.gui.history.HistoryHook;
import org.openstreetmap.josm.gui.history.HistoryLoadTask;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.bugreport.BugReportExceptionHandler;

public final class HistoryBrowserDialogManager
implements LayerManager.LayerChangeListener {
    private static final String WINDOW_GEOMETRY_PREF = HistoryBrowserDialogManager.class.getName() + ".geometry";
    private static HistoryBrowserDialogManager instance;
    private final Map<Long, HistoryBrowserDialog> dialogs;
    private final Predicate<PrimitiveId> unloadedHistoryPredicate = new UnloadedHistoryPredicate();
    private final Predicate<PrimitiveId> notNewPredicate = p -> !p.isNew();
    private static final List<HistoryHook> hooks;

    protected HistoryBrowserDialogManager() {
        this.dialogs = new HashMap<Long, HistoryBrowserDialog>();
        MainApplication.getLayerManager().addLayerChangeListener(this);
    }

    public static synchronized HistoryBrowserDialogManager getInstance() {
        if (instance == null) {
            instance = new HistoryBrowserDialogManager();
        }
        return instance;
    }

    public boolean existsDialog(long id) {
        return this.dialogs.containsKey(id);
    }

    private void show(long id, HistoryBrowserDialog dialog) {
        if (this.dialogs.containsValue(dialog)) {
            this.show(id);
        } else {
            this.placeOnScreen(dialog);
            dialog.setVisible(true);
            this.dialogs.put(id, dialog);
        }
    }

    private void show(long id) {
        if (this.dialogs.containsKey(id)) {
            this.dialogs.get(id).toFront();
        }
    }

    private boolean hasDialogWithCloseUpperLeftCorner(Point p) {
        for (HistoryBrowserDialog dialog : this.dialogs.values()) {
            Point corner = dialog.getLocation();
            if (p.x < corner.x - 5 || corner.x + 5 < p.x || p.y < corner.y - 5 || corner.y + 5 < p.y) continue;
            return true;
        }
        return false;
    }

    private void placeOnScreen(HistoryBrowserDialog dialog) {
        WindowGeometry geometry = new WindowGeometry(WINDOW_GEOMETRY_PREF, WindowGeometry.centerOnScreen(new Dimension(850, 500)));
        geometry.applySafe(dialog);
        Point p = dialog.getLocation();
        while (this.hasDialogWithCloseUpperLeftCorner(p)) {
            p.x += 20;
            p.y += 20;
        }
        dialog.setLocation(p);
    }

    public void hide(HistoryBrowserDialog dialog) {
        Iterator<Map.Entry<Long, HistoryBrowserDialog>> it = this.dialogs.entrySet().iterator();
        while (it.hasNext()) {
            if (!Objects.equals(it.next().getValue(), dialog)) continue;
            it.remove();
            if (!this.dialogs.isEmpty()) break;
            new WindowGeometry(dialog).remember(WINDOW_GEOMETRY_PREF);
            break;
        }
        dialog.setVisible(false);
        dialog.dispose();
    }

    public void hideAll() {
        ArrayList<HistoryBrowserDialog> dialogs = new ArrayList<HistoryBrowserDialog>();
        dialogs.addAll(this.dialogs.values());
        for (HistoryBrowserDialog dialog : dialogs) {
            dialog.unlinkAsListener();
            this.hide(dialog);
        }
    }

    public void show(History h) {
        if (h == null) {
            return;
        }
        if (this.existsDialog(h.getId())) {
            this.show(h.getId());
        } else {
            HistoryBrowserDialog dialog = new HistoryBrowserDialog(h);
            this.show(h.getId(), dialog);
        }
    }

    @Override
    public void layerAdded(LayerManager.LayerAddEvent e) {
    }

    @Override
    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        if (e.getSource().getLayers().isEmpty()) {
            this.hideAll();
        }
    }

    @Override
    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    public static boolean addHistoryHook(HistoryHook hook) {
        return hooks.add(Objects.requireNonNull(hook));
    }

    public static boolean removeHistoryHook(HistoryHook hook) {
        return hooks.remove(Objects.requireNonNull(hook));
    }

    public void showHistory(Collection<? extends PrimitiveId> primitives) {
        ArrayList<? extends PrimitiveId> realPrimitives = new ArrayList<PrimitiveId>(primitives);
        hooks.forEach(h -> h.modifyRequestedIds(realPrimitives));
        SubclassFilteredCollection notNewPrimitives = SubclassFilteredCollection.filter(realPrimitives, this.notNewPredicate);
        if (notNewPrimitives.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least one already uploaded node, way, or relation.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return;
        }
        SubclassFilteredCollection<PrimitiveId, PrimitiveId> toLoad = SubclassFilteredCollection.filter(realPrimitives, this.unloadedHistoryPredicate);
        if (!toLoad.isEmpty()) {
            HistoryLoadTask task = new HistoryLoadTask();
            for (PrimitiveId p : notNewPrimitives) {
                task.add(p);
            }
            MainApplication.worker.submit(task);
        }
        Runnable r = () -> {
            try {
                for (PrimitiveId p : notNewPrimitives) {
                    History h = HistoryDataSet.getInstance().getHistory(p);
                    if (h == null) continue;
                    SwingUtilities.invokeLater(() -> this.show(h));
                }
            }
            catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException e) {
                BugReportExceptionHandler.handleException(e);
            }
        };
        MainApplication.worker.submit(r);
    }

    static {
        hooks = new ArrayList<HistoryHook>();
    }

    static final class UnloadedHistoryPredicate
    implements Predicate<PrimitiveId> {
        private final HistoryDataSet hds = HistoryDataSet.getInstance();

        UnloadedHistoryPredicate() {
        }

        @Override
        public boolean test(PrimitiveId p) {
            History h = this.hds.getHistory(p);
            if (h == null) {
                return true;
            }
            return !p.isNew() && h.getByVersion(p.getUniqueId()) == null;
        }
    }
}

