/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.PluginDownloadException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.xml.sax.SAXException;

public class PluginDownloadTask
extends PleaseWaitRunnable {
    public static final String PLUGIN_MIME_TYPES = "application/java-archive, application/zip; q=0.9, application/octet-stream; q=0.5";
    private final Collection<PluginInformation> toUpdate = new LinkedList<PluginInformation>();
    private final Collection<PluginInformation> failed = new LinkedList<PluginInformation>();
    private final Collection<PluginInformation> downloaded = new LinkedList<PluginInformation>();
    private Exception lastException;
    private boolean canceled;
    private HttpClient downloadConnection;

    public PluginDownloadTask(Component parent, Collection<PluginInformation> toUpdate, String title) {
        super(parent, title == null ? "" : title, false);
        CheckParameterUtil.ensureParameterNotNull(toUpdate, "toUpdate");
        this.toUpdate.addAll(toUpdate);
    }

    public PluginDownloadTask(ProgressMonitor monitor, Collection<PluginInformation> toUpdate, String title) {
        super(title, monitor == null ? NullProgressMonitor.INSTANCE : monitor, false);
        CheckParameterUtil.ensureParameterNotNull(toUpdate, "toUpdate");
        this.toUpdate.addAll(toUpdate);
    }

    public void setPluginsToDownload(Collection<PluginInformation> toUpdate) {
        CheckParameterUtil.ensureParameterNotNull(toUpdate, "toUpdate");
        this.toUpdate.clear();
        this.toUpdate.addAll(toUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        PluginDownloadTask pluginDownloadTask = this;
        synchronized (pluginDownloadTask) {
            if (this.downloadConnection != null) {
                this.downloadConnection.disconnect();
            }
        }
    }

    @Override
    protected void finish() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void download(PluginInformation pi, File file) throws PluginDownloadException {
        block36: {
            if (pi.mainversion > Version.getInstance().getVersion()) {
                ExtendedDialog dialog = new ExtendedDialog(this.progressMonitor.getWindowParent(), I18n.tr("Skip Download", new Object[0]), I18n.tr("Download Plugin", new Object[0]), I18n.tr("Skip Download", new Object[0]));
                dialog.setContent(I18n.tr("JOSM version {0} required for plugin {1}.", pi.mainversion, pi.name));
                dialog.setButtonIcons("download", "cancel");
                if (dialog.showDialog().getValue() != 1) {
                    throw new PluginDownloadException(I18n.tr("Download skipped", new Object[0]));
                }
            }
            try {
                if (pi.downloadlink == null) {
                    String msg = I18n.tr("Cannot download plugin ''{0}''. Its download link is not known. Skipping download.", pi.name);
                    Logging.warn(msg);
                    throw new PluginDownloadException(msg);
                }
                URL url = new URL(pi.downloadlink);
                Logging.debug("Download plugin {0} from {1}...", pi.name, url);
                if ("https".equals(url.getProtocol()) || "http".equals(url.getProtocol())) {
                    PluginDownloadTask pluginDownloadTask = this;
                    synchronized (pluginDownloadTask) {
                        this.downloadConnection = HttpClient.create(url).setAccept(PLUGIN_MIME_TYPES);
                        this.downloadConnection.connect();
                    }
                    try (InputStream in = this.downloadConnection.getResponse().getContent();){
                        Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        break block36;
                    }
                }
                try (InputStream in = url.openConnection().getInputStream();){
                    Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (MalformedURLException e) {
                String msg = I18n.tr("Cannot download plugin ''{0}''. Its download link ''{1}'' is not a valid URL. Skipping download.", pi.name, pi.downloadlink);
                Logging.warn(msg);
                throw new PluginDownloadException(msg, e);
            }
            catch (IOException e) {
                if (this.canceled) {
                    return;
                }
                throw new PluginDownloadException(e);
            }
            finally {
                PluginDownloadTask pluginDownloadTask = this;
                synchronized (pluginDownloadTask) {
                    this.downloadConnection = null;
                }
            }
        }
    }

    @Override
    protected void realRun() throws SAXException, IOException {
        File pluginDir = Main.pref.getPluginsDirectory();
        if (!pluginDir.exists() && !pluginDir.mkdirs()) {
            String message = I18n.tr("Failed to create plugin directory ''{0}''", pluginDir.toString());
            this.lastException = new PluginDownloadException(message);
            Logging.error(message);
            this.failed.addAll(this.toUpdate);
            return;
        }
        this.getProgressMonitor().setTicksCount(this.toUpdate.size());
        for (PluginInformation d : this.toUpdate) {
            if (this.canceled) {
                return;
            }
            String message = I18n.tr("Downloading Plugin {0}...", d.name);
            Logging.info(message);
            this.progressMonitor.subTask(message);
            this.progressMonitor.worked(1);
            File pluginFile = new File(pluginDir, d.name + ".jar.new");
            try {
                this.download(d, pluginFile);
            }
            catch (PluginDownloadException e) {
                this.lastException = e;
                Logging.error(e);
                this.failed.add(d);
                continue;
            }
            this.downloaded.add(d);
        }
        PluginHandler.installDownloadedPlugins(this.toUpdate, false);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public Collection<PluginInformation> getFailedPlugins() {
        return this.failed;
    }

    public Collection<PluginInformation> getDownloadedPlugins() {
        return this.downloaded;
    }

    public Exception getLastException() {
        return this.lastException;
    }
}

