/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.plugins.PluginClassLoader;
import org.openstreetmap.josm.plugins.PluginException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginProxy;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class PluginInformation {
    public File file;
    public String name;
    public int mainversion;
    public int localmainversion;
    public String className;
    public boolean oldmode;
    public String requires;
    public String localrequires;
    public String link;
    public String description;
    public boolean early;
    public String author;
    public int stage = 50;
    public String version;
    public String localversion;
    public String downloadlink;
    public String iconPath;
    private ImageProvider icon;
    public boolean canloadatruntime;
    public List<URL> libraries = new LinkedList<URL>();
    public final Map<String, String> attr = new TreeMap<String, String>();
    final List<String> invalidManifestEntries = new ArrayList<String>();
    private static final ImageIcon emptyIcon = ImageProvider.getEmpty(ImageProvider.ImageSizes.LARGEICON);

    public PluginInformation(File file) throws PluginException {
        this(file, file.getName().substring(0, file.getName().length() - 4));
    }

    public PluginInformation(File file, String name) throws PluginException {
        if (!PluginHandler.isValidJar(file)) {
            throw new PluginException(I18n.tr("Invalid jar file ''{0}''", file));
        }
        this.name = name;
        this.file = file;
        try (InputStream fis = Files.newInputStream(file.toPath(), new OpenOption[0]);
             JarInputStream jar = new JarInputStream(fis);){
            Manifest manifest = jar.getManifest();
            if (manifest == null) {
                throw new PluginException(I18n.tr("The plugin file ''{0}'' does not include a Manifest.", file.toString()));
            }
            this.scanManifest(manifest, false);
            this.libraries.add(0, Utils.fileToURL(file));
        }
        catch (IOException | InvalidPathException e) {
            throw new PluginException(name, e);
        }
    }

    public PluginInformation(InputStream manifestStream, String name, String url) throws PluginException {
        this.name = name;
        try {
            Manifest manifest = new Manifest();
            manifest.read(manifestStream);
            if (url != null) {
                this.downloadlink = url;
            }
            this.scanManifest(manifest, url != null);
        }
        catch (IOException e) {
            throw new PluginException(name, e);
        }
    }

    public void updateFromPluginSite(PluginInformation other) {
        this.mainversion = other.mainversion;
        this.className = other.className;
        this.requires = other.requires;
        this.link = other.link;
        this.description = other.description;
        this.early = other.early;
        this.author = other.author;
        this.stage = other.stage;
        this.version = other.version;
        this.downloadlink = other.downloadlink;
        this.icon = other.icon;
        this.iconPath = other.iconPath;
        this.canloadatruntime = other.canloadatruntime;
        this.libraries = other.libraries;
        this.attr.clear();
        this.attr.putAll(other.attr);
        this.invalidManifestEntries.clear();
        this.invalidManifestEntries.addAll(other.invalidManifestEntries);
    }

    public void updateFromJar(PluginInformation other) {
        this.updateLocalInfo(other);
        if (other.icon != null) {
            this.icon = other.icon;
        }
        this.early = other.early;
        this.className = other.className;
        this.canloadatruntime = other.canloadatruntime;
        this.libraries = other.libraries;
        this.stage = other.stage;
        this.file = other.file;
    }

    private void scanManifest(Manifest manifest, boolean oldcheck) {
        String lang = LanguageInfo.getLanguageCodeManifest();
        Attributes attr = manifest.getMainAttributes();
        this.className = attr.getValue("Plugin-Class");
        String s = Optional.ofNullable(attr.getValue(lang + "Plugin-Link")).orElseGet(() -> attr.getValue("Plugin-Link"));
        if (s != null && !Utils.isValidUrl(s)) {
            Logging.info(I18n.tr("Invalid URL ''{0}'' in plugin {1}", s, this.name));
            s = null;
        }
        this.link = s;
        this.requires = attr.getValue("Plugin-Requires");
        s = attr.getValue(lang + "Plugin-Description");
        if (s == null) {
            s = attr.getValue("Plugin-Description");
            if (s != null) {
                try {
                    s = I18n.tr(s, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    Logging.debug(e);
                    Logging.info(I18n.tr("Invalid plugin description ''{0}'' in plugin {1}", s, this.name));
                }
            }
        } else {
            s = MessageFormat.format(s, null);
        }
        this.description = s;
        this.early = Boolean.parseBoolean(attr.getValue("Plugin-Early"));
        String stageStr = attr.getValue("Plugin-Stage");
        this.stage = stageStr == null ? 50 : Integer.parseInt(stageStr);
        this.version = attr.getValue("Plugin-Version");
        s = attr.getValue("Plugin-Mainversion");
        if (s != null) {
            try {
                this.mainversion = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                Logging.warn(I18n.tr("Invalid plugin main version ''{0}'' in plugin {1}", s, this.name));
            }
        } else {
            Logging.warn(I18n.tr("Missing plugin main version in plugin {0}", this.name));
        }
        this.author = attr.getValue("Author");
        this.iconPath = attr.getValue("Plugin-Icon");
        if (this.iconPath != null) {
            if (this.file != null) {
                this.icon = new ImageProvider(this.iconPath).setArchive(this.file).setMaxSize(ImageProvider.ImageSizes.LARGEICON).setOptional(true);
            } else if (this.iconPath.startsWith("data:")) {
                this.icon = new ImageProvider(this.iconPath).setMaxSize(ImageProvider.ImageSizes.LARGEICON).setOptional(true);
            }
        }
        this.canloadatruntime = Boolean.parseBoolean(attr.getValue("Plugin-Canloadatruntime"));
        int myv = Version.getInstance().getVersion();
        for (Map.Entry<Object, Object> entry : attr.entrySet()) {
            String string = ((Attributes.Name)entry.getKey()).toString();
            if (!string.endsWith("_Plugin-Url")) continue;
            try {
                int mv = Integer.parseInt(string.substring(0, string.length() - 11));
                String v = (String)entry.getValue();
                int i = v.indexOf(59);
                if (i <= 0) {
                    this.invalidManifestEntries.add(string);
                    continue;
                }
                if (!oldcheck || this.mainversion <= Version.getInstance().getVersion() || mv > myv || mv <= this.mainversion && this.mainversion <= myv) continue;
                this.downloadlink = v.substring(i + 1);
                this.mainversion = mv;
                this.version = v.substring(0, i);
                this.oldmode = true;
            }
            catch (IndexOutOfBoundsException | NumberFormatException e) {
                this.invalidManifestEntries.add(string);
                Logging.error(e);
            }
        }
        String classPath = attr.getValue(Attributes.Name.CLASS_PATH);
        if (classPath != null) {
            for (String entry : classPath.split(" ")) {
                File entryFile = new File(entry).isAbsolute() || this.file == null ? new File(entry) : new File(this.file.getParent(), entry);
                this.libraries.add(Utils.fileToURL(entryFile));
            }
        }
        for (Object e : attr.keySet()) {
            this.attr.put(e.toString(), attr.getValue(e.toString()));
        }
    }

    public String getDescriptionAsHtml() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("<html><body>").append(this.description == null ? I18n.tr("no description available", new Object[0]) : Utils.escapeReservedCharactersHTML(this.description));
        if (this.link != null) {
            sb.append(" <a href=\"").append(this.link).append("\">").append(I18n.tr("More info...", new Object[0])).append("</a>");
        }
        if (!(this.downloadlink == null || this.downloadlink.startsWith("http://svn.openstreetmap.org/applications/editors/josm/dist/") || this.downloadlink.startsWith("https://svn.openstreetmap.org/applications/editors/josm/dist/") || this.downloadlink.startsWith("http://trac.openstreetmap.org/browser/applications/editors/josm/dist/") || this.downloadlink.startsWith("https://github.com/JOSM/"))) {
            sb.append("<p>&nbsp;</p><p>").append(I18n.tr("<b>Plugin provided by an external source:</b> {0}", this.downloadlink)).append("</p>");
        }
        sb.append("</body></html>");
        return sb.toString();
    }

    public PluginProxy load(Class<?> klass, PluginClassLoader classLoader) throws PluginException {
        try {
            Constructor<?> c = klass.getConstructor(PluginInformation.class);
            Object plugin = c.newInstance(this);
            return new PluginProxy(plugin, this, classLoader);
        }
        catch (ReflectiveOperationException e) {
            throw new PluginException(this.name, e);
        }
    }

    public Class<?> loadClass(ClassLoader classLoader) throws PluginException {
        if (this.className == null) {
            return null;
        }
        try {
            return Class.forName(this.className, true, classLoader);
        }
        catch (ClassCastException | ClassNotFoundException | NoClassDefFoundError e) {
            throw new PluginException(this.name, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PluginInformation findPlugin(String pluginName) throws PluginException {
        String s;
        File pluginFile;
        Object object;
        String name = pluginName;
        name = name.replaceAll("[-. ]", "");
        try {
            InputStream manifestStream;
            block9: {
                PluginInformation pluginInformation;
                block10: {
                    manifestStream = PluginInformation.class.getResourceAsStream("/org/openstreetmap/josm/plugins/" + name + "/MANIFEST.MF");
                    object = null;
                    try {
                        if (manifestStream == null) break block9;
                        pluginInformation = new PluginInformation(manifestStream, pluginName, null);
                        if (manifestStream == null) break block10;
                    }
                    catch (Throwable throwable) {
                        try {
                            object = throwable;
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            if (manifestStream != null) {
                                PluginInformation.$closeResource((Throwable)object, manifestStream);
                            }
                            throw throwable2;
                        }
                    }
                    PluginInformation.$closeResource((Throwable)object, manifestStream);
                }
                return pluginInformation;
            }
            if (manifestStream != null) {
                PluginInformation.$closeResource(object, manifestStream);
            }
        }
        catch (IOException e) {
            Logging.warn(e);
        }
        Collection<String> locations = PluginInformation.getPluginLocations();
        object = locations.iterator();
        do {
            if (object.hasNext()) continue;
            return null;
        } while (!(pluginFile = new File(s = object.next(), pluginName + ".jar")).exists());
        return new PluginInformation(pluginFile);
    }

    public static Collection<String> getPluginLocations() {
        Collection<String> locations = Main.pref.getAllPossiblePreferenceDirs();
        ArrayList<String> all = new ArrayList<String>(locations.size());
        for (String s : locations) {
            all.add(s + "plugins");
        }
        return all;
    }

    public boolean isUpdateRequired(String referenceVersion) {
        if (this.downloadlink == null) {
            return false;
        }
        if (this.version == null && referenceVersion != null) {
            return true;
        }
        return this.version != null && !this.version.equals(referenceVersion);
    }

    public boolean isUpdateRequired() {
        if (this.downloadlink == null) {
            return false;
        }
        if (this.localversion == null) {
            return true;
        }
        return this.isUpdateRequired(this.localversion);
    }

    protected boolean matches(String filter, String value) {
        if (filter == null) {
            return true;
        }
        if (value == null) {
            return false;
        }
        return value.toLowerCase(Locale.ENGLISH).contains(filter.toLowerCase(Locale.ENGLISH));
    }

    public boolean matches(String filter) {
        String[] words;
        if (filter == null) {
            return true;
        }
        for (String word : words = filter.split("\\s+")) {
            if (!this.matches(word, this.name) && !this.matches(word, this.description) && !this.matches(word, this.version) && !this.matches(word, this.localversion)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ImageIcon getScaledIcon() {
        ImageIcon img;
        ImageIcon imageIcon = img = this.icon != null ? this.icon.get() : null;
        if (img == null) {
            return emptyIcon;
        }
        return img;
    }

    public final String toString() {
        return this.getName();
    }

    private static List<String> getRequiredPlugins(String pluginList) {
        ArrayList<String> requiredPlugins = new ArrayList<String>();
        if (pluginList != null) {
            for (String s : pluginList.split(";")) {
                String plugin = s.trim();
                if (plugin.isEmpty()) continue;
                requiredPlugins.add(plugin);
            }
        }
        return requiredPlugins;
    }

    public List<String> getRequiredPlugins() {
        return PluginInformation.getRequiredPlugins(this.requires);
    }

    public List<String> getLocalRequiredPlugins() {
        return PluginInformation.getRequiredPlugins(this.localrequires);
    }

    public void updateLocalInfo(PluginInformation info) {
        if (info != null) {
            this.localversion = info.version;
            this.localmainversion = info.mainversion;
            this.localrequires = info.requires;
        }
    }
}

